/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.TreeMap;
import spec.harness.results.TestResult;
import spec.reporter.BenchmarkRecord;
import spec.reporter.Utils;
import spec.reporter.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainWriter
extends Writer {
    public PlainWriter(String outputFileName) {
        super(outputFileName);
        this.setType("plain");
    }

    private void handleIterRecord(BenchmarkRecord records) {
        Formatter formatter = new Formatter(this.stream);
        for (int i = 0; i < records.iterRecords.size(); ++i) {
            BenchmarkRecord.IterationRecord iterRecord = records.iterRecords.get(i);
            this.stream.println();
            formatter.format("%1$-30s%2$-15s%3$-15s%4$-15s", records.name, iterRecord.iterName, iterRecord.expectedRunTime, iterRecord.runTime);
            if (iterRecord.isValidIteration()) {
                formatter.format("%1$-15.2f%2$-15.2f", iterRecord.operations, iterRecord.score);
                continue;
            }
            this.stream.print(iterRecord.errors);
        }
        this.stream.println();
    }

    @Override
    public void handleBenchmarkRecord(BenchmarkRecord record) {
        if (!"check".equals(record.name)) {
            this.handleIterRecord(record);
        } else {
            if (record.isValidRun()) {
                this.stream.println("PASSED");
            } else if (record.iterRecords != null && record.iterRecords.size() > 0) {
                this.stream.println("FAILED");
            }
            this.stream.println();
            Formatter formatter = new Formatter(this.stream);
            formatter.format("%1$-30s%2$-15s%3$-15s%4$-15s%5$-15s%6$-15s", "Benchmark", "Iteration", "Expected(ms)", "Actual(ms)", "Operations", "ops/m");
            this.stream.println();
            this.stream.println("---------------------------------------------------------------------------------------------------");
        }
    }

    @Override
    public void insertRecord(String prop, String value) {
        Formatter formatter = new Formatter(this.stream);
        formatter.format("%1$-30s%2$-40s", prop, value);
        this.stream.println();
    }

    @Override
    public void putHat(String runStatus, String compositeScore, String workloadName, String category, String hwVendor, String jvmVendor, String hwModel, String jvmName, String submitter, String testDate, String jvmVersion) {
        this.stream.println("================================");
        this.stream.println(workloadName);
        this.stream.println("================================");
        this.stream.println(hwVendor + " " + hwModel);
        this.stream.println(jvmVendor + " " + jvmName);
        this.stream.println("Tested by: " + submitter + " Test date: " + testDate);
        this.stream.println(runStatus);
    }

    @Override
    public void putSummaryTable(String scoreString, TreeMap<String, Double> scores) {
        this.stream.println();
        this.stream.println("================================");
        for (String key : scores.keySet()) {
            this.insertRecord(key, Utils.formatScore(scores.get(key)));
        }
        this.stream.println(scoreString);
        this.stream.println("================================");
        this.stream.println();
        this.stream.println();
    }

    @Override
    public void startDetailsTable() {
        this.stream.println();
        this.stream.println("Details of Runs");
        this.stream.println("---------------");
    }

    @Override
    public void insertRecords(ArrayList violations) {
        if (violations != null) {
            this.stream.println();
            for (int i = 0; i < violations.size(); ++i) {
                this.stream.println(TestResult.correctContent((String)violations.get(i), false));
            }
        }
        this.stream.print("");
    }

    @Override
    public String getCopyRightSign() {
        return "(C)";
    }
}

