/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.ArrayList;
import java.util.TreeMap;
import spec.harness.results.TestResult;
import spec.reporter.BenchmarkRecord;
import spec.reporter.ReportGenerator;
import spec.reporter.Utils;
import spec.reporter.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLWriter
extends Writer {
    static String indentStep = "    ";
    String[] indents = HTMLWriter.initIndents();
    int indentIndex = 0;
    String currentIndent = "";

    private static String[] initIndents() {
        String[] results = new String[20];
        results[0] = "";
        for (int i = 1; i < results.length; ++i) {
            results[i] = results[i - 1] + indentStep;
        }
        return results;
    }

    public HTMLWriter(String outputFileName) {
        super(outputFileName);
        this.setType("html");
    }

    @Override
    public void startTable(String header, boolean isBorderVisible, boolean needHeader, boolean putOnlyTableTag) {
        this.putTABLE(true, "WIDTH=100% " + (isBorderVisible ? "BORDER=1" : ""));
        if (!putOnlyTableTag) {
            this.putTHEAD(true);
            this.putColumnsSpec(new int[]{50, 50});
            if (needHeader) {
                this.insertHeaderRecord(header, "CENTER", true, 2, 1);
            }
            this.putTHEAD(false);
            this.putTBODY(true);
        }
    }

    @Override
    public void startTable(String header, boolean needHeader) {
        this.startTable(header, true, true, false);
    }

    private void startTable(boolean isBorderVisible) {
        this.startTable(null, isBorderVisible, false, true);
    }

    private void insertImgData(String imgName, String alignment, int rowSpan) {
        this.insertHeaderData("<IMG src=\"images/" + imgName + ".jpg\"> </IMG>", alignment, false, rowSpan, 0);
    }

    @Override
    public void startDetailsTable() {
        this.startTable(true);
        this.putTHEAD(true);
        this.putColumnsSpec(new int[]{10, 15, 10, 10, 10, 10, 10, 25});
        this.insertHeaderRecord("Details of Runs", "CENTER", true, 8, 3);
        this.startRecord();
        for (int i = 0; i < 8; ++i) {
            this.insertHeaderData(Utils.DETAILS_TABLE_COLUMNS_NAMES[i], "LEFT", true, 1, 1);
        }
        this.endRecord();
        this.putTHEAD(false);
        this.putTBODY(true);
    }

    private void insertData(String data) {
        this.putString("<TD>" + data + "</TD>");
    }

    private void insertData(String data, int incFont) {
        this.insertData("<FONT SIZE=+" + incFont + ">" + data + "</FONT>");
    }

    @Override
    public void insertRecord(String prop, String value) {
        this.startRecord();
        this.putString("<TD ALIGN=LEFT>" + prop + "</TD>");
        this.putString("<TD ALIGN=LEFT>" + value + "</TD>");
        this.endRecord();
    }

    private void insertHeaderData(String value, String alignment, boolean isColSpan, int colSpan, int incFont, String attrs) {
        this.putString("<TD " + attrs + " ALIGN=" + alignment + " " + (colSpan > 1 ? (isColSpan ? "COL" : "ROW") + "SPAN=" + colSpan + "> " : ">") + (incFont != 0 ? "<FONT SIZE=+" + incFont + ">" : "") + value + (incFont != 0 ? "</FONT>" : "") + "</TD>");
    }

    private void insertHeaderData(String value, String alignment, boolean isColSpan, int colSpan, int incFont) {
        this.insertHeaderData(value, alignment, isColSpan, colSpan, incFont, "");
    }

    private void insertHeaderRecord(String value, String alignment, boolean isColumnSpan, int span, int fontInc) {
        this.putString("<TR>");
        this.incIndent();
        this.insertHeaderData(value, alignment, isColumnSpan, span, fontInc);
        this.decIndent();
        this.putString("</TR>");
    }

    private void startRecord() {
        this.putString("<TR>");
        this.incIndent();
    }

    private void endRecord() {
        this.decIndent();
        this.putString("</TR>");
    }

    private void endAndStartRecord() {
        this.endRecord();
        this.startRecord();
    }

    private void putColumnsSpec(int[] percents) {
        for (int i = 0; i < percents.length; ++i) {
            this.putString("   <COL width = " + percents[i] + "%>");
        }
    }

    @Override
    public void putSummaryTable(String scoreString, TreeMap<String, Double> scores) {
        this.startTable(true);
        this.putTHEAD(true);
        this.putColumnsSpec(new int[]{20, 20, 55});
        this.putTHEAD(false);
        this.putTBODY(true);
        this.startRecord();
        this.insertData("Benchmark", 1);
        this.insertData("ops/m", 1);
        this.insertImgData("all", "CENTER", scores.size() + 2);
        this.endRecord();
        for (String key : scores.keySet()) {
            this.insertRecord(key, Utils.formatScore(scores.get(key)));
        }
        this.insertHeaderRecord(scoreString, "RIGHT", true, 2, 1);
        this.endTable(true);
    }

    @Override
    public void putHat(String runStatus, String compositeScore, String workloadName, String category, String hwVendor, String jvmVendor, String hwModel, String jvmName, String submitter, String testDate, String jvmVersion) {
        this.startTable("", false, false, true);
        this.startRecord();
        this.startData();
        if (ReportGenerator.specLogo != null) {
            this.insertHeaderData("<IMG SRC=\"" + ReportGenerator.specLogo + "\">&nbsp;&nbsp;", "CENTER", false, 2, 0);
            this.endAndStartData();
        }
        this.startTable("", false, false, false);
        this.startRecord();
        this.insertHeaderData("<FONT SIZE=+3 COLOR=BLUE>" + workloadName + "</FONT>", "LEFT", false, 2, 0);
        this.insertHeaderData("<B>" + compositeScore, "RIGHT", true, 2, 1);
        this.endAndStartRecord();
        this.insertHeaderData("<FONT COLOR=BLACK><B>", "RIGHT", false, 1, 0, "BGCOLOR=LIGHTBLUE");
        this.endRecord();
        this.insertHeaderRecord(hwVendor + " " + hwModel, "LEFT", true, 1, 1);
        this.insertHeaderRecord(jvmVendor + " " + jvmName, "LEFT", true, 1, 1);
        this.startRecord();
        this.insertHeaderData("Tested by: " + submitter, "LEFT", true, 1, 1);
        this.insertHeaderData(runStatus, "RIGHT", false, 2, 3);
        this.endRecord();
        this.insertHeaderRecord("Test date: " + testDate, "LEFT", true, 1, 1);
        this.endTable();
        this.endData();
        this.endRecord();
        this.endTable(true);
    }

    private void endData() {
        this.decIndent();
        this.putString("</TD>");
    }

    private void startData() {
        this.putString("<TD>");
        this.incIndent();
    }

    @Override
    public void startRecordAndData() {
        this.startRecord();
        this.startData();
    }

    private void putTHEAD(boolean isStart) {
        if (isStart) {
            this.putString("<THEAD>");
            this.incIndent();
        } else {
            this.decIndent();
            this.putString("</THEAD>");
        }
    }

    private void putTBODY(boolean isStart) {
        if (isStart) {
            this.putString("<TBODY>");
            this.incIndent();
        } else {
            this.decIndent();
            this.putString("</TBODY>");
        }
    }

    private void putTABLE(boolean isStart, String attrs) {
        if (isStart) {
            this.putString("<TABLE " + attrs + ">");
            this.incIndent();
        } else {
            this.decIndent();
            this.putString("</TABLE>");
        }
    }

    @Override
    public void endRecordAndData() {
        this.endData();
        this.endRecord();
    }

    @Override
    public void endAndStartRecordAndData() {
        this.endData();
        this.endAndStartRecord();
        this.startData();
    }

    @Override
    public void endAndStartData() {
        this.endData();
        this.startData();
    }

    @Override
    public void endTable() {
        this.endTable(false);
    }

    @Override
    public void endTable(boolean putOnlyTable) {
        if (putOnlyTable) {
            this.putTBODY(false);
        }
        this.putTABLE(false, "");
    }

    private void incIndent() {
        this.currentIndent = this.indents[++this.indentIndex];
    }

    private void decIndent() {
        this.currentIndent = this.indents[--this.indentIndex];
    }

    private void putString(String str) {
        this.stream.println(this.currentIndent + str);
    }

    private void handleIterRecord(ArrayList iterationsRecords, int index) {
        BenchmarkRecord.IterationRecord iterRecord = (BenchmarkRecord.IterationRecord)iterationsRecords.get(index);
        this.insertData(iterRecord.iterName);
        this.insertData(iterRecord.expectedRunTime == null ? "-" : iterRecord.expectedRunTime);
        this.insertData(Long.toString(iterRecord.runTime));
        if (iterRecord.isValidIteration()) {
            this.insertData(Utils.df.format(iterRecord.operations));
            this.insertData(Utils.df.format(iterRecord.score));
        } else {
            this.insertHeaderData(this.insertBRTags(iterRecord.errors), "LEFT", true, 3, 0);
        }
    }

    private String createConfRecord(String[] props) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < props.length; ++i) {
            if (props[i] == null) continue;
            result.append(Utils.DETAILS_TABLE_BM_CONF_NAMES[i] + ": ");
            result.append(props[i]);
            if (i == props.length - 1) continue;
            result.append("<BR>");
        }
        return result.toString();
    }

    @Override
    public void handleBenchmarkRecord(BenchmarkRecord record) {
        this.startRecord();
        int iterations = record.iterRecords.size();
        this.insertHeaderData(record.name, "LEFT", false, iterations, 0);
        if (!"check".equals(record.name) && iterations > 0) {
            this.insertHeaderData(this.createConfRecord(record.configuration), "LEFT", false, iterations, 0);
            this.handleIterRecord(record.iterRecords, 0);
            if (record.isValidRun()) {
                this.insertHeaderData("<IMG src=\"" + Utils.getImageName(record.name + "_results") + "\"> </IMG> <A href=\"" + Utils.getImageName(record.name) + "\"> details </A>", "LEFT", false, iterations, 0);
            }
            this.endRecord();
            for (int i = 1; i < record.iterRecords.size(); ++i) {
                this.startRecord();
                this.handleIterRecord(record.iterRecords, i);
                this.endRecord();
            }
            String result = record.isValidRun() ? "ops/m: " + Utils.df.format(record.maxScore) : "Invalid run";
            this.insertHeaderRecord(result, "RIGHT", true, 8, 1);
        } else {
            String data = "";
            if (record.isValidRun()) {
                data = "PASSED";
            } else if (record.iterRecords != null && record.iterRecords.size() > 0) {
                BenchmarkRecord.IterationRecord iterRecord = record.iterRecords.get(0);
                data = "FAILED: <BR>" + this.insertBRTags(iterRecord.errors);
            }
            this.insertHeaderData(data, "Left", true, 7, 1);
            this.endRecord();
        }
    }

    private String insertBRTags(ArrayList values) {
        if (values != null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    result.append("<BR>");
                }
                result.append(TestResult.correctContent((String)values.get(i), false));
            }
            return result.toString();
        }
        return "";
    }

    @Override
    public void insertRecords(ArrayList al) {
        this.insertHeaderRecord(this.insertBRTags(al), "LEFT", true, 2, 0);
    }

    @Override
    public void startReport() {
        this.putString("<HTML>");
        this.incIndent();
        this.putString("<HEAD>");
        this.incIndent();
        this.putString("<META NAME=\"GENERATOR\" CONTENT=\"SPEC Java Reporter\">");
        this.putString("<TITLE> SPECjvm2008</TITLE>");
        this.decIndent();
        this.putString("</HEAD>");
        this.putString("<BODY >");
        this.incIndent();
    }

    @Override
    public void endReport() {
        this.decIndent();
        this.putString("</BODY>");
        this.decIndent();
        this.putString("</HTML>");
    }

    @Override
    public String getCopyRightSign() {
        return "\\&copy;";
    }
}

