/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.ArrayList;
import spec.reporter.Utils;

public class BenchmarkRecord {
    String name;
    String iterationsInfo;
    ArrayList<IterationRecord> iterRecords = new ArrayList();
    double maxScore = Double.MIN_VALUE;
    String[] configuration = new String[Utils.BM_CONFIGURATION_ENAMES.length];
    boolean isSubgroupMember;

    public BenchmarkRecord(String name, int numberBmThreads) {
        this.name = name;
        this.isSubgroupMember = name.indexOf(".") >= 0;
    }

    public void startHandling(String info) {
        this.iterationsInfo = info;
    }

    public IterationRecord addIterationRecord(String iter, String expectedRunTime, String startTime, String endTime, String operations) {
        String key = "warmup-result".equals(this.iterationsInfo) ? "warmup" : "iteration " + iter;
        IterationRecord record = new IterationRecord(key, expectedRunTime, startTime, endTime, operations);
        if (!key.equals("warmup")) {
            this.maxScore = Math.max(this.maxScore, record.score);
        }
        this.iterRecords.add(record);
        return record;
    }

    public void printAllRecordedInfo() {
        for (int i = 0; i < this.iterRecords.size(); ++i) {
            IterationRecord record = this.iterRecords.get(i);
            System.out.println(record.iterName + " " + record.runTime + " " + record.operations);
        }
    }

    public boolean isValidRun() {
        boolean result = true;
        for (int i = 0; i < this.iterRecords.size(); ++i) {
            result &= this.iterRecords.get(i).isValidIteration();
        }
        return result;
    }

    static class IterationRecord {
        long runTime;
        String iterName;
        double operations;
        double score;
        String expectedRunTime;
        ArrayList<String> errors;

        public IterationRecord(String iterName, String expectedRunTime, String startTime, String endTime, String operations) {
            this.iterName = iterName;
            this.runTime = Long.parseLong(endTime) - Long.parseLong(startTime);
            this.operations = Double.parseDouble(operations);
            this.score = Double.parseDouble(operations) * 60000.0 / (double)this.runTime;
            this.expectedRunTime = expectedRunTime;
        }

        final boolean isValidIteration() {
            return this.errors == null;
        }

        final void addError(String message) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(message);
        }
    }
}

