/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import spec.reporter.BenchmarkRecord;
import spec.reporter.Utils;

public class BenchmarkGroupRecords {
    TreeMap<String, BenchmarkGroupRecord> groupRecords = new TreeMap();
    int validBenchmarksNumber;
    boolean allBenchmarksValid = true;
    TreeMap<String, Double> scores = new TreeMap();

    void addNewBenchmarkRecord(BenchmarkRecord record) {
        if (record.isValidRun() && !"check".equals(record.name) && !"check".equals(record.name)) {
            ++this.validBenchmarksNumber;
        }
        this.allBenchmarksValid = this.allBenchmarksValid && record.isValidRun();
        int index = record.name.indexOf(".");
        if (index >= 0) {
            String subgroup = record.name.substring(0, index);
            if (Utils.isScimarkLarge(record)) {
                subgroup = subgroup + ".large";
            } else if (Utils.isScimarkSmall(record)) {
                subgroup = subgroup + ".small";
            }
            if (Utils.isScimarkMonteCarlo(record)) {
                this.updateGroupRecord("scimark.small", record);
                this.updateGroupRecord("scimark.large", record);
            } else {
                this.updateGroupRecord(subgroup, record);
            }
        } else {
            this.groupRecords.put(record.name, new BenchmarkGroupRecord(record));
        }
    }

    double computeCompositeScore() {
        Iterator<String> iter = this.groupRecords.keySet().iterator();
        double product = 1.0;
        int counter = 0;
        while (iter.hasNext()) {
            String key = iter.next();
            BenchmarkGroupRecord r = this.groupRecords.get(key);
            if (r.bmRecords.size() <= 0 || Utils.isCheck(r.bmRecords.get(0))) continue;
            double groupScore = r.computeScore();
            Utils.dbgPrint("geo_mean: " + r.groupName + " " + groupScore);
            product *= groupScore;
            ++counter;
            this.scores.put(r.groupName, groupScore);
        }
        if (counter == 0) {
            return 1.0;
        }
        double compositeScore = this.allBenchmarksValid ? Math.pow(product, 1.0 / (double)counter) : Utils.INVALID_SCORE;
        Utils.dbgPrint("composite score: " + compositeScore);
        return compositeScore;
    }

    private void updateGroupRecord(String name, BenchmarkRecord record) {
        if (!this.groupRecords.containsKey(name)) {
            this.groupRecords.put(name, new BenchmarkGroupRecord(name));
        }
        this.groupRecords.get(name).addBenchmarkRecord(record);
    }

    class BenchmarkResultsIterator {
        Iterator iter;
        BenchmarkGroupRecord currentGroupRecord;
        BenchmarkRecord currentRecord;
        int currentIndex;
        boolean wasMonteCarlo;

        public BenchmarkResultsIterator() {
            this.iter = BenchmarkGroupRecords.this.groupRecords.keySet().iterator();
        }

        BenchmarkRecord next() {
            this.currentRecord = null;
            if (this.currentGroupRecord != null && this.currentGroupRecord.bmRecords.size() > this.currentIndex) {
                this.currentRecord = this.currentGroupRecord.bmRecords.get(this.currentIndex++);
            } else {
                while (this.iter.hasNext()) {
                    String key = (String)this.iter.next();
                    this.currentGroupRecord = BenchmarkGroupRecords.this.groupRecords.get(key);
                    if (this.currentGroupRecord.bmRecords.size() <= 0) continue;
                    this.currentIndex = 0;
                    this.currentRecord = this.currentGroupRecord.bmRecords.get(this.currentIndex++);
                    break;
                }
            }
            if (Utils.isScimarkMonteCarlo(this.currentRecord)) {
                if (!this.wasMonteCarlo) {
                    this.wasMonteCarlo = true;
                } else {
                    return this.next();
                }
            }
            return this.currentRecord;
        }

        BenchmarkRecord getCurrentRecord() {
            return this.currentRecord;
        }
    }

    static class BenchmarkGroupRecord {
        String groupName;
        boolean isSingleBenchmark;
        ArrayList<BenchmarkRecord> bmRecords = new ArrayList();
        double score;
        boolean isValid = true;

        public BenchmarkGroupRecord(BenchmarkRecord record) {
            this.isSingleBenchmark = true;
            this.bmRecords.add(record);
            this.groupName = record.name;
        }

        public BenchmarkGroupRecord(String name) {
            this.groupName = name;
        }

        void addBenchmarkRecord(BenchmarkRecord bmRecord) {
            this.bmRecords.add(bmRecord);
        }

        double computeScore() {
            if (this.isSingleBenchmark) {
                BenchmarkRecord record = this.bmRecords.get(0);
                this.score = record.maxScore;
                this.isValid = record.isValidRun();
            } else {
                double product = 1.0;
                for (int i = 0; i < this.bmRecords.size(); ++i) {
                    BenchmarkRecord record = this.bmRecords.get(i);
                    this.isValid = this.isValid && record.isValidRun();
                    Utils.dbgPrint("\t" + record.name + " " + this.isValid + " " + record.maxScore);
                    product *= record.maxScore;
                }
                this.score = Math.pow(product, 1.0 / (double)this.bmRecords.size());
            }
            this.score = this.isValid ? this.score : Utils.INVALID_SCORE;
            return this.score;
        }
    }
}

