/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import spec.reporter.Utils;

public class BenchmarkChart {
    private JFreeChart chart;
    private String bname;
    private long startTime;
    private XYSeries totalHeap;
    private XYSeries freeHeap;
    private Hashtable<String, XYSeries> addedSeries = new Hashtable();
    private XYSeriesCollection mainDataset = new XYSeriesCollection();
    private XYPlot plot;
    private HashMap<String, XYSeries> analyzersMap = new HashMap();
    int axisIndex;
    private static Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.BLACK};

    public BenchmarkChart(String bname) {
        this.bname = bname;
        this.chart = ChartFactory.createXYLineChart((String)bname, (String)"time from start (millisec)", (String)"loop result (millisec)", (XYDataset)this.mainDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.plot = this.chart.getXYPlot();
    }

    public void setStartTime(long startTime) {
        if (this.startTime == 0L) {
            this.startTime = startTime;
        }
    }

    public void addTotalHeapInfo(long time, long bytes) {
        if (this.totalHeap == null) {
            this.totalHeap = new XYSeries((Comparable)((Object)"total heap"));
        }
        this.totalHeap.add((double)(time - this.startTime), (double)(bytes / 0x100000L));
    }

    public void addFreeHeapInfo(long time, long bytes) {
        if (this.freeHeap == null) {
            this.freeHeap = new XYSeries((Comparable)((Object)"free heap"));
        }
        this.freeHeap.add((double)(time - this.startTime), (double)(bytes / 0x100000L));
    }

    public void addAnalyzerReport(String name, String unit, long time, long value) {
        if (!this.analyzersMap.containsKey(name)) {
            XYSeries series = new XYSeries((Comparable)((Object)(name + " (" + unit + ")")));
            this.analyzersMap.put(name, series);
            this.addAxis(name, unit, series);
        }
        this.analyzersMap.get(name).add((double)(time - this.startTime), (double)value);
    }

    public void addAxis(String name, String unit, XYSeries series) {
        NumberAxis axis = new NumberAxis(unit);
        ++this.axisIndex;
        this.plot.setRangeAxis(this.axisIndex, (ValueAxis)axis);
        this.plot.setRangeAxisLocation(this.axisIndex, AxisLocation.BOTTOM_OR_RIGHT);
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(series);
        this.plot.setDataset(this.axisIndex, (XYDataset)collection);
        this.plot.mapDatasetToRangeAxis(this.axisIndex, this.axisIndex);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        this.plot.setRenderer(this.axisIndex, (XYItemRenderer)renderer);
        this.plot.getRenderer(this.axisIndex).setPaint((Paint)colors[this.axisIndex % colors.length]);
    }

    public void addTimeInfo(String threadName, long startTime, long endTime) {
        long x = endTime - this.startTime;
        long y = endTime - startTime;
        if (this.addedSeries.containsKey(threadName)) {
            this.addedSeries.get(threadName).add((double)x, (double)y);
        } else {
            XYSeries series = new XYSeries((Comparable)((Object)threadName));
            series.add((double)x, (double)y);
            this.addedSeries.put(threadName, series);
            this.mainDataset.addSeries(series);
        }
    }

    public void addTimeInfo(long startTime, long endTime) {
        long x = endTime - this.startTime;
        long y = endTime - startTime;
        String thr = "x";
        if (this.addedSeries.containsKey(thr)) {
            this.addedSeries.get(thr).add((double)x, (double)y);
        } else {
            XYSeries series = new XYSeries((Comparable)((Object)thr));
            series.add((double)x, (double)y);
            this.addedSeries.put(thr, series);
            this.mainDataset.addSeries(series);
        }
    }

    public void addMarker(long time, String label) {
        ValueMarker currentEnd = new ValueMarker((double)(time - this.startTime));
        currentEnd.setPaint((Paint)Color.BLACK);
        currentEnd.setLabel(label);
        currentEnd.setLabelFont(currentEnd.getLabelFont().deriveFont(1, 16.0f));
        currentEnd.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        currentEnd.setLabelTextAnchor(TextAnchor.HALF_ASCENT_LEFT);
        this.plot.addDomainMarker((Marker)currentEnd);
    }

    private void setMemoryAxis() {
        if (this.totalHeap != null || this.freeHeap != null) {
            ++this.axisIndex;
            this.plot.setRangeAxis(this.axisIndex, (ValueAxis)new NumberAxis("heap, MB"));
            this.plot.setRangeAxisLocation(this.axisIndex, AxisLocation.BOTTOM_OR_RIGHT);
            XYSeriesCollection memusage = new XYSeriesCollection();
            memusage.addSeries(this.freeHeap);
            memusage.addSeries(this.totalHeap);
            this.plot.setDataset(this.axisIndex, (XYDataset)memusage);
            this.plot.mapDatasetToRangeAxis(this.axisIndex, this.axisIndex);
            XYAreaRenderer renderer = new XYAreaRenderer();
            this.plot.setRenderer(this.axisIndex, (XYItemRenderer)renderer);
            renderer.setSeriesPaint(0, (Paint)new Color(247, 174, 185));
            renderer.setSeriesPaint(1, (Paint)new Color(155, 181, 255));
            renderer.setOutline(true);
            renderer.setOutlinePaint((Paint)Color.GRAY);
            this.plot.setForegroundAlpha(0.8f);
        }
    }

    public void buildJPEG() {
        this.setMemoryAxis();
        try {
            this.updateColors();
            ChartUtilities.saveChartAsJPEG((File)new File(Utils.getFullImageName(this.bname)), (JFreeChart)this.chart, (int)900, (int)600);
        }
        catch (Exception e) {
            System.out.println("Problems...");
        }
    }

    private void updateColors() {
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        renderer.setShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setSeriesItemLabelsVisible(0, true);
        this.chart.getXYPlot().setOutlinePaint((Paint)Color.BLACK);
        renderer.setOutlinePaint((Paint)Color.BLACK);
        this.chart.getLegend(0).setBackgroundPaint((Paint)Color.WHITE);
        this.chart.setBorderVisible(true);
        this.chart.setBorderPaint((Paint)Color.BLUE);
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        renderer.setUseFillPaint(true);
        renderer.setFillPaint((Paint)new Color(204, 251, 237));
        for (int i = 0; i < this.addedSeries.size(); ++i) {
            Color paint = (Color)renderer.getSeriesPaint(i);
            renderer.setSeriesPaint(i, (Paint)paint.darker().darker());
        }
    }
}

