/*
 * Decompiled with CFR 0.152.
 */
package spec.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import spec.harness.Context;
import spec.harness.Util;
import spec.harness.results.LoopResult;

public class ValidityCheckOutputStream
extends OutputStream {
    private static final boolean DEBUG = Util.getBoolProperty("specjvm.io.validation.debug", null);
    String benchName;
    ByteArrayOutputStream ostream = new ByteArrayOutputStream(4096);
    int errors = 0;

    public ValidityCheckOutputStream(String benchName) {
        this.benchName = benchName;
    }

    public void write(int b) throws IOException {
        this.ostream.write(b);
        this.flush();
    }

    public boolean validityCheck(LoopResult lResults) {
        try {
            this.validityCheck2(lResults);
        }
        catch (IOException x) {
            String msg = "Error in validityCheck. " + x.getClass().getName() + ": " + x.getMessage();
            lResults.addError(msg);
            ++this.errors;
        }
        return this.errors == 0;
    }

    private void validityCheck2(LoopResult lResults) throws IOException {
        String fileName = ValidityCheckOutputStream.getValidityFileName(this.benchName);
        if (!new File(fileName).exists()) {
            throw new IOException("Can't find validation file " + fileName + ". Verify that the run is done from or the property " + "specjvm.home.dir" + " point to the base dir for SPECjvm2008.");
        }
        BufferedReader in1 = new BufferedReader(new InputStreamReader(Context.getFileCache().getStream(fileName)));
        BufferedReader in2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.ostream.toByteArray())));
        int ln = 1;
        while (this.errors < 50) {
            String l1 = in1.readLine();
            String l2 = in2.readLine();
            if (l1 == null && l2 == null) break;
            if (DEBUG) {
                System.err.println("l1='" + l1 + "'");
                System.err.println("l2='" + l2 + "'");
            }
            if (l1 == null || l2 == null || !l1.equals(l2)) {
                this.handleValidationFailure(lResults, ln, l1, l2);
                ++this.errors;
                break;
            }
            ++ln;
        }
        in1.close();
        in2.close();
    }

    private void handleValidationFailure(LoopResult lResults, int failedLineNo, String el1, String el2) throws IOException {
        int rows = 5;
        String validationFileName = ValidityCheckOutputStream.getValidityFileName(this.benchName);
        String errorLogFileName = Context.getResultDirNameCurrent() + "/" + this.benchName + ".bt" + lResults.getBmThreadId() + ".i" + lResults.getIteration() + ".op" + (lResults.getLoopCnt() + 1) + ".error.log";
        StringBuilder report = new StringBuilder("Validation failure on line " + failedLineNo);
        if (el1 == null) {
            report.append(", more output than expected.\n");
        } else if (el2 == null) {
            report.append(", expected more output.\n");
        } else {
            report.append(".\n");
        }
        report.append("    Expected output: \n");
        BufferedReader in1 = new BufferedReader(new InputStreamReader(Context.getFileCache().getStream(validationFileName)));
        String l1 = in1.readLine();
        int ln = 1;
        while (l1 != null) {
            String lns;
            String string = ln < 10 ? "00" + ln : (lns = ln < 100 ? "0" + ln : "" + ln);
            if (ln > failedLineNo - 2 && ln < failedLineNo + rows) {
                report.append("    [" + lns + "] " + l1 + "\n");
            }
            if (ln == failedLineNo + rows) {
                report.append("    [" + lns + "] ...\n\n");
            }
            l1 = in1.readLine();
            ++ln;
        }
        in1.close();
        report.append("    Received output: \n");
        BufferedReader in2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.ostream.toByteArray())));
        PrintStream ps = new PrintStream(new FileOutputStream(errorLogFileName));
        String l2 = in2.readLine();
        int ln2 = 1;
        while (l2 != null) {
            String lns;
            ps.println(l2);
            String string = ln2 < 10 ? "00" + ln2 : (lns = ln2 < 100 ? "0" + ln2 : "" + ln2);
            if (ln2 > failedLineNo - 2 && ln2 < failedLineNo + rows) {
                report.append("    [" + lns + "] " + l2 + "\n");
            }
            if (ln2 == failedLineNo + rows) {
                report.append("    [" + lns + "] ...\n\n");
            }
            l2 = in2.readLine();
            ++ln2;
        }
        in2.close();
        report.append("Complete output: " + new File(errorLogFileName).getCanonicalPath() + "\n");
        report.append("Validation file: " + new File(validationFileName).getCanonicalPath() + "\n\n");
        lResults.addError(report.toString());
    }

    public static String getValidityFileName(String bmName) {
        return Context.getSpecBasePath() + "/resources/" + bmName + "/" + "validity." + bmName + ".dat";
    }

    public void createValidityFile() {
        try {
            String fullName = ValidityCheckOutputStream.getValidityFileName(this.benchName);
            Context.getOut().println("Opening " + fullName);
            FileOutputStream out = new FileOutputStream(fullName);
            out.write(this.ostream.toByteArray());
            out.close();
        }
        catch (IOException x) {
            Context.getOut().println("Error creating validity check file: " + x);
        }
    }
}

