/*
 * Decompiled with CFR 0.152.
 */
package spec.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import spec.harness.StopBenchmarkException;

public class FileCache {
    private static final int MAX_FILE_SIZE = 0xA00000;
    private HashMap<String, byte[]> cache = new HashMap();

    public ByteArrayInputStream getStream(String fileName) throws IOException {
        if (!this.hasFile(fileName)) {
            this.loadFile(fileName);
        }
        byte[] arr = this.getByteArray(fileName);
        return new ByteArrayInputStream(arr);
    }

    public void discard(String fileName) {
        this.cache.remove(fileName);
    }

    public int getLength(String fileName) {
        return this.getByteArray(fileName).length;
    }

    public void clearCache() {
        this.cache.clear();
    }

    private boolean hasFile(String fileName) {
        return this.cache.get(fileName) != null;
    }

    public byte[] getByteArray(String fileName) {
        byte[] fileArray = this.cache.get(fileName);
        if (fileArray == null) {
            throw new StopBenchmarkException("File '" + fileName + "' not in cache.");
        }
        return fileArray;
    }

    public void loadFile(String fileName) throws IOException {
        byte[] fileArray = this.cache.get(fileName);
        if (fileArray != null) {
            throw new StopBenchmarkException("Should not load file '" + fileName + "' into cache twice.");
        }
        File f = new File(fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("Can't find file: " + fileName);
        }
        long length = f.length();
        if (length >= 0xA00000L) {
            System.err.println("File length: " + length);
            System.err.println("MAX FILE LENGTH: 10485760");
            throw new IOException("File is too large to put in cache (length=" + length + ", max=" + 0xA00000 + "): " + fileName);
        }
        fileArray = new byte[(int)length];
        FileInputStream is = new FileInputStream(f);
        int numRead = 0;
        for (int offset = 0; offset < fileArray.length && (numRead = ((InputStream)is).read(fileArray, offset, fileArray.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        this.cache.put(fileName, fileArray);
    }

    public class CachedFile {
        private String _name;

        public CachedFile(String systemId) {
            this._name = systemId;
        }

        public String getFilename() {
            return this._name;
        }

        public ByteArrayInputStream getStream() throws IOException {
            return FileCache.this.getStream(this._name);
        }

        public void cache() throws IOException {
            FileCache.this.getStream(this._name);
        }

        public void discard() {
            FileCache.this.discard(this._name);
        }

        public InputSource asNewInputSource() throws IOException {
            return new InputSource(this.getStream());
        }

        public StreamSource asNewStreamSource() throws IOException {
            StreamSource source = new StreamSource(this.getStream(), this._name);
            return source;
        }
    }
}

