/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.results;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestResult {
    public static final int ITER = 1;
    public static final int TIMED = 2;
    protected List<String> errors;
    private static final DecimalFormat df = new DecimalFormat("#.##");
    public static final int TAB = 2;
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";

    public abstract void toXml(PrintStream var1, int var2);

    public abstract boolean isValid();

    public abstract List<String> getAllErrors(String var1);

    public List getErrors() {
        return this.errors;
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new LinkedList<String>();
        }
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    protected void printErrorsToXml(PrintStream ps, int indent) {
        if (this.hasErrors()) {
            this.ptxElementOpen(ps, indent, "errors");
            Iterator<String> iter = this.errors.iterator();
            while (iter.hasNext()) {
                this.ptxElement(ps, indent + 2, "error", iter.next());
            }
            this.ptxElementClose(ps, indent, "errors");
        }
    }

    protected void ptxAttrib(PrintStream ps, int indent, String name, String value, boolean condition, String ending) {
        if (condition) {
            ps.print(TestResult.getIndent(indent) + name + "=\"" + value + "\"" + ending);
        }
    }

    protected void ptxAttrib(PrintStream ps, int indent, String name, long value, boolean condition, String ending) {
        this.ptxAttrib(ps, indent, name, Long.toString(value), condition, ending);
    }

    protected void ptxAttrib(PrintStream ps, int indent, String name, double value, boolean condition, String ending) {
        this.ptxAttrib(ps, indent, name, Double.toString(value), condition, ending);
    }

    protected void ptxAttrib(PrintStream ps, int indent, String name, boolean value, boolean condition, String ending) {
        this.ptxAttrib(ps, indent, name, Boolean.toString(value), condition, ending);
    }

    protected void ptxAttrib(PrintStream ps, int indent, String name, String[] value, boolean condition, String ending) {
        this.ptxAttrib(ps, indent, name, this.ptxArrToValue(value), condition, ending);
    }

    protected void ptxElement(PrintStream ps, int indent, String name, String value) {
        ps.print(TestResult.getIndent(indent) + "<" + name + ">" + TestResult.correctContent(value, true) + "</" + name + ">\n");
    }

    protected void ptxElementOpen(PrintStream ps, int indent, String name) {
        ps.print(TestResult.getIndent(indent) + "<" + name + ">\n");
    }

    protected void ptxElementStartOpen(PrintStream ps, int indent, String name, boolean linebreak) {
        ps.print(TestResult.getIndent(indent) + "<" + name + (linebreak ? "\n" : " "));
    }

    protected void ptxElementClose(PrintStream ps, int indent, String name) {
        ps.print(TestResult.getIndent(indent) + "</" + name + ">\n");
    }

    private String ptxArrToValue(String[] values) {
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            value.append(values[i]);
            if (i + 1 >= values.length) continue;
            value.append(" ");
        }
        return value.toString();
    }

    protected void ptxXmlHeader(PrintStream ps) {
        ps.print(XML_HEADER);
    }

    public static String getRunModeDescription(int mode) {
        return mode == 1 ? "static run" : (mode == 2 ? "timed run" : "unknown");
    }

    public static String doubleAsRes(double d) {
        return df.format(d);
    }

    public static String millisAsSec(long time) {
        return time / 1000L + "s";
    }

    protected static String getIndent(int indent) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            ret.append(" ");
        }
        return ret.toString();
    }

    public static final String correctContent(String content, boolean doApos) {
        boolean needCorrection;
        boolean bl = needCorrection = content.matches(".*(<|>|'|\"|&|)+.*") || content.indexOf("\n") > 0;
        if (!needCorrection) {
            return content;
        }
        StringBuilder result = new StringBuilder();
        char current = 'a';
        block8: for (int i = 0; i < content.length(); ++i) {
            char prev = current;
            current = content.charAt(i);
            if (prev == '\\') {
                result.append(current);
                continue;
            }
            switch (current) {
                case '\\': {
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    if (doApos) {
                        result.append("&apos;");
                        continue block8;
                    }
                    result.append(current);
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                default: {
                    result.append(current);
                }
            }
        }
        return result.toString();
    }

    static {
        df.setDecimalSeparatorAlwaysShown(true);
        df.setMinimumFractionDigits(2);
    }
}

