/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.results;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.results.BenchmarkResult;
import spec.harness.results.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteResult
extends TestResult {
    private String workloadName = "not set";
    private String kitVersion = "n/a";
    private HashMap<String, String> runInfo = new HashMap();
    private HashMap<String, String> jvmInfo = new HashMap();
    private HashMap<String, String> swInfo = new HashMap();
    private HashMap<String, String> hwInfo = new HashMap();
    List<BenchmarkResult> benchmarkResults = new LinkedList<BenchmarkResult>();
    List<String> violations = null;
    List<String> configurations = null;

    public String getWorkloadName() {
        return this.workloadName;
    }

    public void setWorkloadName(String workloadName) {
        this.workloadName = workloadName;
    }

    public String getKitVersion() {
        return this.kitVersion;
    }

    public void setKitVersion(String kitVersion) {
        this.kitVersion = kitVersion;
    }

    public void addJvmInfo(String key, Properties props, String def) {
        String value;
        String string = value = def == null ? "n/a" : def;
        if (props != null) {
            value = props.getProperty(key, value);
        }
        this.jvmInfo.put(key, value);
        if (Launch.verbose) {
            Context.getOut().println("  " + key + "=" + value);
        }
    }

    public void addJvmInfo(String key, String value) {
        this.jvmInfo.put(key, value);
        if (Launch.verbose) {
            Context.getOut().println("  " + key + "=" + value);
        }
    }

    public Map getJvmInfo() {
        return this.jvmInfo;
    }

    public void addRunInfo(String key, Properties props, String def) {
        String value;
        String string = value = def == null ? "n/a" : def;
        if (props != null) {
            value = props.getProperty(key, value);
        }
        this.runInfo.put(key, value);
        if (Launch.verbose) {
            Context.getOut().println("  " + key + "=" + value);
        }
    }

    public Map getRunInfo() {
        return this.runInfo;
    }

    public void addSwInfo(String key, Properties props, String def) {
        String value;
        String string = value = def == null ? "n/a" : def;
        if (props != null) {
            value = props.getProperty(key, value);
        }
        this.swInfo.put(key, value);
        if (Launch.verbose) {
            Context.getOut().println("  " + key + "=" + value);
        }
    }

    public Map getSwInfo() {
        return this.swInfo;
    }

    public void addHwInfo(String key, Properties props, String def) {
        String value;
        String string = value = def == null ? "n/a" : def;
        if (props != null) {
            value = props.getProperty(key, value);
        }
        this.hwInfo.put(key, value);
        if (Launch.verbose) {
            Context.getOut().println("  " + key + "=" + value);
        }
    }

    public Map getHwInfo() {
        return this.hwInfo;
    }

    public List<String> getViolations() {
        return this.violations;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public List getBenchmarkResults() {
        return this.benchmarkResults;
    }

    public void addBenchmarkResults(BenchmarkResult benchmarkResult) {
        this.benchmarkResults.add(benchmarkResult);
    }

    public void addViolation(String violation) {
        if (this.violations == null) {
            this.violations = new LinkedList<String>();
        }
        this.violations.add(violation);
    }

    public void addConfiguration(String configuration) {
        if (this.configurations == null) {
            this.configurations = new LinkedList<String>();
        }
        this.configurations.add(configuration);
    }

    public boolean isCompliant() {
        return this.violations == null;
    }

    @Override
    public boolean isValid() {
        if (this.hasErrors()) {
            return false;
        }
        for (BenchmarkResult res : this.benchmarkResults) {
            if (res.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAllErrors(String tag) {
        LinkedList<String> tmp = new LinkedList<String>();
        if (this.errors != null) {
            Iterator eit = this.errors.iterator();
            while (eit.hasNext()) {
                tmp.add(tag + " " + eit.next());
            }
        }
        for (BenchmarkResult br : this.benchmarkResults) {
            tmp.addAll(br.getAllErrors("[" + br.getLogicalName() + "]"));
        }
        return tmp;
    }

    public void headerToXml(PrintStream ps, int indent) {
        Iterator<String> iter;
        this.ptxXmlHeader(ps);
        this.ptxElementOpen(ps, 0, "specjvm-result");
        this.ptxElement(ps, 2, "workload", this.workloadName);
        this.ptxElement(ps, 2, "suite-build-version", this.kitVersion);
        this.ptxElementOpen(ps, 2, "run-info");
        for (String key : this.runInfo.keySet()) {
            this.ptxElement(ps, 4, key, this.runInfo.get(key));
        }
        this.ptxElementClose(ps, 2, "run-info");
        this.ptxElementOpen(ps, 2, "jvm-info");
        for (String key : this.jvmInfo.keySet()) {
            this.ptxElement(ps, 4, key, this.jvmInfo.get(key));
        }
        this.ptxElementClose(ps, 2, "jvm-info");
        this.ptxElementOpen(ps, 2, "sw-info");
        for (String key : this.swInfo.keySet()) {
            this.ptxElement(ps, 4, key, this.swInfo.get(key));
        }
        this.ptxElementClose(ps, 2, "sw-info");
        this.ptxElementOpen(ps, 2, "hw-info");
        for (String key : this.hwInfo.keySet()) {
            this.ptxElement(ps, 4, key, this.hwInfo.get(key));
        }
        this.ptxElementClose(ps, 2, "hw-info");
        if (!this.isCompliant()) {
            this.ptxElementOpen(ps, 2, "violations");
            iter = this.violations.iterator();
            while (iter.hasNext()) {
                this.ptxElement(ps, 4, "violation", iter.next());
            }
            this.ptxElementClose(ps, 2, "violations");
        }
        if (this.configurations != null) {
            this.ptxElementOpen(ps, 2, "configs");
            iter = this.configurations.iterator();
            while (iter.hasNext()) {
                this.ptxElement(ps, 4, "config", iter.next());
            }
            this.ptxElementClose(ps, 2, "configs");
        }
        this.ptxElementOpen(ps, 2, "benchmark-results");
    }

    @Override
    public void toXml(PrintStream ps, int indent) {
        Iterator<BenchmarkResult> iter = this.benchmarkResults.iterator();
        while (iter.hasNext()) {
            iter.next().toXml(ps, 4);
        }
    }

    public void footerToXml(PrintStream ps, int indent) {
        this.ptxElementClose(ps, 2, "benchmark-results");
        this.printErrorsToXml(ps, 2);
        this.ptxElementClose(ps, 0, "specjvm-result");
    }

    public String getCommandLineOptions() {
        return this.jvmInfo.get("spec.jvm2008.report.jvm.command.line");
    }
}

