/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.results;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.TYInfo;
import spec.harness.results.BenchmarkResult;
import spec.harness.results.LoopResult;
import spec.harness.results.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationResult
extends TestResult {
    private int iteration = -1;
    private long expectedLoops = -1L;
    private long expectedDuration = -1L;
    private long startTime = -1L;
    private long stopTime = -1L;
    private long endTime = -1L;
    private double operations = 0.0;
    private boolean isStartup = false;
    private boolean cont = true;
    private int numberBmThreadsDone = 0;
    private BenchmarkResult bmResult = null;
    private List<LoopResult> loopResults = new LinkedList<LoopResult>();
    private List<TYInfo> analyzers = new LinkedList<TYInfo>();
    private List<AnalyzerResult> analyzerSummaries = new LinkedList<AnalyzerResult>();

    public void setBenchmarkResult(BenchmarkResult bmResult) {
        this.bmResult = bmResult;
    }

    public BenchmarkResult getBenchmarkResult() {
        return this.bmResult;
    }

    public synchronized long getExpectedDuration() {
        return this.expectedDuration;
    }

    public synchronized void setExpectedDuration(long expectedDuration) {
        this.expectedDuration = expectedDuration;
    }

    public synchronized void abortRun() {
        this.cont = false;
    }

    public synchronized boolean continueToRun() {
        return this.cont;
    }

    public synchronized long getExpectedLoops() {
        return this.expectedLoops;
    }

    public synchronized void setExpectedLoops(long expectedLoops) {
        this.expectedLoops = expectedLoops;
    }

    public synchronized long getEndTime() {
        return this.endTime;
    }

    public synchronized void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized long getStopTime() {
        return this.stopTime;
    }

    public synchronized void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public synchronized void setStartupTest(boolean isStartup) {
        this.isStartup = isStartup;
    }

    public synchronized boolean getStartupTest() {
        return this.isStartup;
    }

    public synchronized double getOperations() {
        return this.operations;
    }

    public synchronized void incOperations(double operations) {
        this.operations += operations;
    }

    public synchronized int getIteration() {
        return this.iteration;
    }

    public synchronized void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public synchronized List getLoopResults() {
        return this.loopResults;
    }

    public synchronized void addLoopResults(LoopResult loopResults) {
        this.loopResults.add(loopResults);
    }

    public synchronized int getNumberBmThreadsDone() {
        return this.numberBmThreadsDone;
    }

    public synchronized boolean incNumberBmThreadsDone() {
        ++this.numberBmThreadsDone;
        return this.numberBmThreadsDone == this.bmResult.getNumberBmThreads();
    }

    public synchronized long getDuration() {
        return this.endTime - this.startTime;
    }

    public synchronized List getAnalyzers() {
        return this.analyzers;
    }

    public synchronized void addAnalyzer(TYInfo tyi) {
        this.analyzers.add(tyi);
    }

    public synchronized void addAnalyzerSummary(AnalyzerResult aResult) {
        this.analyzerSummaries.add(aResult);
    }

    public synchronized Iterator<AnalyzerResult> getAnalyzerSummaries() {
        return this.analyzerSummaries.iterator();
    }

    public synchronized String durDesc() {
        if (this.getExpectedLoops() <= 0L) {
            return TestResult.millisAsSec(this.getExpectedDuration());
        }
        if (this.getExpectedLoops() <= 1L) {
            return this.getExpectedLoops() + " operation";
        }
        return this.getExpectedLoops() + " operations";
    }

    public synchronized String resultString(String testType) {
        if (testType.equals("functional")) {
            return this.isValid() ? "PASSED" : "FAILED";
        }
        if (this.isValid()) {
            return IterationResult.doubleAsRes(this.getScore()) + " " + "ops/m";
        }
        return " **NOT VALID**";
    }

    public synchronized double getScore() {
        if (this.isValid()) {
            return this.getOperations() * 60.0 * 1000.0 / (double)this.getDuration();
        }
        return 0.0;
    }

    @Override
    public synchronized boolean isValid() {
        if (this.hasErrors()) {
            return false;
        }
        for (LoopResult lr : this.loopResults) {
            if (lr.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAllErrors(String tag) {
        LinkedList<String> tmp = new LinkedList<String>();
        if (this.errors != null) {
            Iterator eit = this.errors.iterator();
            while (eit.hasNext()) {
                tmp.add(tag + " " + eit.next());
            }
        }
        for (LoopResult lr : this.loopResults) {
            tmp.addAll(lr.getAllErrors(tag + "[bt:" + lr.getBmThreadId() + "|op:" + lr.getLoopCnt() + "]"));
        }
        return tmp;
    }

    @Override
    public synchronized void toXml(PrintStream ps, int indent) {
        this.ptxElementStartOpen(ps, indent, "iteration-result", true);
        this.ptxAttrib(ps, indent += 2, "iteration", this.iteration, true, "\n");
        this.ptxAttrib(ps, indent, "expectedLoops", this.expectedLoops, this.expectedLoops > 0L, "\n");
        this.ptxAttrib(ps, indent, "expectedDuration", this.expectedDuration, this.expectedLoops <= 0L, "\n");
        this.ptxAttrib(ps, indent, "startTime", this.startTime, true, "\n");
        this.ptxAttrib(ps, indent, "endTime", this.endTime, true, "\n");
        this.ptxAttrib(ps, indent, "operations", this.operations, true, ">\n");
        this.printErrorsToXml(ps, indent);
        this.ptxElementOpen(ps, indent, "loops");
        Iterator<Object> iter = this.loopResults.iterator();
        while (iter.hasNext()) {
            iter.next().toXml(ps, indent + 2);
        }
        this.ptxElementClose(ps, indent, "loops");
        this.ptxElementOpen(ps, indent, "analyzers");
        for (TYInfo tyi : this.analyzers) {
            this.ptxElementStartOpen(ps, indent + 2, "tyinfo", false);
            this.ptxAttrib(ps, 0, "name", tyi.getName(), true, " ");
            this.ptxAttrib(ps, 0, "unit", tyi.getUnit(), true, " ");
            this.ptxAttrib(ps, 0, "time", tyi.getTime(), true, " ");
            this.ptxAttrib(ps, 0, "value", tyi.getValue(), true, "/>\n");
        }
        this.ptxElementClose(ps, indent, "analyzers");
        this.ptxElementOpen(ps, indent, "analyzer-results");
        for (AnalyzerResult ar : this.analyzerSummaries) {
            this.ptxElementStartOpen(ps, indent + 2, "result", false);
            this.ptxAttrib(ps, 0, "name", ar.getName(), true, " ");
            this.ptxAttrib(ps, 0, "unit", ar.getUnit(), true, " ");
            this.ptxAttrib(ps, 0, "value", ar.getResult(), true, "/>\n");
        }
        this.ptxElementClose(ps, indent, "analyzer-results");
        this.ptxElementClose(ps, indent -= 2, "iteration-result");
    }
}

