/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.results;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import spec.harness.StopBenchmarkException;
import spec.harness.results.IterationResult;
import spec.harness.results.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkResult
extends TestResult {
    private String name;
    private String runName;
    private String category;
    private String[] args;
    private int minIter = 1;
    private int maxIter = 1;
    private int numberBmThreads = 1;
    private long warmupTime = -1L;
    private long iterationTime = -1L;
    private boolean forcedIterationTime = false;
    private int numberOfLoops = -1;
    private long benchmarkDelay = -1L;
    private boolean benchmarkForcegc = false;
    private long iterationDelay = -1L;
    private boolean iterationForcegc = false;
    private boolean checksum = false;
    private int runMode = -1;
    private String bmType = null;
    private String analyzers;
    private long analyzerFreq;
    private IterationResult warmupResult = null;
    private List<IterationResult> iterationResults = new LinkedList<IterationResult>();

    public String getLogicalName() {
        return this.name;
    }

    public String getRunName() {
        return this.runName;
    }

    public void setNames(String name) {
        this.name = name;
        this.runName = name;
    }

    public void setRunName(String name) {
        this.runName = name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public boolean doChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public long getIterationDelay() {
        return this.iterationDelay;
    }

    public void setIterationDelay(long iterationDelay) {
        this.iterationDelay = iterationDelay;
    }

    public boolean getIterationForcegc() {
        return this.iterationForcegc;
    }

    public void setIterationForcegc(boolean iterationForcegc) {
        this.iterationForcegc = iterationForcegc;
    }

    public long getIterationTime() {
        return this.iterationTime;
    }

    public void setIterationTime(long iterationTime) {
        this.setIterationTime(iterationTime, false);
    }

    public void setIterationTime(long iterationTime, boolean forced) {
        this.iterationTime = iterationTime;
        this.forcedIterationTime = forced;
    }

    public boolean getForcedIterationTime() {
        return this.forcedIterationTime;
    }

    public long getWarmupTime() {
        return this.warmupTime;
    }

    public void setWarmupTime(long warmupTime) {
        this.warmupTime = warmupTime;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public int getMinIter() {
        return this.minIter;
    }

    public void setMinIter(int minIter) {
        this.minIter = minIter;
    }

    public int getNumberOfLoops() {
        return this.numberOfLoops;
    }

    public int getNumberBmThreads() {
        return this.numberBmThreads;
    }

    public void setNumberBmThreads(int numberBmThreads) {
        this.numberBmThreads = numberBmThreads;
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int runMode) {
        this.runMode = runMode;
    }

    public String getBmType() {
        return this.bmType;
    }

    public void setBmType(String bmType) {
        this.bmType = bmType;
    }

    public IterationResult getWarmupResult() {
        return this.warmupResult;
    }

    public void setWarmupResult(IterationResult warmupResult) {
        this.warmupResult = warmupResult;
    }

    public void setNumberOfLoops(int numberOfLoops) {
        this.numberOfLoops = numberOfLoops;
    }

    public long getBenchmarkDelay() {
        return this.benchmarkDelay;
    }

    public void setBenchmarkDelay(long benchmarkDelay) {
        this.benchmarkDelay = benchmarkDelay;
    }

    public boolean getBenchmarkForcegc() {
        return this.benchmarkForcegc;
    }

    public void setBenchmarkForcegc(boolean benchmarkForcegc) {
        this.benchmarkForcegc = benchmarkForcegc;
    }

    public List getIterationResults() {
        return this.iterationResults;
    }

    public void addIterationResult(IterationResult iterationResult) {
        this.iterationResults.add(iterationResult);
    }

    public String getAnalyzers() {
        return this.analyzers != null ? this.analyzers : "";
    }

    public void setAnalyzers(String analyzers) {
        this.analyzers = analyzers;
    }

    public long getAnalyzerFreq() {
        return this.analyzerFreq;
    }

    public void setAnalyzerFreq(long analyzerFreq) {
        this.analyzerFreq = analyzerFreq;
    }

    public String durDesc() {
        if (this.runMode == 2) {
            return TestResult.millisAsSec(this.getIterationTime());
        }
        if (this.runMode == 1) {
            if (this.getNumberOfLoops() <= 1) {
                return this.getNumberOfLoops() + " operation";
            }
            return this.getNumberOfLoops() + " operations";
        }
        throw new StopBenchmarkException("Unknown run mode " + this.runMode);
    }

    public double getScore() {
        double bScore = 0.0;
        for (IterationResult res : this.iterationResults) {
            if (!res.isValid() || !(res.getScore() > bScore)) continue;
            bScore = res.getScore();
        }
        return bScore;
    }

    public String resultString() {
        if (this.isValid()) {
            return BenchmarkResult.doubleAsRes(this.getScore()) + " " + "ops/m";
        }
        return " **NOT VALID**";
    }

    @Override
    public boolean isValid() {
        if (this.hasErrors()) {
            return false;
        }
        if (this.warmupResult != null && !this.warmupResult.isValid()) {
            return false;
        }
        for (IterationResult res : this.iterationResults) {
            if (res.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAllErrors(String tag) {
        LinkedList<String> tmp = new LinkedList<String>();
        if (this.errors != null) {
            Iterator eit = this.errors.iterator();
            while (eit.hasNext()) {
                tmp.add(tag + " " + eit.next());
            }
        }
        if (this.warmupResult != null) {
            tmp.addAll(this.warmupResult.getAllErrors(tag + "[warmup]"));
        }
        for (IterationResult ir : this.iterationResults) {
            tmp.addAll(ir.getAllErrors(tag + "[iter=" + ir.getIteration() + "]"));
        }
        return tmp;
    }

    public void headerToXml(PrintStream ps, int indent) {
        this.ptxElementStartOpen(ps, indent, "benchmark-result", true);
        this.ptxAttrib(ps, indent += 2, "name", this.name, true, "\n");
        this.ptxAttrib(ps, indent, "category", this.category, true, "\n");
        this.ptxAttrib(ps, indent, "args", this.args, true, "\n");
        this.ptxAttrib(ps, indent, "minIter", this.minIter, true, "\n");
        this.ptxAttrib(ps, indent, "maxIter", this.maxIter, true, "\n");
        this.ptxAttrib(ps, indent, "numberBmThreads", this.numberBmThreads, true, "\n");
        this.ptxAttrib(ps, indent, "warmupTime", this.warmupTime, this.warmupTime > 0L, "\n");
        this.ptxAttrib(ps, indent, "iterationTime", BenchmarkResult.millisAsSec(this.iterationTime), this.runMode == 2, "\n");
        this.ptxAttrib(ps, indent, "forcedIterationTime", this.forcedIterationTime, this.runMode == 2 && this.forcedIterationTime, "\n");
        this.ptxAttrib(ps, indent, "numberOfLoops", this.numberOfLoops, this.runMode == 1, "\n");
        this.ptxAttrib(ps, indent, "benchmarkDelay", BenchmarkResult.millisAsSec(this.benchmarkDelay), this.benchmarkDelay > 0L, "\n");
        this.ptxAttrib(ps, indent, "benchmarkForcegc", this.benchmarkForcegc, this.benchmarkForcegc, "\n");
        this.ptxAttrib(ps, indent, "iterationDelay", BenchmarkResult.millisAsSec(this.iterationDelay), this.iterationDelay > 0L, "\n");
        this.ptxAttrib(ps, indent, "iterationForcegc", this.iterationForcegc, this.iterationForcegc, "\n");
        this.ptxAttrib(ps, indent, "analyzers", this.analyzers, this.analyzers != null && this.analyzers.length() > 0, "\n");
        this.ptxAttrib(ps, indent, "analyzerFreq", BenchmarkResult.millisAsSec(this.analyzerFreq), this.analyzers != null && this.analyzers.length() > 0, "\n");
        this.ptxAttrib(ps, indent, "bmType", this.bmType, true, "\n");
        this.ptxAttrib(ps, indent, "runMode", this.runMode, true, ">\n");
        this.ptxElementOpen(ps, indent, "warmup-result");
    }

    @Override
    public void toXml(PrintStream ps, int indent) {
        this.headerToXml(ps, indent);
        if (this.warmupResult != null) {
            this.warmupResult.toXml(ps, indent + 2);
        }
        this.middleToXml(ps, indent);
        Iterator<IterationResult> iter = this.iterationResults.iterator();
        while (iter.hasNext()) {
            iter.next().toXml(ps, indent + 2);
        }
        this.footerToXml(ps, indent);
    }

    public void middleToXml(PrintStream ps, int indent) {
        this.ptxElementClose(ps, indent, "warmup-result");
        this.ptxElementOpen(ps, indent, "iterations");
    }

    public void footerToXml(PrintStream ps, int indent) {
        this.ptxElementClose(ps, indent, "iterations");
        this.printErrorsToXml(ps, indent + 2);
        this.ptxElementClose(ps, indent, "benchmark-result");
    }
}

