/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.analyzer;

import java.util.HashMap;
import spec.harness.Context;
import spec.harness.Util;
import spec.harness.analyzer.AnalyzerBase;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.TempSensor;

public class TempAnalyzer
extends AnalyzerBase {
    private HashMap<String, String> tempResults = null;
    private static String baseName = "Temperature";
    private static TempSensor tempSensor = null;
    private static boolean verbose = false;
    private static boolean dummy = false;
    private static String tempSensorHost;
    private static int tempSensorPort;
    private boolean doMeasure = false;

    public static void setupAnalyzerClass() {
        tempSensorHost = Util.getProperty("spec.harness.analyzer.TempAnalyzer.host", null);
        tempSensorPort = Util.getIntProperty("spec.harness.analyzer.TempAnalyzer.port", null);
        verbose = Util.getBoolProperty("spec.harness.analyzer.TempAnalyzer.verbose", null);
        dummy = Util.getBoolProperty("spec.harness.analyzer.TempAnalyzer.useDummy", null);
        if (tempSensorHost == null) {
            tempSensorHost = "127.0.0.1";
        }
        if (tempSensorPort == -1) {
            tempSensorPort = 8889;
        }
        if (verbose) {
            Context.getOut().println("Connecting to temp sensor " + tempSensorHost + ":" + tempSensorPort);
        }
        if (!dummy) {
            tempSensor = new TempSensor(tempSensorHost, tempSensorPort);
            if (verbose) {
                Context.getOut().println("Temperature sensor type is " + tempSensor.sensorType());
                Context.getOut().println("Temperature sensor ptd version is " + tempSensor.sensorPtdVersion());
                Context.getOut().println("Temperature sensor ptd host OS is " + tempSensor.sensorPtdHostOs());
            }
            if (!tempSensor.sensorCompliant().booleanValue()) {
                AnalyzerBase.addViolationToSuiteResult("Warning: temperature sensor not SPEC compliant!");
            }
            if (!tempSensor.sensorPtdMode().equals("temperature")) {
                AnalyzerBase.addViolationToSuiteResult("Error: temp sensor ptd not in temperature mode, data will be invalid!");
            }
            tempSensor.go();
        } else {
            AnalyzerBase.addViolationToSuiteResult("Dummy temp sensor used. Data will be invalid!");
        }
    }

    public static void tearDownAnalyzerClass() {
        if (verbose) {
            Context.getOut().println("Tearing down temperature sensor class.");
        }
        if (dummy) {
            return;
        }
        tempSensor.stop();
        tempSensor.endSocConnection();
    }

    public void setup() {
        this.doMeasure = this.isTimedRun();
    }

    public void startMeasurementInterval() {
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Starting temp measurement interval.");
        }
        if (dummy) {
            return;
        }
    }

    public void endMeasurementInterval() {
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Ending temperature measurement interval.");
        }
        if (dummy) {
            return;
        }
        this.tempResults = tempSensor.reportRun("test");
    }

    public void tearDown() {
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Tearing down TempAnalyzer.");
        }
        if (dummy) {
            this.report(new TemperatureResult(3.1415, baseName + " Avg temp", "C"));
            return;
        }
        this.report(new TemperatureResult(Double.parseDouble(this.tempResults.get("Avg Temp")), baseName + " Avg temp", "C"));
        this.report(new TemperatureResult(Double.parseDouble(this.tempResults.get("Min Temp")), baseName + " Min temp", "C"));
        this.report(new TemperatureResult(Double.parseDouble(this.tempResults.get("Max Temp")), baseName + " Max temp", "C"));
        this.report(new TemperatureResult(Double.parseDouble(this.tempResults.get("Temp Samples")), baseName + " temp samples", ""));
        this.report(new TemperatureResult(Double.parseDouble(this.tempResults.get("Temp Errors")), baseName + " temp errors", ""));
        Double tempErrorPercent = 100.0 * Double.parseDouble(this.tempResults.get("Temp Errors")) / Double.parseDouble(this.tempResults.get("Temp Samples"));
        if (tempErrorPercent >= 2.0) {
            this.addError("Warning: Temperature error rate = " + tempErrorPercent + "% >= 2%; temperature measurement not valid.");
        }
        if (Double.parseDouble(this.tempResults.get("Min Temp")) < 20.0) {
            this.addError("Warning: Minimum temperature less than 20 C; run will not be SPEC compliant!");
        }
    }

    public void execute(long time) {
    }

    public static class TemperatureResult
    extends AnalyzerResult {
        String resName;
        String resUnit;

        public TemperatureResult(double result, String name, String unit) {
            super(result);
            this.resName = name;
            this.resUnit = unit;
        }

        public String getName() {
            return this.resName;
        }

        public String getUnit() {
            return this.resUnit;
        }
    }
}

