/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.analyzer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import spec.harness.Context;
import spec.harness.StopBenchmarkException;
import spec.harness.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMeter {
    private static final boolean verbose = Util.getBoolProperty("spec.harness.analyzer.PowerMeter.verbose", null);
    static String[] AnalyzerCommands = new String[]{"Watts", "Volts", "Amps", "PF"};
    static String[] identifyParts = new String[]{"Error", "0", "0", "0", "0", "0", "0", "0", "0", "Error", "Error", "Error"};
    private Socket meterSocket;
    private PrintWriter outputToMeter;
    private BufferedReader inputFromMeter;

    public PowerMeter(String host, int port) {
        if (verbose) {
            Context.getOut().println("\nChecking for ptd power connection...\n");
        }
        try {
            this.meterSocket = new Socket(host, port);
        }
        catch (UnknownHostException unknown) {
            throw new StopBenchmarkException("Could not connect to power ptd.", unknown);
        }
        catch (IOException er) {
            throw new StopBenchmarkException("Error connecting to power ptd.", er);
        }
        if (verbose) {
            Context.getOut().println("Connection established...");
        }
        try {
            this.outputToMeter = new PrintWriter(this.meterSocket.getOutputStream(), true);
            this.inputFromMeter = new BufferedReader(new InputStreamReader(this.meterSocket.getInputStream()));
        }
        catch (IOException er) {
            throw new StopBenchmarkException("Error connection to meter server.", er);
        }
        if (verbose) {
            Context.getOut().println("Reader/writer set up\n");
        }
        this.outputToMeter.println("Identify");
        try {
            String[] meterResponseParts;
            String meterResponse = this.inputFromMeter.readLine();
            if (verbose) {
                Context.getOut().println("Meter response: " + meterResponse);
            }
            if ((meterResponseParts = meterResponse.split(",")).length == 12) {
                identifyParts = meterResponseParts;
                if (verbose) {
                    Context.getOut().println("Power analyzer type: " + meterResponseParts[0]);
                    Context.getOut().println("Power analyzer SPEC compliant: " + meterResponseParts[8]);
                    Context.getOut().println("PTD version: " + meterResponseParts[9]);
                    Context.getOut().println("PTD host OS: " + meterResponseParts[10]);
                    Context.getOut().println("PTD mode: " + meterResponseParts[11]);
                }
            } else {
                Context.getOut().println("Warning! Unexpected input from power meter: " + meterResponse);
                Context.getOut().println("Expected 12 tokens, separated with ','.");
            }
        }
        catch (IOException er) {
            throw new StopBenchmarkException(er.getMessage(), er);
        }
        if (verbose) {
            Context.getOut().println("Meter connection successful!\n");
        }
    }

    private int writeMeter(String mString) {
        this.outputToMeter.println(mString);
        return 1;
    }

    private String readMeter() {
        String meterResponse = null;
        try {
            meterResponse = this.inputFromMeter.readLine();
        }
        catch (IOException er) {
            throw new StopBenchmarkException(er.getMessage(), er);
        }
        if (verbose) {
            Context.getOut().println("Meter response: " + meterResponse);
        }
        return meterResponse;
    }

    public void endSocConnection() {
        try {
            this.outputToMeter.close();
            this.meterSocket.close();
        }
        catch (IOException e) {
            throw new StopBenchmarkException("Error closing the power analyzer connection", e);
        }
    }

    public void startRun(int samples, int rate_ms, int rampup_ms) {
        String msg = String.format("Timed,%d,%d,%d", samples, rate_ms, rampup_ms);
        this.writeMeter(msg);
        if (verbose) {
            Context.getOut().println("Meter responds:" + this.readMeter());
        }
    }

    public void go() {
        this.writeMeter("Go,0,0");
        this.readMeter();
    }

    public void stop() {
        this.writeMeter("Stop");
        this.readMeter();
    }

    public HashMap<String, String> reportRun(String propPrefix) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (int i = 0; i < 4; ++i) {
            String[] msg_parts;
            this.writeMeter(AnalyzerCommands[i]);
            String msg = this.readMeter();
            if (verbose) {
                Context.getOut().println(msg);
            }
            if ((msg_parts = msg.split(",")).length == 7) {
                results.put("Avg " + AnalyzerCommands[i], msg_parts[1]);
                results.put("Min " + AnalyzerCommands[i], msg_parts[2]);
                results.put("Max " + AnalyzerCommands[i], msg_parts[3]);
                results.put(AnalyzerCommands[i] + " Samples", msg_parts[4]);
                results.put(AnalyzerCommands[i] + " Errors", msg_parts[5]);
                continue;
            }
            Context.getOut().println("Warning! Unexpected input from power meter: " + msg);
            Context.getOut().println("Expected 7 tokens, separated with ','.");
            results.put("Avg " + AnalyzerCommands[i], "-1.0");
            results.put("Min " + AnalyzerCommands[i], "-1.0");
            results.put("Max " + AnalyzerCommands[i], "-1.0");
            results.put(AnalyzerCommands[i] + " Samples", "1");
            results.put(AnalyzerCommands[i] + " Errors", "1");
        }
        return results;
    }

    public String meterType() {
        return identifyParts[0];
    }

    public Boolean meterCompliant() {
        return identifyParts[8].equals("1");
    }

    public String meterPtdVersion() {
        if (identifyParts[9].substring(0, 8).equals("version=")) {
            return identifyParts[9].substring(8);
        }
        return "Error";
    }

    public String meterPtdHostOs() {
        if (identifyParts[10].substring(0, 3).equals("OS=")) {
            return identifyParts[10].substring(3);
        }
        return "Error";
    }

    public String meterPtdMode() {
        if (identifyParts[11].substring(0, 5).equals("mode=")) {
            return identifyParts[11].substring(5);
        }
        return "Error";
    }
}

