/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.analyzer;

import java.util.HashMap;
import spec.harness.Context;
import spec.harness.Util;
import spec.harness.analyzer.AnalyzerBase;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.PowerMeter;

public class PowerAnalyzer
extends AnalyzerBase {
    private HashMap<String, String> powerResults = null;
    private static String baseName = "Power Consumption";
    private static PowerMeter powerMeter = null;
    private static boolean verbose = false;
    private static boolean dummy = false;
    private static String powerMeterHost;
    private static int powerMeterPort;
    private boolean doMeasure = false;

    public static void setupAnalyzerClass() {
        powerMeterHost = Util.getProperty("spec.harness.analyzer.PowerAnalyzer.host", null);
        powerMeterPort = Util.getIntProperty("spec.harness.analyzer.PowerAnalyzer.port", null);
        verbose = Util.getBoolProperty("spec.harness.analyzer.PowerAnalyzer.verbose", null);
        dummy = Util.getBoolProperty("spec.harness.analyzer.PowerAnalyzer.useDummy", null);
        if (powerMeterHost == null) {
            powerMeterHost = "127.0.0.1";
        }
        if (powerMeterPort == -1) {
            powerMeterPort = 8888;
        }
        if (verbose) {
            Context.getOut().println("Connecting to power analyzer " + powerMeterHost + ":" + powerMeterPort);
        }
        if (dummy) {
            AnalyzerBase.addViolationToSuiteResult("Dummy power analyzer used. Data will be invalid!");
            return;
        }
        powerMeter = new PowerMeter(powerMeterHost, powerMeterPort);
        if (verbose) {
            Context.getOut().println("Power analyzer type is " + powerMeter.meterType());
            Context.getOut().println("Power analyzer ptd version is " + powerMeter.meterPtdVersion());
            Context.getOut().println("Power analyzer ptd host OS is " + powerMeter.meterPtdHostOs());
        }
        if (!powerMeter.meterCompliant().booleanValue()) {
            AnalyzerBase.addViolationToSuiteResult("Warning: power analyzer not SPEC compliant!");
        }
        if (!powerMeter.meterPtdMode().equals("power")) {
            AnalyzerBase.addViolationToSuiteResult("Error: power analyzer ptd not in power mode, data will be invalid!");
        }
    }

    public static void tearDownAnalyzerClass() {
        if (verbose) {
            Context.getOut().println("Tearing down power analyzer class.");
        }
        if (dummy) {
            return;
        }
        powerMeter.endSocConnection();
    }

    public void setup() {
        this.doMeasure = this.isTimedRun();
    }

    public void startMeasurementInterval() {
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Starting power measurement interval.");
        }
        if (dummy) {
            return;
        }
        powerMeter.go();
    }

    public void endMeasurementInterval() {
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Ending power measurement interval.");
        }
        if (dummy) {
            return;
        }
        powerMeter.stop();
        this.powerResults = powerMeter.reportRun("test");
    }

    public void tearDown() {
        Double pfErrorPercent;
        Double ampErrorPercent;
        Double voltErrorPercent;
        if (!this.doMeasure) {
            return;
        }
        if (verbose) {
            Context.getOut().println("Tearing down PowerAnalyzer.");
        }
        if (dummy) {
            this.report(new PowerConsumtionResult(3.14, baseName + " Avg watts", "W"));
            this.report(new PowerConsumtionResult(1.21, baseName + " Min watts", "W"));
            return;
        }
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Avg Watts")), baseName + " Avg watts", "W"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Min Watts")), baseName + " Min watts", "W"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Max Watts")), baseName + " Max watts", "W"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Watts Samples")), baseName + " watts samples", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Watts Errors")), baseName + " watts errors", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Avg Volts")), baseName + " Avg volts", "V"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Min Volts")), baseName + " Min volts", "V"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Max Volts")), baseName + " Max volts", "V"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Volts Samples")), baseName + " volts samples", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Volts Errors")), baseName + " volts errors", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Avg Amps")), baseName + " Avg amps", "A"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Min Amps")), baseName + " Min amps", "A"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Max Amps")), baseName + " Max amps", "A"));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Amps Samples")), baseName + " amps samples", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Amps Errors")), baseName + " amps errors", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Avg PF")), baseName + " Avg PF", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Min PF")), baseName + " Min PF", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("Max PF")), baseName + " Max PF", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("PF Samples")), baseName + " PF samples", ""));
        this.report(new PowerConsumtionResult(Double.parseDouble(this.powerResults.get("PF Errors")), baseName + " PF errors", ""));
        Double wattErrorPercent = 100.0 * Double.parseDouble(this.powerResults.get("Watts Errors")) / Double.parseDouble(this.powerResults.get("Watts Samples"));
        if (wattErrorPercent >= 1.0) {
            this.addError("Warning: Power Analyzer Watt error rate = " + wattErrorPercent + "% >= 1%; power measurement not valid.");
        }
        if ((voltErrorPercent = Double.valueOf(100.0 * Double.parseDouble(this.powerResults.get("Volts Errors")) / Double.parseDouble(this.powerResults.get("Volts Samples")))) >= 2.0) {
            this.addError("Warning: Power Analyzer Volt error rate = " + voltErrorPercent + "% >= 2%; power measurement not valid.");
        }
        if ((ampErrorPercent = Double.valueOf(100.0 * Double.parseDouble(this.powerResults.get("Amps Errors")) / Double.parseDouble(this.powerResults.get("Amps Samples")))) >= 2.0) {
            this.addError("Warning: Power Analyzer Amp error rate = " + ampErrorPercent + "% >= 2%; power measurement not valid.");
        }
        if ((pfErrorPercent = Double.valueOf(100.0 * Double.parseDouble(this.powerResults.get("PF Errors")) / Double.parseDouble(this.powerResults.get("PF Samples")))) >= 2.0) {
            this.addError("Warning: Power Analyzer PF error rate = " + pfErrorPercent + "% >= 2%; power measurement not valid.");
        }
    }

    public void execute(long time) {
    }

    public static class PowerConsumtionResult
    extends AnalyzerResult {
        String resName;
        String resUnit;

        public PowerConsumtionResult(double result, String name, String unit) {
            super(result);
            this.resName = name;
            this.resUnit = unit;
        }

        public String getName() {
            return this.resName;
        }

        public String getUnit() {
            return this.resUnit;
        }
    }
}

