/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.analyzer;

import java.util.Random;
import spec.harness.analyzer.AnalyzerBase;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.TYInfo;

public class CallbackAnalyzerExample
extends AnalyzerBase {
    private static String name = "A random number";
    private static String unit = "number";
    private TheNumberGenerator externalInputSimulator = null;
    private int sum = 0;
    private int max = 0;

    public void execute(long time) {
    }

    public void setup() {
        TheNumberGenerator.register(this);
    }

    public void startMeasurementInterval() {
    }

    public void endMeasurementInterval() {
    }

    public void tearDown() {
        TheNumberGenerator.deregister(this);
        this.report(new NumberResult(this.max, "Max value", "number"));
        this.report(new NumberResult(this.sum, "Sum value", "number"));
    }

    public void callbackMethod(int value) {
        long time = System.currentTimeMillis();
        this.sum += value;
        this.max = value > this.max ? value : this.max;
        this.report(new NumberInfo(time, value));
    }

    public static class TheNumberGenerator
    extends Thread {
        private static TheNumberGenerator theOne = new TheNumberGenerator();
        private Random random = new Random();
        private CallbackAnalyzerExample listener = null;

        private TheNumberGenerator() {
        }

        private synchronized void setListener(CallbackAnalyzerExample cae) {
            this.listener = cae;
        }

        public static void register(CallbackAnalyzerExample cae) {
            theOne.setListener(cae);
        }

        public static void deregister(CallbackAnalyzerExample cae) {
            theOne.setListener(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                System.out.println("TheNumberGenerator starting.");
                int r1 = this.random.nextInt(50);
                boolean up = true;
                while (true) {
                    int r2;
                    if ((r2 = this.random.nextInt(50)) > 45) {
                        boolean bl = up = !up;
                    }
                    r1 = up ? (r1 += 2) : (r1 -= 2);
                    TheNumberGenerator theNumberGenerator = this;
                    synchronized (theNumberGenerator) {
                        if (this.listener != null) {
                            this.listener.callbackMethod(r1);
                        }
                    }
                    TheNumberGenerator.sleep(40 * r2 + 1);
                }
            }
            catch (InterruptedException ie) {
                System.out.println("TheNumberGenerator shutting down.");
                return;
            }
        }

        static {
            theOne.setDaemon(true);
            theOne.start();
        }
    }

    public static class NumberResult
    extends AnalyzerResult {
        String resName;
        String resUnit;

        public NumberResult(double result, String name, String unit) {
            super(result);
            this.resName = name;
            this.resUnit = unit;
        }

        public String getName() {
            return this.resName;
        }

        public String getUnit() {
            return this.resUnit;
        }
    }

    public static class NumberInfo
    extends TYInfo {
        public NumberInfo(long time, long value) {
            super(time, value);
        }

        public String getName() {
            return name;
        }

        public String getUnit() {
            return unit;
        }
    }
}

