/*
 * Decompiled with CFR 0.152.
 */
package spec.harness.analyzer;

import spec.harness.Context;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.TYInfo;
import spec.harness.results.IterationResult;

public abstract class AnalyzerBase {
    private IterationResult ir = null;

    public abstract void execute(long var1);

    public final void setIterationResult(IterationResult iterationResult) {
        this.ir = iterationResult;
    }

    public static void setupAnalyzerClass() {
    }

    public void setup() {
    }

    public void startMeasurementInterval() {
    }

    public void endMeasurementInterval() {
    }

    public void tearDown() {
    }

    public static void tearDownAnalyzerClass() {
    }

    public final void report(TYInfo tyi) {
        this.ir.addAnalyzer(tyi);
    }

    public final void report(AnalyzerResult aResult) {
        this.ir.addAnalyzerSummary(aResult);
    }

    protected boolean isTimedRun() {
        return this.ir.getBenchmarkResult().getRunMode() == 2;
    }

    protected long getBenchmarkDuration() {
        return this.ir.getDuration();
    }

    protected String getBenchmarkName() {
        return this.ir.getBenchmarkResult().getLogicalName();
    }

    protected long getNoOps() {
        return this.ir.getLoopResults().size();
    }

    protected void addError(String msg) {
        this.ir.addError(msg);
    }

    protected static void addErrorToSuiteResult(String msg) {
        Context.getSuiteResult().addError(msg);
    }

    protected static void addViolationToSuiteResult(String msg) {
        Context.getSuiteResult().addViolation(msg);
    }
}

