/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import spec.harness.Configuration;
import spec.harness.Context;
import spec.harness.Launch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static long getTimeProperty(String propname, String bmName) throws NumberFormatException {
        String value = Util.getProperty(propname, bmName);
        return Util.getTimeAsMillis(value);
    }

    public static long getTimeAsMillis(String value) throws NumberFormatException {
        if (value.indexOf("ms") != -1) {
            return Long.parseLong(value.substring(0, value.indexOf("ms")));
        }
        if (value.indexOf("s") != -1) {
            return 1000L * Long.parseLong(value.substring(0, value.indexOf("s")));
        }
        if (value.indexOf("m") != -1) {
            return 60000L * Long.parseLong(value.substring(0, value.indexOf("m")));
        }
        if (value.indexOf("h") != -1) {
            return 3600000L * Long.parseLong(value.substring(0, value.indexOf("h")));
        }
        return 1000L * Long.parseLong(value);
    }

    public static long getTimeAsSeconds(String value) {
        return Util.getTimeAsMillis(value) / 1000L;
    }

    public static int getHwtCalcProperty(String propname, String bmName) throws NumberFormatException {
        String value = Util.getProperty(propname, bmName);
        int hwtFactor = 1;
        double ret = 1.0;
        if (value.indexOf("x") != -1) {
            ret = Double.parseDouble(value.substring(0, value.indexOf("x")));
            value = value.substring(1 + value.indexOf("x"), value.length());
        }
        if (value.indexOf("#hwt") != -1) {
            int tmp = Util.getIntProperty("specjvm.hardware.threads.override", bmName);
            hwtFactor = tmp == -1 ? Runtime.getRuntime().availableProcessors() : tmp;
            value = value.substring(0, value.indexOf("#hwt"));
        }
        if (value.length() > 0) {
            ret = Integer.parseInt(value);
        }
        return (int)Math.round(ret * (double)hwtFactor);
    }

    public static boolean getBoolProperty(String propname, String bmName) {
        String value = Util.getProperty(propname, bmName);
        return value == null ? false : value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    public static int getIntProperty(String propname, String bmName) {
        String value = Util.getProperty(propname, bmName);
        return value == null ? -1 : Integer.parseInt(value);
    }

    public static long getLongProperty(String propname, String bmName) {
        String value = Util.getProperty(propname, bmName);
        return value == null ? -1L : Long.parseLong(value);
    }

    private static String getPropertyHelper(Properties props, String propname, String bmName) {
        String value = null;
        if (value == null && bmName != null && (value = props.getProperty(propname + "." + bmName)) != null && value.equals("null")) {
            value = null;
        }
        if (value == null && (value = props.getProperty(propname)) != null && value.equals("null")) {
            value = null;
        }
        return value;
    }

    public static String getProperty(String propname, String bmName) {
        String value = null;
        if (bmName != null && bmName.equals("check") && value == null && Configuration.defaultProperties != null) {
            value = Util.getPropertyHelper(Configuration.defaultProperties, propname, bmName);
        }
        if (value == null && Configuration.userProperties != null) {
            value = Util.getPropertyHelper(Configuration.userProperties, propname, bmName);
        }
        if (value == null && Configuration.defaultProperties != null) {
            value = Util.getPropertyHelper(Configuration.defaultProperties, propname, bmName);
        }
        return value;
    }

    static String getDefaultProperty(String propname, String bmName) {
        return Util.getPropertyHelper(Configuration.defaultProperties, propname, bmName);
    }

    static String getUserProperty(String propname, String bmName) {
        return Util.getPropertyHelper(Configuration.userProperties, propname, bmName);
    }

    public static void printProperties(Properties props) {
        Util.printProperties(Context.getOut(), props);
    }

    public static void printProperties(PrintStream ps, Properties props) {
        if (props != null) {
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                ps.println("  " + key + "=" + value);
            }
        }
    }

    public static void printReqs(HashMap<String, String> reqs) {
        Util.printProperties(Context.getOut(), reqs);
    }

    public static void printProperties(PrintStream ps, HashMap<String, String> reqs) {
        if (reqs != null) {
            for (String key : reqs.keySet()) {
                String value = reqs.get(key);
                ps.println("  " + key + "=" + value);
            }
        }
    }

    public static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean isScimarkAndNotMonteCarlo(String name) {
        return name != null && name.startsWith("scimark") && !name.equals("scimark.monte_carlo");
    }

    public static String getNextRawFileInDir() throws IOException {
        File resultDir = new File(Util.getProperty("specjvm.result.dir", null));
        return Util.getNextRawFileInDir(resultDir);
    }

    private static boolean createDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.exists()) {
            return true;
        }
        if (Util.createDir(dir.getParentFile())) {
            return dir.mkdir();
        }
        return false;
    }

    public static String getNextRawFileInDir(File resultDir) throws IOException {
        File newResultDir = null;
        String localName = null;
        int i = 1;
        while (newResultDir == null) {
            String is = i < 10 ? "00" + i : (i < 100 ? "0" + i : "" + i);
            localName = "SPECjvm2008." + is;
            newResultDir = new File(resultDir.getAbsolutePath() + "/" + localName);
            if (newResultDir.exists()) {
                newResultDir = null;
            }
            ++i;
        }
        if (!Util.createDir(newResultDir)) {
            throw new IOException("Failed to create dir " + newResultDir.getAbsolutePath());
        }
        Context.setResultDirNameCurrent(newResultDir + "");
        return newResultDir + "/" + localName + ".raw";
    }

    public static boolean isBenchmark(String s) {
        if ("check".equals(s)) {
            return false;
        }
        if (s.startsWith("startup")) {
            int index = s.indexOf(".");
            if (index == -1) {
                return false;
            }
            String startupBenchmark = s.substring(index + 1, s.length());
            if (startupBenchmark.startsWith("scimark")) {
                return new File(Launch.specjvmHomeDir + "/resources/" + startupBenchmark + "/validity." + startupBenchmark + ".dat").exists();
            }
            return Util.isBenchmark(startupBenchmark);
        }
        if (Util.isScimarkAndNotMonteCarlo(s)) {
            int index = s.lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            String scimarkBenchmark = s.substring(0, index);
            return new File(Launch.specjvmHomeDir + "/resources/" + scimarkBenchmark + "/validity." + scimarkBenchmark + ".dat").exists();
        }
        return new File(Launch.specjvmHomeDir + "/resources/" + s + "/validity." + s + ".dat").exists();
    }

    static String[] parseDefaultJvmArgs() {
        String allArgs = Util.getProperty("spec.jvm2008.report.jvm.command.line", "n/a");
        String msArg = Util.getProperty("spec.jvm2008.report.jvm.command.line.initial.heap.size", "n/a");
        String mxArg = Util.getProperty("spec.jvm2008.report.jvm.command.line.max.heap.size", "n/a");
        if (Launch.parseDefaultArgs && (allArgs == null || allArgs.equals("n/a"))) {
            RuntimeMXBean rtMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> args = rtMXBean.getInputArguments();
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                if (arg.indexOf("bootclasspath") != -1 || arg.indexOf("sun.java.launcher") != -1 || arg.indexOf("-showversion") != -1 || arg.indexOf("java.home") != -1) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
                if (arg.indexOf("-Xms") != -1 || arg.indexOf("-ms") != -1) {
                    msArg = Util.getSizeFromHeapArg(arg);
                }
                if (arg.indexOf("-Xmx") == -1 && arg.indexOf("-mx") == -1) continue;
                mxArg = Util.getSizeFromHeapArg(arg);
            }
            allArgs = sb.toString();
        }
        String[] ret = new String[]{allArgs, msArg, mxArg};
        return ret;
    }

    private static String getSizeFromHeapArg(String arg) {
        String msArg = null;
        if (arg == null) {
            return msArg;
        }
        for (int i = 1; i < arg.length(); ++i) {
            if (!Character.isDigit(arg.charAt(i))) continue;
            msArg = arg.substring(i);
            break;
        }
        return msArg;
    }
}

