/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import spec.harness.BenchmarkThread;
import spec.harness.Launch;
import spec.harness.SpecJVMBenchmark;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;

public abstract class SpecJVMBenchmarkBase
extends BenchmarkThread
implements SpecJVMBenchmark {
    public static void setupBenchmark() {
    }

    public static void setupIteration() {
    }

    protected SpecJVMBenchmarkBase(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public static void tearDownIteration() {
    }

    public static void tearDownBenchmark() {
    }

    public static String testType() {
        return "invalid";
    }

    public static void runSimple(Class benchmarkClass, String[] args) {
        if (!Launch.setupSimple(args)) {
            return;
        }
        try {
            BenchmarkResult bmResult = new BenchmarkResult();
            bmResult.setNames(benchmarkClass.getName());
            bmResult.setRunMode(1);
            bmResult.setNumberOfLoops(1);
            String[] bmArgs = new String[]{Util.getProperty("specjvm.benchmarks", null)};
            bmResult.setArgs(bmArgs);
            Class[] cArgs = new Class[]{BenchmarkResult.class, Integer.TYPE};
            Object[] inArgs = new Object[]{bmResult, 1};
            Constructor c = benchmarkClass.getConstructor(cArgs);
            Method setupBenchmarkMethod = benchmarkClass.getMethod("setupBenchmark", new Class[0]);
            Method setupIterationMethod = benchmarkClass.getMethod("setupIteration", new Class[0]);
            Method tearDownBenchmarkMethod = benchmarkClass.getMethod("tearDownBenchmark", new Class[0]);
            Method tearDownIterationMethod = benchmarkClass.getMethod("tearDownIteration", new Class[0]);
            setupBenchmarkMethod.invoke(null, new Object[0]);
            setupIterationMethod.invoke(null, new Object[0]);
            SpecJVMBenchmarkBase benchmark = (SpecJVMBenchmarkBase)c.newInstance(inArgs);
            benchmark.harnessMain();
            tearDownIterationMethod.invoke(null, new Object[0]);
            tearDownBenchmarkMethod.invoke(null, new Object[0]);
        }
        catch (ClassCastException e) {
            System.err.println("Class " + benchmarkClass.getName() + " does not seem to inherit SpecJVMBenchmarkBase.");
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

