/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import spec.harness.BenchmarkThread;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.StopBenchmarkException;
import spec.harness.Util;
import spec.harness.analyzer.AnalyzerResult;
import spec.harness.analyzer.AnalyzersRunner;
import spec.harness.results.BenchmarkResult;
import spec.harness.results.IterationResult;
import spec.harness.results.TestResult;
import spec.io.ValidityCheckOutputStream;

public class ProgramRunner
extends Thread {
    private static final boolean DEBUG = false;
    private static ProgramRunner myself = null;
    private static boolean printProgress = false;
    public BenchmarkResult bmResult;
    public BenchmarkThread[] bmts;
    private boolean isStartup;
    private Class bmClass = null;
    private Constructor bmConstructor = null;
    private Method bmSetupBenchmarkMethod = null;
    private Method bmSetupIterationMethod = null;
    private Method bmTearDownIterationMethod = null;
    private Method bmTearDownBenchmarkMethod = null;
    private Method bmTestTypeMethod = null;
    private static Object token = new Object();
    private boolean isInterrupted = false;

    public ProgramRunner(BenchmarkResult result, int mode) {
        super("Program Runner for " + result.getLogicalName());
        this.bmResult = result;
        if (mode == 2) {
            this.isStartup = true;
        }
        myself = this;
        this.setupBenchmarkMethods();
    }

    public static void setPrintProgress(boolean printProgress) {
        ProgramRunner.printProgress = printProgress;
    }

    public void run() {
        boolean oldValue = Context.getVerify();
        if (this.isStartup) {
            Context.setVerify(false);
        }
        this.runBenchmark();
        if (this.isStartup) {
            Context.setVerify(oldValue);
        }
    }

    private boolean setupBenchmarkMethods() {
        if (this.bmResult == null) {
            Context.getOut().println("The benchmark is not setup properly. There is no BenchmarkResult with configuration.");
            throw new StopBenchmarkException("The benchmark is not setup properly. There is no BenchmarkResult with configuration.");
        }
        String className = this.bmResult.getLogicalName();
        if (className.startsWith("startup")) {
            this.bmResult.setRunName("startup");
        }
        if (Util.isScimarkAndNotMonteCarlo(className)) {
            if (className.indexOf(".") != className.lastIndexOf(".")) {
                className = className.substring(0, className.lastIndexOf("."));
            }
            this.bmResult.setRunName(className);
        }
        if (className == null) {
            String message = "No class selected in runBenchmark. Aborting.";
            Context.getOut().println(message);
            this.bmResult.addError(message);
            return false;
        }
        String fullName = "spec.benchmarks." + this.bmResult.getRunName() + ".Main";
        try {
            this.bmClass = Class.forName(fullName);
            if (this.bmClass == null) {
                String message = "Could not load class " + fullName + ". Aborting.";
                Context.getOut().println(message);
                this.bmResult.addError(message);
            }
            this.bmConstructor = this.bmClass.getConstructor(BenchmarkResult.class, Integer.TYPE);
            this.bmSetupBenchmarkMethod = this.bmClass.getMethod("setupBenchmark", new Class[0]);
            this.bmSetupIterationMethod = this.bmClass.getMethod("setupIteration", new Class[0]);
            this.bmTearDownIterationMethod = this.bmClass.getMethod("tearDownIteration", new Class[0]);
            this.bmTearDownBenchmarkMethod = this.bmClass.getMethod("tearDownBenchmark", new Class[0]);
            this.bmTestTypeMethod = this.bmClass.getMethod("testType", new Class[0]);
            return true;
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error setting up Benchmark Class.", e);
        }
    }

    private SpecJVMBenchmarkBase createBmInstance(BenchmarkResult br, int threadid) {
        try {
            String name;
            if (Util.isScimarkAndNotMonteCarlo(br.getLogicalName()) && (name = br.getLogicalName()).indexOf(".") != name.lastIndexOf(".")) {
                name = name.substring(0, name.lastIndexOf("."));
                br.setRunName(name);
            }
            Object[] args = new Object[]{br, new Integer(threadid)};
            return (SpecJVMBenchmarkBase)this.bmConstructor.newInstance(args);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error creating benchmark instance for " + this.bmClass.getName(), e);
        }
    }

    private String invokeBmTestTypeMethod() {
        try {
            return (String)this.bmTestTypeMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error invoking bmTestTypeMethod", e);
        }
    }

    private void invokeBmSetupBenchmark() {
        try {
            this.bmSetupBenchmarkMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error invoking bmSetupBenchmarkMethod", e);
        }
    }

    private void invokeBmSetupIteration() {
        try {
            this.bmSetupIterationMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error invoking bmSetupIterationMethod", e);
        }
    }

    private void invokeBmTearDownIteration() {
        try {
            this.bmTearDownIterationMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error invoking bmTearDownIterationMethod", e);
        }
    }

    private void invokeBmTearDownBenchmark() {
        try {
            this.bmTearDownBenchmarkMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error invoking bmTearDownBenchmarkMethod", e);
        }
    }

    private boolean runBenchmark() {
        boolean valid = true;
        if (this.bmResult == null) {
            throw new StopBenchmarkException("The benchmark is not setup properly. There is no BenchmarkResult with configuration.");
        }
        try {
            int miniter = this.bmResult.getMinIter();
            int maxiter = this.bmResult.getMaxIter();
            String bmType = this.invokeBmTestTypeMethod();
            this.bmResult.setBmType(bmType);
            String bmName = this.bmResult.getLogicalName();
            if (bmType.equals("functional")) {
                this.bmResult.setNumberBmThreads(1);
                this.bmResult.setRunMode(1);
                this.bmResult.setNumberOfLoops(1);
                this.bmResult.setMinIter(1);
                this.bmResult.setMaxIter(1);
                this.bmResult.setNumberOfLoops(1);
                this.bmResult.setIterationTime(-1L);
                this.bmResult.setWarmupTime(-1L);
            }
            Context.getOut().println();
            Context.getOut().println("--- --- --- --- --- --- --- --- ---");
            Context.getOut().println();
            Context.getOut().println("  Benchmark:   " + this.bmResult.getLogicalName());
            Context.getOut().println("  Run mode:    " + TestResult.getRunModeDescription(this.bmResult.getRunMode()));
            Context.getOut().println("  Test type:   " + this.bmResult.getBmType());
            if (this.bmResult.getNumberBmThreads() > 0) {
                Context.getOut().println("  Threads:     " + this.bmResult.getNumberBmThreads());
            }
            if (this.bmResult.getWarmupTime() > 0L) {
                Context.getOut().println("  Warmup:      " + TestResult.millisAsSec(this.bmResult.getWarmupTime()));
            }
            Context.getOut().println("  Iterations:  " + (miniter < maxiter ? "Auto run mode " + miniter + ".." + maxiter : (maxiter == -1 ? "infinite" : "" + maxiter)));
            Context.getOut().println("  Run length:  " + this.bmResult.durDesc());
            if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
                this.bmResult.headerToXml(Context.getXmlResultFile(), 4);
            }
            Context.getFileCache().clearCache();
            if (this.bmResult.getBenchmarkForcegc() || this.bmResult.getBenchmarkDelay() > 0L) {
                Context.getOut().println();
                if (this.bmResult.getBenchmarkForcegc()) {
                    Context.getOut().println("Requests gc before starting.");
                    System.gc();
                    System.runFinalization();
                }
                if (this.bmResult.getBenchmarkDelay() > 0L) {
                    Context.getOut().println("Pause for " + TestResult.millisAsSec(this.bmResult.getBenchmarkDelay()));
                    this.pause(this.bmResult.getBenchmarkDelay());
                }
            }
            try {
                if (Context.getVerify()) {
                    if (Util.isScimarkAndNotMonteCarlo(bmName)) {
                        Context.getFileCache().loadFile(ValidityCheckOutputStream.getValidityFileName(bmName.substring(0, bmName.lastIndexOf("."))));
                    } else {
                        Context.getFileCache().loadFile(ValidityCheckOutputStream.getValidityFileName(bmName));
                    }
                }
                this.invokeBmSetupBenchmark();
            }
            catch (Throwable t) {
                String msg = "Error in setup of Benchmark.";
                this.bmResult.addError(msg);
                Context.getOut().println(msg);
                t.printStackTrace(Context.getOut());
            }
            if (this.bmResult.getWarmupTime() > 0L) {
                long dur;
                IterationResult itResult = new IterationResult();
                itResult.setBenchmarkResult(this.bmResult);
                itResult.setExpectedDuration(this.bmResult.getWarmupTime());
                itResult.setIteration(0);
                this.bmResult.setWarmupResult(itResult);
                valid = this.runIteration("Warmup (" + itResult.durDesc() + ")", itResult, this.bmResult);
                if (!this.bmResult.getForcedIterationTime() && valid && itResult.getScore() < 5.0 / ((double)this.bmResult.getIterationTime() / 60000.0) && (dur = Math.round(300.0 / itResult.getScore())) > this.bmResult.getIterationTime()) {
                    this.bmResult.setIterationTime(1000L * dur);
                    Context.getOut().println("Warning: Current run time for one iteration is too low.");
                    Context.getOut().println("Increasing iteration time to " + TestResult.millisAsSec(this.bmResult.getIterationTime()));
                }
            }
            if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
                this.bmResult.middleToXml(Context.getXmlResultFile(), 4);
            }
            double preRes1 = Double.MIN_VALUE;
            double preRes2 = Double.MIN_VALUE;
            for (int iter = 1; valid && (maxiter == -1 || iter <= maxiter); ++iter) {
                IterationResult itResult = new IterationResult();
                itResult.setBenchmarkResult(this.bmResult);
                itResult.setExpectedDuration(this.bmResult.getIterationTime());
                itResult.setExpectedLoops(this.bmResult.getNumberOfLoops());
                itResult.setIteration(iter);
                this.bmResult.addIterationResult(itResult);
                valid = this.runIteration("Iteration " + iter + " (" + itResult.durDesc() + ")", itResult, this.bmResult);
                if (iter >= miniter && itResult.getScore() < 1.01 * preRes1 && itResult.getScore() < 1.01 * preRes2) break;
                preRes2 = preRes1;
                preRes1 = itResult.getScore();
                if (!valid || iter + 1 > maxiter || !this.bmResult.getBenchmarkForcegc() && this.bmResult.getBenchmarkDelay() <= 0L) continue;
                Context.getOut().println();
                if (this.bmResult.getIterationForcegc()) {
                    Context.getOut().println("Requests gc between iterations.");
                    System.gc();
                    System.runFinalization();
                }
                if (this.bmResult.getIterationDelay() <= 0L) continue;
                Context.getOut().println("Pause for " + TestResult.millisAsSec(this.bmResult.getIterationDelay()));
                ProgramRunner.sleep(this.bmResult.getIterationDelay());
            }
            try {
                this.invokeBmTearDownBenchmark();
            }
            catch (Throwable t) {
                String msg = "Error in tear down of Benchmark.";
                this.bmResult.addError(msg);
                Context.getOut().println(msg);
                t.printStackTrace(Context.getOut());
            }
        }
        catch (Throwable e) {
            String msg = "#### " + this.bmResult.getLogicalName() + " exited with exception: " + e.getClass().getName() + ": " + e.getMessage() + " ####\n";
            this.bmResult.addError(msg);
            Context.getOut().print(msg);
            e.printStackTrace(Context.getOut());
            Context.getOut().println("");
        }
        Context.getOut().println();
        valid = this.bmResult.isValid();
        if (!valid) {
            Context.getOut().println("Errors in benchmark: " + this.bmResult.getLogicalName());
            Iterator<String> ei = this.bmResult.getAllErrors("").iterator();
            while (ei.hasNext()) {
                Context.getOut().println("  " + ei.next());
            }
        } else {
            Context.getOut().println("Valid run!");
        }
        if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
            this.bmResult.footerToXml(Context.getXmlResultFile(), 4);
        }
        if (!this.bmResult.getBmType().equals("functional")) {
            Context.getOut().println("Score on " + this.bmResult.getLogicalName() + ": " + this.bmResult.resultString());
        }
        Context.getOut().println();
        return this.bmResult.isValid();
    }

    private boolean runIteration(String runDesc, IterationResult itResult, BenchmarkResult bmResult) {
        try {
            String msg;
            int i;
            Context.getOut().println();
            Context.getOut().println(runDesc + " begins: " + new Date());
            Context.getOut().flush();
            AnalyzersRunner.setupAnalyzers(itResult, bmResult.getAnalyzerFreq());
            try {
                this.invokeBmSetupIteration();
            }
            catch (Throwable t) {
                String msg2 = "Error in setup of iteration.";
                itResult.addError(msg2);
                itResult.addError(ProgramRunner.getStackTraceAsString(t));
                throw new StopBenchmarkException(msg2, t);
            }
            int nbmts = ProgramRunner.getNoBmHarnessThreads(bmResult);
            this.bmts = new SpecJVMBenchmarkBase[nbmts];
            for (int i2 = 0; i2 < this.bmts.length; ++i2) {
                try {
                    this.bmts[i2] = this.createBmInstance(bmResult, i2 + 1);
                }
                catch (Throwable t) {
                    String msg3 = "Error in setup of iteration.";
                    itResult.addError(msg3);
                    itResult.addError(ProgramRunner.getStackTraceAsString(t));
                    throw new StopBenchmarkException(msg3, t);
                }
                this.bmts[i2].setItResult(itResult);
                this.bmts[i2].setPrintProgress(printProgress);
            }
            AnalyzersRunner.invokeStartMeasurementIntervalForAnalyzers();
            long startTime = System.currentTimeMillis();
            long stopTime = startTime + itResult.getExpectedDuration();
            itResult.setStartTime(startTime);
            itResult.setStopTime(stopTime);
            for (i = 0; i < this.bmts.length; ++i) {
                this.bmts[i].start();
            }
            if (bmResult.getRunMode() == 2) {
                try {
                    ProgramRunner.sleep(itResult.getExpectedDuration());
                }
                catch (InterruptedException e1) {
                    msg = "Harness interruped during measurement period.";
                    itResult.addError(msg);
                }
                itResult.setEndTime(itResult.getStopTime());
                ProgramRunner.endOfMeasurementInterval(System.currentTimeMillis());
                itResult.abortRun();
            }
            for (i = 0; i < this.bmts.length; ++i) {
                try {
                    this.bmts[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    String msg4 = "Interrupted when joining benchmark thread " + i + ": " + e.getMessage();
                    itResult.addError(msg4);
                    itResult.addError(ProgramRunner.getStackTraceAsString(e));
                    itResult.setEndTime(itResult.getStopTime());
                    throw new StopBenchmarkException(msg4, e);
                }
            }
            if (printProgress) {
                Context.getOut().println("\n");
            }
            try {
                this.invokeBmTearDownIteration();
            }
            catch (Throwable t) {
                msg = "Error in tear down of iteration.";
                itResult.addError(msg);
                itResult.addError(ProgramRunner.getStackTraceAsString(t));
                throw new StopBenchmarkException(msg, t);
            }
            AnalyzersRunner.tearDownAnalyzers(itResult);
        }
        catch (StopBenchmarkException sbe) {
            itResult.addError("Iteration failed.");
        }
        Context.getOut().println(runDesc + " ends:   " + new Date());
        Context.getOut().println(runDesc + " result: " + itResult.resultString(bmResult.getBmType()));
        Iterator<AnalyzerResult> iter = itResult.getAnalyzerSummaries();
        while (iter.hasNext()) {
            Context.getOut().println(runDesc + " analyzer result " + iter.next().getDescription());
        }
        if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
            itResult.toXml(Context.getXmlResultFile(), 6);
        }
        return itResult.isValid();
    }

    public static String getStackTraceAsString(Throwable t) {
        StringBuilder sb = new StringBuilder(t.getClass().getName() + ": " + t.getMessage() + "\n");
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            sb.append(ste[i].toString() + "\n");
        }
        return sb.toString();
    }

    public static int getNoBmHarnessThreads(BenchmarkResult bmResult) {
        int nbmts = 0;
        if (bmResult.getBmType().equals("multi")) {
            nbmts = bmResult.getNumberBmThreads();
        } else if (bmResult.getBmType().equals("single")) {
            nbmts = 1;
        } else if (bmResult.getBmType().equals("functional")) {
            nbmts = 1;
        } else {
            throw new StopBenchmarkException("Unknown benchmark type: " + bmResult.getBmType());
        }
        return nbmts;
    }

    void pause(long pauseTime) {
        try {
            ProgramRunner.sleep(pauseTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interruptProgramRunner() {
        Object object = token;
        synchronized (object) {
            if (!ProgramRunner.myself.isInterrupted) {
                ProgramRunner.myself.isInterrupted = true;
                myself.interrupt();
            }
        }
    }

    public static void endOfMeasurementInterval(long iterEndTime) {
        AnalyzersRunner.invokeEndMeasurementIntervalForAnalyzers();
    }
}

