/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import spec.harness.BenchmarkThread;
import spec.harness.CommandLineParser;
import spec.harness.Configuration;
import spec.harness.Context;
import spec.harness.KnownIssues;
import spec.harness.ProgramRunner;
import spec.harness.StopBenchmarkException;
import spec.harness.Util;
import spec.harness.analyzer.AnalyzersRunner;
import spec.harness.results.BenchmarkResult;
import spec.harness.results.SuiteResult;
import spec.reporter.Reporter;
import spec.validity.Digests;

public class Launch {
    public static int currentNumberBmThreads;
    public static boolean verbose;
    static boolean parseDefaultArgs;
    static String workLoad;
    static String specjvmHomeDir;
    static final int defaultMode = 1;
    static final int startupMode = 2;
    static final int scimarkMode = 3;

    public static void runBenchmarkSuite(Properties commandLineProps) {
        String pf = commandLineProps.getProperty("specjvm.propfile");
        try {
            Configuration.userProperties = Configuration.readProperties(pf);
        }
        catch (Exception e) {
            System.out.println("Error reading properites file '" + pf + "'");
            System.out.println(e.getMessage());
            return;
        }
        Configuration.userProperties.putAll((Map<?, ?>)commandLineProps);
        Configuration.userProperties.put("specjvm.home.dir", specjvmHomeDir);
        verbose = Util.getBoolProperty("specjvm.print.verbose", null);
        Launch.setupContext();
        SuiteResult sResult = Context.getSuiteResult();
        String version = "n/a";
        try {
            Properties bp = new Properties();
            bp.load(new FileInputStream(specjvmHomeDir + "/version.txt"));
            String versionNumber = bp.getProperty("Kit_version", "-");
            String buildDate = bp.getProperty("Build_date", "-");
            String benchName = bp.getProperty("Benchmark", "-");
            version = benchName + " " + versionNumber + " (" + buildDate + ")";
        }
        catch (Exception e) {
            // empty catch block
        }
        sResult.setKitVersion(version);
        try {
            Configuration.checkSetup(sResult);
        }
        catch (StopBenchmarkException e) {
            e.printStackTrace();
            return;
        }
        ProgramRunner.setPrintProgress(Util.getBoolProperty("specjvm.print.progress", null));
        String benchmarks = Util.getProperty("specjvm.benchmarks", null);
        String propfile = Util.getProperty("specjvm.propfile", null);
        boolean continueOnError = Util.getBoolProperty("specjvm.continue.on.error", null);
        boolean doCheckTest = Util.getBoolProperty("specjvm.run.initial.check", null);
        boolean doCheckSumCheck = Util.getBoolProperty("specjvm.run.checksum.validation", null);
        Configuration.setupReportInfo(sResult, Configuration.userProperties);
        sResult.setWorkloadName(Util.getProperty("specjvm.run.name", null));
        Context.getOut().println();
        Context.getOut().println(Util.getProperty("specjvm.run.name", null));
        Context.getOut().println("  Properties file:   " + (propfile != null ? propfile : "none"));
        if (Util.getProperty("specjvm.additional.properties.file", null) != null) {
            Context.getOut().println("  Properties file 2: " + Util.getProperty("specjvm.additional.properties.file", null));
        }
        if (AnalyzersRunner.getNoAnalyzer() > 0) {
            Context.getOut().println("  Analyzers:         " + AnalyzersRunner.getAnalyzerNames());
        }
        if (!Context.getSpecBasePath().equals(".")) {
            Context.getOut().println("  Base dir:          " + Context.getSpecBasePath());
        }
        Context.getOut().println("  Benchmarks:        " + benchmarks);
        Context.getOut().println();
        if (!sResult.isCompliant()) {
            Context.getOut().println("  WARNING: Run will not be compliant.");
            Iterator<String> iter = sResult.getViolations().iterator();
            while (iter.hasNext()) {
                Context.getOut().println("  " + iter.next());
            }
            Context.getOut().println();
        }
        if (verbose) {
            Context.getOut().println("User defined properties:");
            Util.printProperties(Configuration.userProperties);
            Context.getOut().println();
            Context.getOut().println("Default properties:");
            Util.printProperties(Configuration.defaultProperties);
            Context.getOut().println();
            Context.getOut().println("Requirements:");
            Util.printReqs(Configuration.propsRequirements);
            Context.getOut().println();
        }
        boolean cont = true;
        StringTokenizer st = new StringTokenizer(benchmarks);
        while (st.hasMoreElements()) {
            String bm = st.nextToken().trim();
            if (Util.isBenchmark(bm)) continue;
            Context.getOut().println("Unknown benchmark: " + bm);
            cont = false;
        }
        if (!cont) {
            Context.getOut().println("Aborting.");
            Context.getOut().println();
            return;
        }
        if (doCheckSumCheck) {
            String jarCheckResult = Launch.checkBenchmarkKit();
            if (jarCheckResult != null) {
                sResult.addViolation(jarCheckResult);
                Context.getOut().println("\n  Kit signature and checksum validation failed.");
                Context.getOut().println("  " + jarCheckResult);
                Context.getOut().println("  WARNING: Run will not be compliant.");
            } else {
                Context.getOut().println("passed.");
            }
        }
        String resultFileName = null;
        if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
            try {
                resultFileName = Launch.openResultFile(Configuration.userProperties);
            }
            catch (IOException ioe) {
                Context.getOut().println("Aborting.");
                Context.getOut().println();
                return;
            }
        }
        if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
            sResult.headerToXml(Context.getXmlResultFile(), 0);
        }
        BenchmarkResult check = null;
        if (doCheckTest) {
            check = Launch.runOneBenchmark("check", 1, 1, 1);
            sResult.addBenchmarkResults(check);
        }
        if (check == null || check.isValid()) {
            StringTokenizer bmt = new StringTokenizer(benchmarks);
            while (bmt.hasMoreTokens()) {
                BenchmarkResult res;
                int fixedOpsNumber;
                String benchmark = bmt.nextToken();
                int runType = Util.getIntProperty("specjvm.run.type", null);
                int n = fixedOpsNumber = runType == 2 ? -1 : Util.getIntProperty("specjvm.fixed.operations", benchmark);
                if (BenchmarkThread.createValidityCheckFiles) {
                    Launch.runOneBenchmark(benchmark, 1, 1, 1);
                    continue;
                }
                if (benchmark.startsWith("scimark")) {
                    if (benchmark.endsWith("large")) {
                        Configuration.setupProp("specjvm.scimark.size", "LARGE", "WHATEVER", "LARGE", "WHATEVER");
                    } else if (benchmark.endsWith("small")) {
                        Configuration.setupProp("specjvm.scimark.size", "SMALL", "WHATEVER", "SMALL", "WHATEVER");
                    } else {
                        Configuration.setupProp("specjvm.scimark.size", "DEFAULT", "WHATEVER", "DEFAULT", "WHATEVER");
                    }
                    res = Launch.runOneBenchmark(benchmark, runType, fixedOpsNumber, 3);
                } else {
                    res = benchmark.startsWith("startup") ? Launch.runOneBenchmark(benchmark, 1, 1, 2) : Launch.runOneBenchmark(benchmark, runType, fixedOpsNumber, 1);
                }
                sResult.addBenchmarkResults(res);
                if (res.isValid() || continueOnError) continue;
                Context.getOut().println("Benchmark " + benchmark + " failed. Aborting run.");
                Context.getOut().println();
                break;
            }
        } else {
            Context.getOut().println("No benchmarks will be run, since initial check test failed.");
            KnownIssues.printKnownIssueJavacVersion();
        }
        AnalyzersRunner.tearDownAnalyzerClasses();
        if (Util.getBoolProperty("specjvm.create.xml.report", null)) {
            sResult.footerToXml(Context.getXmlResultFile(), 0);
            Launch.closeResultFile(resultFileName);
        }
        if (Util.getBoolProperty("specjvm.create.xml.report", null) && (Util.getBoolProperty("specjvm.create.html.report", null) || Util.getBoolProperty("specjvm.create.txt.report", null))) {
            try {
                String[] rArgs = new String[]{resultFileName, "-sub", "true", "-summary", "true", "-txt", Util.getProperty("specjvm.create.txt.report", null), "-html", Util.getProperty("specjvm.create.txt.report", null)};
                String result = Launch.createReport(rArgs);
                Context.getOut().println("");
                Context.getOut().println(result);
            }
            catch (OutOfMemoryError oome) {
                Context.getOut().println("Error while creating report. Out of Memory.");
            }
            catch (Throwable t) {
                Context.getOut().println("Error while creating report: " + t.getMessage());
                t.printStackTrace(Context.getOut());
            }
        }
        KnownIssues.printKnownIssuesInfo();
        if (Util.getBoolProperty("specjvm.spin.at.end", null)) {
            Context.getOut().println("Harness will sleep here.");
            while (Util.sleep(1000L)) {
            }
        }
    }

    protected static String openResultFile(Properties userProperties) throws IOException, FileNotFoundException {
        File resultDir = new File(Context.getResultDirNameBase());
        if (resultDir.exists()) {
            if (!resultDir.isDirectory()) {
                throw new IOException("Result dir " + resultDir.getAbsolutePath() + " is a file and already exists.");
            }
        } else if (!resultDir.mkdir()) {
            throw new IOException("Failed to create dir " + resultDir.getAbsolutePath());
        }
        String xmlFileName = Util.getNextRawFileInDir(resultDir);
        PrintStream xmlPs = new PrintStream(new FileOutputStream(xmlFileName));
        Context.setXmlResultFile(xmlPs);
        return xmlFileName;
    }

    protected static void closeResultFile(String resultFile) {
        try {
            Context.getOut().println("Results are stored in: \n" + new File(resultFile).getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Context.closeXmlResultFile();
    }

    protected static void closeSubmissionFile(String submissionFile) {
        Context.getOut().println("Results are stored in: \n" + submissionFile + "\n");
    }

    public static String createReport(String xmlFileName) throws Exception {
        return Launch.createReport(new String[]{xmlFileName});
    }

    public static String createReport(String[] reporterArgs) throws Exception {
        return Reporter.main2(reporterArgs);
    }

    private static BenchmarkResult runOneBenchmark(String bm, int runMode, int fixedLoops, int mode) {
        BenchmarkResult bmResult = new BenchmarkResult();
        String[] args = null;
        args = mode == 2 ? new String[]{bm.substring(bm.indexOf(".") + 1)} : (mode == 3 ? new String[]{bm.substring(0, bm.lastIndexOf("."))} : new String[]{});
        bmResult.setNames(bm);
        bmResult.setArgs(args);
        bmResult.setRunMode(runMode);
        bmResult.setNumberOfLoops(fixedLoops);
        bmResult.setIterationTime(Util.getTimeProperty("specjvm.iteration.time", bm), Util.getBoolProperty("specjvm.iteration.time.forced", bm));
        int miniter = Util.getIntProperty("specjvm.miniter", bm);
        bmResult.setMinIter(miniter);
        int maxiter = Util.getIntProperty("specjvm.maxiter", bm);
        if (maxiter != -1 && maxiter < miniter) {
            maxiter = miniter;
        }
        bmResult.setMaxIter(maxiter);
        currentNumberBmThreads = Util.getHwtCalcProperty("specjvm.benchmark.threads", bm);
        bmResult.setNumberBmThreads(mode == 2 ? 1 : currentNumberBmThreads);
        bmResult.setWarmupTime(Util.getTimeProperty("specjvm.benchmark.warmup.time", bm));
        bmResult.setIterationForcegc(Util.getBoolProperty("specjvm.iteration.systemgc", bm));
        bmResult.setIterationDelay(Util.getTimeProperty("specjvm.iteration.delay", bm));
        bmResult.setBenchmarkForcegc(Util.getBoolProperty("specjvm.benchmark.systemgc", bm));
        bmResult.setBenchmarkDelay(Util.getTimeProperty("specjvm.benchmark.delay", bm));
        bmResult.setChecksum(Util.getBoolProperty("specjvm.validity.checksum", bm));
        bmResult.setAnalyzers(Util.getProperty("specjvm.benchmark.analyzer.names", bm));
        bmResult.setAnalyzerFreq(Util.getTimeProperty("specjvm.benchmark.analyzer.frequency", bm));
        if (runMode == 1) {
            bmResult.setIterationTime(-1L);
            bmResult.setNumberOfLoops(fixedLoops);
            bmResult.setWarmupTime(-1L);
        }
        ProgramRunner runner = new ProgramRunner(bmResult, mode);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace(Context.getOut());
            bmResult.addError("BenchmarkRunner failed to join: " + e.getMessage());
        }
        return bmResult;
    }

    private static String checkBenchmarkKit() {
        try {
            Class.forName("spec.validity.Digests");
        }
        catch (ClassNotFoundException e) {
            return "Digests.java missing. Checksum test will not be run.";
        }
        try {
            Digests digests = new Digests(Context.getOut());
            Context.getOut().println("  Kit signature and checksum is validated.");
            Context.getOut().println("  This can take several minutes.");
            Context.getOut().println("  Use argument '-ikv' to skip this.");
            Context.getOut().print("  ");
            String res = digests.crunch_jars();
            if (res != null) {
                return "Checksum test failed for jar files (" + res + "). Kit may not be changed or rebuild.";
            }
            res = digests.crunch_resources();
            if (res != null) {
                return "Checksum test failed for resource files (" + res + "). Kit may not be changed or rebuild.";
            }
        }
        catch (Throwable e) {
            return "Checksum test throw exception, message: " + e.getMessage();
        }
        return null;
    }

    public static void setupContext() {
        Context.setSpecBasePath(Util.getProperty("specjvm.home.dir", null));
        Context.setResultDirNameBase(Util.getProperty("specjvm.result.dir", null));
        Context.setVerify(Util.getBoolProperty("specjvm.verify", null));
        if (verbose) {
            System.out.println(Context.staticToString());
        }
        Context.setSuiteResult(new SuiteResult());
    }

    public static boolean setupSimple(String[] args) {
        Properties commandLineProps = new Properties();
        boolean cont = CommandLineParser.parseArgs(args, commandLineProps);
        if (!cont) {
            return false;
        }
        try {
            Configuration.userProperties = Configuration.readProperties(commandLineProps.getProperty("specjvm.propfile"));
        }
        catch (Exception e) {
            System.out.println("Error reading run properties: " + e.getMessage());
            return false;
        }
        Configuration.userProperties.putAll((Map<?, ?>)commandLineProps);
        Configuration.userProperties.put("specjvm.home.dir", specjvmHomeDir);
        Configuration.userProperties.put("specjvm.benchmark.threads", "1");
        currentNumberBmThreads = 1;
        Launch.setupContext();
        return true;
    }

    public static void main(String[] args) {
        Properties commandLineProps = new Properties();
        boolean cont = CommandLineParser.parseArgs(args, commandLineProps);
        if (!cont) {
            return;
        }
        Launch.runBenchmarkSuite(commandLineProps);
    }

    static {
        verbose = false;
        parseDefaultArgs = false;
        workLoad = "not set";
        specjvmHomeDir = System.getProperty("specjvm.home.dir", ".");
        Configuration.setupProperties();
    }
}

