/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.File;
import java.io.PrintStream;
import spec.harness.results.SuiteResult;
import spec.io.FileCache;

public final class Context {
    private static String specBasePath = ".";
    private static String specResultDirBase = specBasePath + "/results";
    private static String specResultDirCurrent = specBasePath + "/results";
    private static boolean verify = true;
    private static PrintStream xmlResultFile = null;
    private static FileCache fileCache = new FileCache();
    private static ThreadLocal<Object> tlOut = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return System.out;
        }
    };
    private static SuiteResult suiteResult = null;

    public static SuiteResult getSuiteResult() {
        return suiteResult;
    }

    public static void setSuiteResult(SuiteResult sr) {
        suiteResult = sr;
    }

    public static PrintStream getOut() {
        return (PrintStream)tlOut.get();
    }

    public static void setOut(PrintStream os) {
        tlOut.set(os);
    }

    public static void setSpecBasePath(String basepath) {
        specBasePath = basepath;
    }

    public static String getSpecBasePath() {
        return specBasePath;
    }

    public static void setResultDirNameBase(String resultDirNameBase) {
        specResultDirBase = resultDirNameBase;
    }

    public static String getResultDirNameBase() {
        return specResultDirBase;
    }

    public static void setResultDirNameCurrent(String resultDirNameCurrent) {
        specResultDirCurrent = resultDirNameCurrent;
    }

    public static String getResultDirNameCurrent() {
        return specResultDirCurrent;
    }

    public static String getResourceDirFor(Class benchmarkMainClass) {
        String respath;
        String prefix = "spec.benchmarks.";
        String benchmark = benchmarkMainClass.getPackage().getName();
        if (benchmark.startsWith(prefix)) {
            benchmark = benchmark.substring(prefix.length());
        }
        File resdir = new File(Context.getSpecBasePath() + File.separator + "resources" + File.separator + benchmark);
        try {
            respath = resdir.getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            respath = ".";
        }
        return respath;
    }

    public static void setVerify(boolean value) {
        verify = value;
    }

    public static boolean getVerify() {
        return verify;
    }

    public static FileCache getFileCache() {
        return fileCache;
    }

    public static String staticToString() {
        return "Context: base=" + specBasePath;
    }

    public static PrintStream getXmlResultFile() {
        return xmlResultFile;
    }

    public static void setXmlResultFile(PrintStream xmlResultFile) {
        Context.xmlResultFile = xmlResultFile;
    }

    public static void closeXmlResultFile() {
        xmlResultFile.close();
        xmlResultFile = null;
    }
}

