/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import spec.benchmarks.startup.StartupBenchmarkOutput;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.StopBenchmarkException;
import spec.harness.Util;
import spec.harness.VMVersionTest;
import spec.harness.analyzer.AnalyzersRunner;
import spec.harness.results.SuiteResult;

public class Configuration {
    static Properties userProperties;
    static Properties invalidProperties;
    static Properties additionalConfigurationProperties;
    static Properties defaultProperties;
    static Properties defaultPropertiesSPECbase;
    static Properties defaultPropertiesSPECpeak;
    static Properties defaultPropertiesLagom;
    static HashMap<String, String> propsRequirements;
    static HashMap<String, String> propsRequirementsSPECbase;
    static HashMap<String, String> propsRequirementsSPECpeak;
    static HashMap<String, String> propsRequirementsLagom;

    static void setupProp(String name, String defValueSPECbase, String requirementSPECbase, String defValueSPECpeak, String requirementSPECpeak, String defValueLagom, String requirementLagom) {
        defaultPropertiesSPECbase.put(name, defValueSPECbase == null ? "null" : defValueSPECbase);
        propsRequirementsSPECbase.put(name, requirementSPECbase);
        defaultPropertiesSPECpeak.put(name, defValueSPECpeak == null ? "null" : defValueSPECpeak);
        propsRequirementsSPECpeak.put(name, requirementSPECpeak);
        defaultPropertiesLagom.put(name, defValueLagom == null ? "null" : defValueLagom);
        propsRequirementsLagom.put(name, requirementLagom);
    }

    static void setupProp(String name, String defValueSPEC, String requirementSPEC, String defValueLagom, String requirementLagom) {
        Configuration.setupProp(name, defValueSPEC, requirementSPEC, defValueSPEC, requirementSPEC, defValueLagom, requirementLagom);
    }

    static void setupProp(String name, String defValue, String requirement) {
        Configuration.setupProp(name, defValue, requirement, defValue, requirement);
    }

    static String getFixedOperationsProp(String bname) {
        return "specjvm.fixed.operations." + bname;
    }

    static void setupProperties() {
        invalidProperties = new Properties();
        additionalConfigurationProperties = new Properties();
        defaultPropertiesSPECbase = new Properties();
        defaultPropertiesSPECpeak = new Properties();
        defaultPropertiesLagom = new Properties();
        defaultProperties = defaultPropertiesSPECbase;
        propsRequirementsSPECbase = new HashMap();
        propsRequirementsSPECpeak = new HashMap();
        propsRequirementsLagom = new HashMap();
        propsRequirements = propsRequirementsSPECbase;
        Configuration.setupProp("specjvm.run.name", "SPECjvm2008 Base", "MATCH", "SPECjvm2008 Peak", "MATCH", "SPECjvm2008 Lagom Workload", "MATCH");
        Configuration.setupProp("specjvm.run.type", "2", "MATCH", "1", "MATCH");
        Configuration.setupProp("specjvm.benchmark.threads", "#hwt", "WHATEVER");
        Configuration.setupProp("specjvm.fixed.operations", null, "NOT_SET", "-1", "WHATEVER");
        Configuration.setupProp("specjvm.iteration.time", "240s", "MATCH", "240s", "TIME_AT_LEAST", "0s", "MATCH");
        Configuration.setupProp("specjvm.iteration.time.forced", null, "NOT_SET", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmark.warmup.time", "120s", "MATCH", "120s", "WHATEVER", "0s", "MATCH");
        Configuration.setupProp("specjvm.miniter", "1", "MATCH", "1", "MATCH", "1", "WHATEVER");
        Configuration.setupProp("specjvm.maxiter", "1", "MATCH", "1", "MATCH", "1", "WHATEVER");
        Configuration.setupProp("specjvm.miniter.check", "1", "MATCH", "1", "MATCH");
        Configuration.setupProp("specjvm.maxiter.check", "1", "MATCH", "1", "MATCH");
        Configuration.setupProp("specjvm.iteration.systemgc", "false", "MATCH", "false", "MATCH");
        Configuration.setupProp("specjvm.iteration.delay", "0s", "TIME_MAX_5s", "0s", "TIME_MAX_5s");
        Configuration.setupProp("specjvm.benchmark.systemgc", "false", "MATCH", "false", "MATCH");
        Configuration.setupProp("specjvm.benchmark.delay", "0s", "TIME_MAX_5s", "0s", "TIME_MAX_5s");
        Configuration.setupProp("specjvm.startup.jvm_options", null, "NOT_SET", null, "WHATEVER", null, "WHATEVER");
        Configuration.setupProp("specjvm.benchmark.startup.launcher", null, "SPECIAL", null, "SPECIAL");
        Configuration.setupProp(Configuration.getFixedOperationsProp("compiler.compiler"), null, "NOT_SET", "20", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("compiler.sunflow"), null, "NOT_SET", "20", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("compress"), null, "NOT_SET", "50", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("crypto.aes"), null, "NOT_SET", "20", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("crypto.rsa"), null, "NOT_SET", "150", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("crypto.signverify"), null, "NOT_SET", "125", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("derby"), null, "NOT_SET", "30", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("mpegaudio"), null, "NOT_SET", "50", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.fft.large"), null, "NOT_SET", "10", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.lu.large"), null, "NOT_SET", "4", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.monte_carlo"), null, "NOT_SET", "900", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.sor.large"), null, "NOT_SET", "15", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.sparse.large"), null, "NOT_SET", "10", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.fft.small"), null, "NOT_SET", "100", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.lu.small"), null, "NOT_SET", "125", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.sor.small"), null, "NOT_SET", "75", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("scimark.sparse.small"), null, "NOT_SET", "25", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("serial"), null, "NOT_SET", "25", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("sunflow"), null, "NOT_SET", "30", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("xml.transform"), null, "NOT_SET", "7", "MATCH");
        Configuration.setupProp(Configuration.getFixedOperationsProp("xml.validation"), null, "NOT_SET", "40", "MATCH");
        Configuration.setupProp("specjvm.verify", "true", "MATCH");
        Configuration.setupProp("specjvm.validity.checksum", "true", "MATCH");
        Configuration.setupProp("specjvm.valid.setup", null, "NOT_SET");
        Configuration.setupProp("specjvm.create.xml.report", "true", "MATCH");
        Configuration.setupProp("specjvm.create.txt.report", "true", "WHATEVER");
        Configuration.setupProp("specjvm.create.html.report", "true", "WHATEVER");
        Configuration.setupProp("specjvm.generateValidityCheckFiles", "false", "MATCH");
        Configuration.setupProp("specjvm.spin.at.end", "false", "MATCH");
        Configuration.setupProp("specjvm.print.verbose", "false", "WHATEVER");
        Configuration.setupProp("specjvm.print.progress", "false", "WHATEVER");
        Configuration.setupProp("specjvm.home.dir", ".", "WHATEVER", ".", "WHATEVER");
        Configuration.setupProp("specjvm.result.dir", "./results", "WHATEVER", "./results", "WHATEVER");
        Configuration.setupProp("specjvm.propfile", null, "WHATEVER", null, "WHATEVER");
        Configuration.setupProp("specjvm.additional.properties.file", null, "WHATEVER", null, "WHATEVER");
        Configuration.setupProp("specjvm.hardware.threads.override", null, "WHATEVER", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmark.analyzer.names", "", "WHATEVER");
        Configuration.setupProp("specjvm.benchmark.analyzer.frequency", "1s", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.PowerAnalyzer.host", "127.0.0.1", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.PowerAnalyzer.port", "8888", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.PowerAnalyzer.verbose", "false", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.PowerAnalyzer.useDummy", "false", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.TempAnalyzer.host", "127.0.0.1", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.TempAnalyzer.port", "8889", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.TempAnalyzer.verbose", "false", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.TempAnalyzer.useDummy", "false", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.PowerMeter.verbose", "false", "WHATEVER");
        Configuration.setupProp("spec.harness.analyzer.TempSensor.verbose", "false", "WHATEVER");
        Configuration.setupProp("specjvm.benchmarks", "startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation", "MATCH", "compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation", "MATCH");
        Configuration.setupProp("specjvm.continue.on.error", "false", "WHATEVER");
        Configuration.setupProp("specjvm.run.initial.check", "true", "MATCH");
        Configuration.setupProp("specjvm.run.checksum.validation", "true", "MATCH");
        Configuration.setupProp("specjvm.benchmark.threads.check", "1", "MATCH");
        Configuration.setupProp("specjvm.benchmark.threads.sunflow", "0.5x#hwt", "WHATEVER");
        Configuration.setupProp("specjvm.scimark.size", "DEFAULT", "MATCH");
        Configuration.setupProp("specjvm.benchmark.sunflow.threads.per.instance", "4", "MATCH");
        Configuration.setupProp("specjvm.benchmark.xml.transform.out.dir", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmark.xml.transform.leave.out.dir", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmark.xml.validation.input.dir", null, "SPECIAL");
        Configuration.setupProp("specjvm.benchmark.startup.scimark.all", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmark.startup.crypto.all", null, "NOT_SET");
        Configuration.setupProp("specjvm.benchmarks.derby.debug", null, "WHATEVER");
        Configuration.setupProp("specjvm.benchmarks.startup.debug", null, "WHATEVER");
        Configuration.setupProp("specjvm.io.validation.debug", null, "WHATEVER");
    }

    public static void checkSetup(SuiteResult sResult) {
        String key;
        String benchmarks = Util.getProperty("specjvm.benchmarks", null);
        if (benchmarks == null) {
            throw new StopBenchmarkException("No benchmarks specified, property is null.");
        }
        if (Launch.workLoad.equals("not set")) {
            String[] allJvmArgs = Util.parseDefaultJvmArgs();
            String jvmOptionsStartup = Util.getProperty("specjvm.startup.jvm_options", null);
            if ((allJvmArgs[0] == null || allJvmArgs[0].equals("n/a") || allJvmArgs[0].equals("") || allJvmArgs[0].equals("-showversion")) && (jvmOptionsStartup == null || jvmOptionsStartup.equals("n/a") || jvmOptionsStartup.equals("") || jvmOptionsStartup.equals("-showversion")) && (Util.getUserProperty("specjvm.miniter", null) == null || Util.getUserProperty("specjvm.miniter", null).equals(Util.getDefaultProperty("specjvm.miniter", null))) && (Util.getUserProperty("specjvm.maxiter", null) == null || Util.getUserProperty("specjvm.maxiter", null).equals(Util.getDefaultProperty("specjvm.maxiter", null))) && (Util.getUserProperty("specjvm.benchmark.warmup.time", null) == null || Util.getUserProperty("specjvm.benchmark.warmup.time", null).equals(Util.getDefaultProperty("specjvm.benchmark.warmup.time", null))) && (Util.getUserProperty("specjvm.iteration.time", null) == null || Util.getUserProperty("specjvm.iteration.time", null).equals(Util.getDefaultProperty("specjvm.iteration.time", null)))) {
                defaultProperties = defaultPropertiesSPECbase;
                propsRequirements = propsRequirementsSPECbase;
                Launch.workLoad = "SPECjvm2008 Base";
            } else {
                defaultProperties = defaultPropertiesSPECpeak;
                propsRequirements = propsRequirementsSPECpeak;
                Launch.workLoad = "SPECjvm2008 Peak";
            }
        }
        Enumeration<Object> dk = defaultProperties.keys();
        while (dk.hasMoreElements()) {
            key = (String)dk.nextElement();
            Configuration.validateProperty(sResult, key, Util.getProperty(key, null), Util.getDefaultProperty(key, null), propsRequirements.get(key), key);
            StringTokenizer st = new StringTokenizer(benchmarks);
            while (st.hasMoreElements()) {
                String bm = st.nextToken().trim();
                Configuration.validateProperty(sResult, key + "." + bm, Util.getProperty(key, bm), Util.getDefaultProperty(key, bm), propsRequirements.get(key), key);
            }
        }
        Enumeration<Object> sk = userProperties.keys();
        while (sk.hasMoreElements()) {
            key = (String)sk.nextElement();
            if (key.startsWith("spec.jvm2008.report")) continue;
            boolean found = defaultProperties.containsKey(key);
            StringTokenizer st = new StringTokenizer("startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation");
            while (!found && st.hasMoreElements()) {
                String shortKey;
                String bm = st.nextToken().trim();
                if (!key.endsWith("." + bm) || !defaultProperties.containsKey(shortKey = key.substring(0, key.length() - 1 - bm.length()))) continue;
                found = true;
            }
            if (found) continue;
            Configuration.addViolation(sResult, key, "Property " + key + " unknown.");
        }
        try {
            AnalyzersRunner.setupAnalyzerClasses(Util.getProperty("specjvm.benchmark.analyzer.names", null));
        }
        catch (Throwable t) {
            throw new StopBenchmarkException("Error setting up analyzers: " + t.getClass().getName() + ": " + t.getMessage(), t);
        }
    }

    private static void validateProperty(SuiteResult sResult, String key, String value, String defValue, String req, String baseKey) {
        if (req == null) {
            throw new StopBenchmarkException("Requirement for property " + key + " is not set.");
        }
        if (key != null && key.equals("specjvm.benchmarks")) {
            if (req.equals("MATCH")) {
                if (value == null || !value.equals(defValue)) {
                    Configuration.addViolation(sResult, baseKey, "Not a compliant sequence of benchmarks for publication.");
                }
            } else {
                throw new StopBenchmarkException("Don't know how to handle requirement " + req + " for property " + key);
            }
        }
        if (req.equals("WHATEVER")) {
            if (value == null && defValue != null || value != null && defValue == null || value != null && !value.equals(defValue)) {
                Configuration.addConfigurationDetail(sResult, baseKey, key + "=" + value);
            }
        } else if (req.equals("NOT_SET")) {
            if (value != null) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " not allowed in publication run.");
            }
        } else if (req.equals("MATCH")) {
            if (value == null || !value.equals(defValue)) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " must be " + defValue + " for publication.");
            }
        } else if (req.equals("TIME_MAX_5s")) {
            if (value == null || Util.getTimeAsMillis(value) > 5000L) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " may not be higher than 5 seconds for publication.");
            } else if (!value.equals(defValue)) {
                Configuration.addConfigurationDetail(sResult, baseKey, key + "=" + value);
            }
        } else if (req.equals("AT_LEAST_1_MARK_IF_HIGHER")) {
            try {
                int i = Integer.parseInt(value);
                if (i < 1) {
                    Configuration.addViolation(sResult, baseKey, "Property " + key + " must be at least 1.");
                } else if (i > 1) {
                    Configuration.addConfigurationDetail(sResult, baseKey, key + "=" + value);
                }
            }
            catch (Exception e) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " must be set to an integer.");
            }
        } else if (req.equals("TIME_AT_LEAST")) {
            if (value == null || Util.getTimeAsMillis(value) < Util.getTimeAsMillis(defValue)) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " must be at least " + Util.getTimeAsSeconds(defValue) + " seconds for publication.");
            } else if (!value.equals(defValue)) {
                Configuration.addConfigurationDetail(sResult, baseKey, key + "=" + value);
            }
        } else if (req.equals("SPECIAL")) {
            if (key != null && key.startsWith("specjvm.benchmark.xml.validation.input.dir")) {
                if (value != null && !"resources/xml.validation".equals(value)) {
                    Configuration.addViolation(sResult, baseKey, "Property " + key + " should be either not set or equal to resources/xml.validation" + " for publication.");
                }
            } else if ("specjvm.benchmark.startup.launcher".equals(key) && value != null && !Configuration.checkLauncher(value)) {
                Configuration.addViolation(sResult, baseKey, "Property " + key + " should point to the same as a current launcher for publication.");
            }
        } else {
            throw new StopBenchmarkException("Don't know how to handle requirement: " + req);
        }
    }

    static Properties readProperties(String name) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        if (name != null) {
            String fullFileName = null;
            String potFullFileName = name;
            if (new File(potFullFileName).exists()) {
                fullFileName = potFullFileName;
            } else {
                potFullFileName = Launch.specjvmHomeDir + "/props/" + name;
                if (new File(potFullFileName).exists()) {
                    fullFileName = potFullFileName;
                }
            }
            FileInputStream fisFullFileName = null;
            try {
                fisFullFileName = new FileInputStream(fullFileName);
                props.load(fisFullFileName);
                props.setProperty("specjvm.propfile", fullFileName);
                props.setProperty("specjvm.home.dir", Launch.specjvmHomeDir);
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotFoundException("Can't find properties file '" + name + "'");
            }
            finally {
                fisFullFileName.close();
            }
            String nextFileName = props.getProperty("specjvm.additional.properties.file");
            if (nextFileName != null) {
                String nextFileNameFull = null;
                String nextPotFullFileName = null;
                nextPotFullFileName = nextFileName;
                if (new File(nextPotFullFileName).exists()) {
                    nextFileNameFull = nextPotFullFileName;
                } else {
                    nextPotFullFileName = Launch.specjvmHomeDir + "/props/" + nextFileName;
                    if (new File(nextPotFullFileName).exists()) {
                        nextFileNameFull = nextPotFullFileName;
                    }
                }
                FileInputStream fisFileNameFull = null;
                try {
                    fisFileNameFull = new FileInputStream(nextFileNameFull);
                    props.load(fisFileNameFull);
                }
                catch (FileNotFoundException fnfe) {
                    throw new FileNotFoundException("Can't find additional properties file '" + nextFileName + "'");
                }
                finally {
                    fisFileNameFull.close();
                }
            }
        }
        return props;
    }

    static void addViolation(SuiteResult sResult, String key, String message) {
        if (invalidProperties.get(key) == null) {
            invalidProperties.put(key, message);
            sResult.addViolation(message);
        }
    }

    static void addConfigurationDetail(SuiteResult sResult, String key, String message) {
        if (additionalConfigurationProperties.get(key) == null) {
            additionalConfigurationProperties.put(key, message);
            sResult.addConfiguration(message);
        }
    }

    private static boolean checkLauncher(String launcher) {
        Runtime run = Runtime.getRuntime();
        String launcherLog = "";
        try {
            Process p = run.exec(launcher + " -classpath " + System.getProperty("java.class.path") + " spec.harness.VMVersionTest");
            StartupBenchmarkOutput out = new StartupBenchmarkOutput(p.getInputStream(), true);
            out.start();
            p.waitFor();
            launcherLog = out.log;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return launcherLog.equals(VMVersionTest.getVersionInfo());
    }

    static void setupReportInfo(SuiteResult sr, Properties specjvmProps) {
        if (Launch.verbose) {
            Context.getOut().println("Report values: ");
        }
        sr.addRunInfo("spec.jvm2008.report.run.date", null, new Date().toString());
        sr.addRunInfo("spec.jvm2008.report.run.tester", specjvmProps, System.getProperty("user.name", "n/a"));
        sr.addRunInfo("spec.jvm2008.report.run.submitter", specjvmProps, "n/a");
        sr.addRunInfo("spec.jvm2008.report.run.submitter.url", specjvmProps, "n/a");
        sr.addRunInfo("spec.jvm2008.report.run.location", specjvmProps, "n/a");
        sr.addRunInfo("spec.jvm2008.report.run.license", specjvmProps, "n/a");
        sr.addJvmInfo("spec.jvm2008.report.jvm.name", specjvmProps, System.getProperty("java.vm.name", "n/a"));
        String jvv = System.getProperty("java.vm.version", "");
        String jvi = System.getProperty("java.vm.info", "");
        sr.addJvmInfo("spec.jvm2008.report.jvm.version", specjvmProps, jvv + (jvv.length() > 0 && jvi.length() > 0 ? " " : "") + jvi);
        sr.addJvmInfo("spec.jvm2008.report.jvm.vendor", specjvmProps, System.getProperty("java.vm.vendor", System.getProperty("java.vendor", "n/a")));
        sr.addJvmInfo("spec.jvm2008.report.jvm.vendor.url", specjvmProps, System.getProperty("java.vm.vendor.url", System.getProperty("java.vendor.url", "n/a")));
        sr.addJvmInfo("spec.jvm2008.report.jvm.java.specification", specjvmProps, System.getProperty("java.specification.version", "n/a"));
        sr.addJvmInfo("spec.jvm2008.report.jvm.address.bits", specjvmProps, System.getProperty("sun.arch.data.model", "n/a"));
        sr.addJvmInfo("spec.jvm2008.report.jvm.available.date", specjvmProps, "n/a");
        String[] jvmArgs = Util.parseDefaultJvmArgs();
        sr.addJvmInfo("spec.jvm2008.report.jvm.command.line", specjvmProps, jvmArgs[0]);
        sr.addJvmInfo("spec.jvm2008.report.jvm.command.line.initial.heap.size", specjvmProps, jvmArgs[1]);
        sr.addJvmInfo("spec.jvm2008.report.jvm.command.line.max.heap.size", specjvmProps, jvmArgs[2]);
        String scl = Util.getProperty("specjvm.startup.jvm_options", null);
        sr.addJvmInfo("spec.jvm2008.report.jvm.startup.command.line", specjvmProps, scl != null ? scl : " ");
        String sl = Util.getProperty("specjvm.benchmark.startup.launcher", null);
        sr.addJvmInfo("spec.jvm2008.report.jvm.startup.launcher", specjvmProps, sl != null ? sl : "default");
        sr.addJvmInfo("spec.jvm2008.report.jvm.other.tuning", specjvmProps, " ");
        sr.addJvmInfo("spec.jvm2008.report.jvm.app.class.path", null, System.getProperty("java.class.path", "n/a"));
        sr.addJvmInfo("spec.jvm2008.report.jvm.boot.class.path", null, System.getProperty("sun.boot.class.path", "n/a"));
        sr.addSwInfo("spec.jvm2008.report.os.name", specjvmProps, System.getProperty("os.name", "n/a"));
        sr.addSwInfo("spec.jvm2008.report.os.address.bits", specjvmProps, "n/a");
        sr.addSwInfo("spec.jvm2008.report.os.available.date", specjvmProps, "n/a");
        sr.addSwInfo("spec.jvm2008.report.os.tuning", specjvmProps, " ");
        sr.addSwInfo("spec.jvm2008.report.sw.filesystem", specjvmProps, "n/a");
        sr.addSwInfo("spec.jvm2008.report.sw.other.name", specjvmProps, " ");
        sr.addSwInfo("spec.jvm2008.report.sw.other.tuning", specjvmProps, " ");
        sr.addSwInfo("spec.jvm2008.report.sw.other.available", specjvmProps, " ");
        sr.addHwInfo("spec.jvm2008.report.hw.vendor", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.vendor.url", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.model", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.available", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.vendor", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.vendor.url", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.name", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.speed", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.logical.cpus", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.number.of.chips", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.number.of.cores", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.number.of.cores.per.chip", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.threading.enabled", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.threads.per.core", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.address.bits", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.cache.l1", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.cache.l2", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.cpu.cache.other", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.memory.size", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.memory.details", specjvmProps, "n/a");
        sr.addHwInfo("spec.jvm2008.report.hw.details.other", specjvmProps, "n/a");
    }
}

