/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import spec.harness.Configuration;
import spec.harness.Launch;
import spec.harness.Util;

public class CommandLineParser {
    private static void usage(PrintStream ps) {
        ps.println("Usage: spec.harness.Launch <configuration>");
        ps.println("  -h,   --help                   Show this help.");
        ps.println("        --version                Print version and exit.");
        ps.println("  -sv,  --showversion            Print version and continue.");
        ps.println("        --base                   Run the base compliant run of SPECjvm2008 ");
        ps.println("                                 (default, unless jvm args are specified)");
        ps.println("        --peak                   Run the peak compliant run of SPECjvm2008");
        ps.println("        --lagom                  Run the Lagom benchmark suite, a version");
        ps.println("                                 of SPECjvm2008 that uses a fixed workload.");
        ps.println("  -pf,  --propfile <string>      Use this properties file.");
        ps.println("  -i,   --iterations <int>       How many iterations to run. ");
        ps.println("                                 'inf' means an infinite number.");
        ps.println("  -mi,  --miniter <int>          Minimum number of iterations.");
        ps.println("  -ma,  --maxiter <int>          Maximum number of iterations.");
        ps.println("  -it,  --iterationTime <time>   How long one iteration should be.");
        ps.println("                                 The time is specified as an integer,");
        ps.println("                                 and assumed to be in seconds, or an integer");
        ps.println("                                 with unit, for example 4m (4 minutes).");
        ps.println("                                 Units available are ms, s, m and h.");
        ps.println("                                 If iteration time is too short, based on the");
        ps.println("                                 warmup result, it will be adjusted to handle");
        ps.println("                                 at least 5 operations.");
        ps.println("  -fit, --forceIterationTime <time> As iteration time, but not adjusting time.");
        ps.println("  -wt,  --warmuptime <time>      How long warmup should be.");
        ps.println("                                 Time format is the same as in iteration time.");
        ps.println("  -ops, --operations <int>       Hom many operations each iteration will ");
        ps.println("                                 consist of. It will then be a fixed workload");
        ps.println("                                 and iteration time is ignored.");
        ps.println("  -bt,  --benchmarkThreads <int> How many benchmark threads to use.");
        ps.println("  -ja,  --jvmArgs \"options\"      JVM arguments used for startup subtests.");
        ps.println("  -jl,  --jvmLauncher \"path\"     JVM launcher used for startup subtests.");
        ps.println("  -r,   --reporter <file name>   Invokes the reporter with given file(s).");
        ps.println("                                 The benchmarks will not be run.");
        ps.println("  -v,   --verbose                Print verbose info.");
        ps.println("  -pja, --parseJvmArgs           Parse jvm arguments info for command line,");
        ps.println("                                 including heap settings (uses JMXBean info).");
        ps.println("  -coe, --contintueOnError       Continue to run suite, even if one test fails.");
        ps.println("  -ict, --ignoreCheckTest        Do not run check benchmark.");
        ps.println("  -ikv, --ignoreKitValidation    Do not run checksum validition of");
        ps.println("                                 benchmark kit.");
        ps.println("  -crf, --createRawFile <bool>   Whether to generate a raw file.");
        ps.println("  -ctf, --createTextFile <bool>  Whether to generate text report.");
        ps.println("  -chf, --createHtmlFile <bool>  Whether to generate html report.");
        ps.println("                                 If raw is disabled, so is text and html.");
        ps.println("  -xd,  --xmlDir \"path\"          To set path to xml input files");
        ps.println("  <benchmark>                    Name of benchmark(s) to run. Benchmarks");
        ps.println("                                 with sub-benchmarks is also possible to ");
        ps.println("                                 specify. By default all submission");
        ps.println("                                 benchmarks will be selected.");
        ps.println("");
        ps.println("Benchmarks: startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation");
    }

    private static void version(PrintStream ps) {
        File vf = new File(Launch.specjvmHomeDir + "/version.txt");
        if (vf.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(vf));
                String line = br.readLine();
                while (line != null) {
                    ps.println(line);
                    line = br.readLine();
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ps.println("Version not available.");
        }
    }

    static boolean parseArgs(String[] args, Properties props) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-help") || args[i].equals("/?") || args[i].equalsIgnoreCase("-?")) {
                CommandLineParser.usage(System.out);
                return false;
            }
            if (args[i].equalsIgnoreCase("-vs") || args[i].equalsIgnoreCase("-version") || args[i].equalsIgnoreCase("--version")) {
                CommandLineParser.version(System.out);
                return false;
            }
            if (args[i].equalsIgnoreCase("-r") || args[i].equalsIgnoreCase("-reporter") || args[i].equalsIgnoreCase("--reporter")) {
                if (i + 1 < args.length) {
                    try {
                        String[] rArgs = new String[args.length - i - 1];
                        System.arraycopy(args, i + 1, rArgs, 0, rArgs.length);
                        Launch.createReport(rArgs);
                    }
                    catch (Exception e) {
                        System.out.println("Error creating report: " + e.getMessage());
                        e.printStackTrace(System.out);
                    }
                } else {
                    System.out.println("Argument: " + args[i] + " expects a value.");
                }
                return false;
            }
            if (args[i].equalsIgnoreCase("-sv") || args[i].equalsIgnoreCase("-showversion") || args[i].equalsIgnoreCase("--showversion")) {
                CommandLineParser.version(System.out);
                continue;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("-verbose") || args[i].equalsIgnoreCase("--verbose")) {
                Launch.verbose = true;
                props.setProperty("specjvm.print.verbose", "true");
                props.setProperty("specjvm.print.progress", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("-pja") || args[i].equalsIgnoreCase("--parseJvmArgs")) {
                Launch.parseDefaultArgs = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-pf") || args[i].equalsIgnoreCase("--propfile")) {
                if (i + 1 < args.length) {
                    props.setProperty("specjvm.propfile", args[++i]);
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-rd") || args[i].equalsIgnoreCase("--resultdir")) {
                if (i + 1 < args.length) {
                    props.setProperty("specjvm.result.dir", args[++i]);
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ja") || args[i].equalsIgnoreCase("--jvmArgs")) {
                if (i + 1 < args.length) {
                    props.setProperty("specjvm.startup.jvm_options", args[++i]);
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-jl") || args[i].equalsIgnoreCase("--jvmLauncher")) {
                if (i + 1 < args.length) {
                    props.setProperty("specjvm.benchmark.startup.launcher", args[++i]);
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-i") || args[i].equalsIgnoreCase("--iterations")) {
                if (i + 1 < args.length) {
                    String s;
                    if ((s = args[++i]).equalsIgnoreCase("inf")) {
                        props.put("specjvm.miniter", "-1");
                        props.put("specjvm.maxiter", "-1");
                        continue;
                    }
                    try {
                        Integer.parseInt(s);
                        props.put("specjvm.miniter", s);
                        props.put("specjvm.maxiter", s);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects an integer: " + args[i]);
                    }
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-bt") || args[i].equalsIgnoreCase("--benchmarkThreads")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Integer.parseInt(s);
                        props.put("specjvm.benchmark.threads", s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects an integer, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-wt") || args[i].equalsIgnoreCase("--warmuptime")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Util.getTimeAsMillis(s);
                        props.put("specjvm.benchmark.warmup.time", s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects a time string, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-ops") || args[i].equalsIgnoreCase("--operations")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Integer.parseInt(s);
                        props.put("specjvm.fixed.operations", s);
                        props.put("specjvm.run.type", "1");
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects an integer, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("--verbose")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Boolean.parseBoolean(s);
                        props.put("specjvm.print.verbose", s);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects a boolean value, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-it") || args[i].equalsIgnoreCase("--iterationTime")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Util.getTimeAsMillis(s);
                        props.put("specjvm.iteration.time", s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects a time string, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-fit") || args[i].equalsIgnoreCase("--forceIterationTime")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Util.getTimeAsMillis(s);
                        props.put("specjvm.iteration.time", s);
                        props.put("specjvm.iteration.time.forced", "true");
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects a time string, not: " + args[i]);
                        return false;
                    }
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                return false;
            }
            if (args[i].equalsIgnoreCase("-mi") || args[i].equalsIgnoreCase("--minIter")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Integer.parseInt(s);
                        props.put("specjvm.miniter", s);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects an integer: " + args[i]);
                    }
                    continue;
                }
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ma") || args[i].equalsIgnoreCase("--maxIter")) {
                if (i + 1 < args.length) {
                    String s = args[++i];
                    try {
                        Integer.parseInt(s);
                        props.put("specjvm.maxiter", s);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing " + args[i - 1] + ". Expects an integer: " + args[i]);
                    }
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ss") || args[i].equalsIgnoreCase("--scimarkSize")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.scimark.size", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-xd") || args[i].equalsIgnoreCase("--xmlDir")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.benchmark.xml.validation.input.dir", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-xod") || args[i].equalsIgnoreCase("--xmlOutDir")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.benchmark.xml.transform.out.dir", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-xlod") || args[i].equalsIgnoreCase("--xmlLeaveOutDir")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.benchmark.xml.transform.leave.out.dir", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-coe") || args[i].equalsIgnoreCase("--contintueOnError")) {
                props.put("specjvm.continue.on.error", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ict") || args[i].equalsIgnoreCase("--ignoreCheckTest")) {
                props.put("specjvm.run.initial.check", "false");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ikv") || args[i].equalsIgnoreCase("-icsv") || args[i].equalsIgnoreCase("--ignoreCheckSumValidation")) {
                props.put("specjvm.run.checksum.validation", "false");
                continue;
            }
            if (args[i].equalsIgnoreCase("-crf") || args[i].equalsIgnoreCase("--createRawFile")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.create.xml.report", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-ctf") || args[i].equalsIgnoreCase("--createTextFile")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.create.txt.report", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-chf") || args[i].equalsIgnoreCase("--createHtmlFile")) {
                if (i + 1 < args.length) {
                    props.put("specjvm.create.html.report", args[++i]);
                    continue;
                }
                System.out.println();
                System.out.println("Argument: " + args[i] + " expects a value.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-lagom") || args[i].equalsIgnoreCase("--lagom")) {
                Configuration.defaultProperties = Configuration.defaultPropertiesLagom;
                Configuration.propsRequirements = Configuration.propsRequirementsLagom;
                Launch.workLoad = "SPECjvm2008 Lagom Workload";
                continue;
            }
            if (args[i].equalsIgnoreCase("-base") || args[i].equalsIgnoreCase("--base")) {
                Configuration.defaultProperties = Configuration.defaultPropertiesSPECbase;
                Configuration.propsRequirements = Configuration.propsRequirementsSPECbase;
                Launch.workLoad = "SPECjvm2008 Base";
                continue;
            }
            if (args[i].equalsIgnoreCase("-peak") || args[i].equalsIgnoreCase("--peak")) {
                Configuration.defaultProperties = Configuration.defaultPropertiesSPECpeak;
                Configuration.propsRequirements = Configuration.propsRequirementsSPECpeak;
                Launch.workLoad = "SPECjvm2008 Peak";
                continue;
            }
            if (args[i].length() > 2 && args[i].indexOf(61) > 0 && args[i].startsWith("-D")) {
                int ei = args[i].indexOf(61);
                String key = args[i].substring(2, ei);
                String value = args[i].substring(ei + 1, args[i].length());
                props.put(key, value);
                if (!key.equals("specjvm.home.dir")) continue;
                Launch.specjvmHomeDir = value;
                continue;
            }
            if (args[i].equalsIgnoreCase("all")) {
                props.put("specjvm.benchmarks", "startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation");
                continue;
            }
            if (args[i].equalsIgnoreCase("compiler")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "compiler.compiler compiler.sunflow" : bms + " " + "compiler.compiler compiler.sunflow";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("crypto")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "crypto.aes crypto.rsa crypto.signverify" : bms + " " + "crypto.aes crypto.rsa crypto.signverify";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("scimark")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo" : bms + " " + "scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("scimark.small")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo" : bms + " " + "scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("scimark.large")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.monte_carlo" : bms + " " + "scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.monte_carlo";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("startup")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation" : bms + " " + "startup.helloworld startup.compiler.compiler startup.compiler.sunflow startup.compress startup.crypto.aes startup.crypto.rsa startup.crypto.signverify startup.mpegaudio startup.scimark.fft startup.scimark.lu startup.scimark.monte_carlo startup.scimark.sor startup.scimark.sparse startup.serial startup.sunflow startup.xml.transform startup.xml.validation";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("throughput")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation" : bms + " " + "compiler.compiler compiler.sunflow compress crypto.aes crypto.rsa crypto.signverify derby mpegaudio scimark.fft.large scimark.lu.large scimark.sor.large scimark.sparse.large scimark.fft.small scimark.lu.small scimark.sor.small scimark.sparse.small scimark.monte_carlo serial sunflow xml.transform xml.validation";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (args[i].equalsIgnoreCase("xml")) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? "xml.transform xml.validation" : bms + " " + "xml.transform xml.validation";
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            if (Util.isBenchmark(args[i])) {
                String bms = props.getProperty("specjvm.benchmarks");
                bms = bms == null ? args[i] : bms + " " + args[i];
                props.put("specjvm.benchmarks", bms);
                continue;
            }
            System.out.println("Unknown argument or benchmark: " + args[i] + "\n");
            CommandLineParser.usage(System.out);
            System.out.println("\nUnknown argument or benchmark: " + args[i] + "\n");
            return false;
        }
        return true;
    }
}

