/*
 * Decompiled with CFR 0.152.
 */
package spec.harness;

import java.io.PrintStream;
import spec.harness.Context;
import spec.harness.KnownIssues;
import spec.harness.ProgramRunner;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;
import spec.harness.results.IterationResult;
import spec.harness.results.LoopResult;
import spec.io.ValidityCheckOutputStream;

public abstract class BenchmarkThread
extends Thread {
    private BenchmarkResult bmResult;
    private boolean printProgress = true;
    private int btid;
    private IterationResult itResult = null;
    public static boolean createValidityCheckFiles = false;

    BenchmarkThread(BenchmarkResult bmResult, int threadId) {
        super("BenchmarkThread " + bmResult.getLogicalName() + " " + threadId);
        this.bmResult = bmResult;
        this.btid = threadId;
        createValidityCheckFiles = Util.getBoolProperty("specjvm.generateValidityCheckFiles", bmResult.getLogicalName());
    }

    public int getThreadId() {
        return this.btid;
    }

    public String[] getArgs() {
        return this.bmResult.getArgs();
    }

    public void setItResult(IterationResult itResult) {
        this.itResult = itResult;
    }

    public void setPrintProgress(boolean printProgress) {
        this.printProgress = printProgress;
    }

    public void run() {
        try {
            this.executeIteration();
        }
        catch (Throwable t) {
            System.err.print(t);
        }
    }

    public void setInvalidStartupResult(BenchmarkResult invalidBenchmarkResult, IterationResult invalidIterationResult) {
        this.bmResult = invalidBenchmarkResult;
        this.itResult = invalidIterationResult;
    }

    public boolean executeIteration() {
        LoopResult lResult;
        long lastLoopDoneTime = this.itResult.getStartTime();
        long lastLoopStartTime = this.itResult.getStartTime();
        boolean valid = true;
        int ops = 0;
        int bmts = ProgramRunner.getNoBmHarnessThreads(this.bmResult);
        while (this.itResult.continueToRun() && (this.bmResult.getRunMode() != 1 || (long)ops < this.itResult.getExpectedLoops())) {
            LoopResult lResult2 = this.runLoop(this.itResult);
            lResult2.setLoopCnt(++ops);
            this.itResult.addLoopResults(lResult2);
            valid = lResult2.isValid();
            lastLoopStartTime = lResult2.getStartTime();
            lastLoopDoneTime = lResult2.getEndTime();
            if (!valid) {
                this.itResult.abortRun();
                ProgramRunner.interruptProgramRunner();
                break;
            }
            if (!this.printProgress) continue;
            System.out.print(".");
        }
        double dops = ops;
        boolean lastWorker = this.itResult.incNumberBmThreadsDone();
        if (lastWorker && this.bmResult.getRunMode() == 1) {
            this.itResult.setEndTime(lastLoopDoneTime);
        }
        long iterEndTime = this.itResult.getEndTime();
        if (this.bmResult.getRunMode() == 2 && iterEndTime < lastLoopDoneTime) {
            double extra = (double)(lastLoopDoneTime - iterEndTime) / (double)(lastLoopDoneTime - lastLoopStartTime);
            dops -= extra;
        }
        this.itResult.incOperations(dops);
        if (this.bmResult.getRunMode() == 1) {
            return valid;
        }
        while (bmts > this.itResult.getNumberBmThreadsDone() && (valid = (lResult = this.runLoop(this.itResult)).isValid())) {
            if (!this.printProgress) continue;
            System.out.print(".");
        }
        return valid;
    }

    public LoopResult runLoop(IterationResult iResult) {
        LoopResult lResult = new LoopResult();
        lResult.setStartTime(System.currentTimeMillis());
        lResult.setBmThreadId(this.btid);
        lResult.setIteration(iResult.getIteration());
        try {
            ValidityCheckOutputStream vcos = null;
            PrintStream savedOutStream = null;
            if (Context.getVerify()) {
                savedOutStream = Context.getOut();
                vcos = new ValidityCheckOutputStream(this.bmResult.getRunName());
                Context.setOut(new PrintStream(vcos));
            }
            this.harnessMain();
            if (Context.getVerify()) {
                boolean pass;
                Context.getOut().close();
                Context.setOut(savedOutStream);
                if (createValidityCheckFiles) {
                    vcos.createValidityFile();
                    lResult.addError("Not valid, generate output file run only.");
                    return lResult;
                }
                if (Context.getVerify() && !(pass = vcos.validityCheck(lResult)) && iResult.getBenchmarkResult().getLogicalName().equals("xml.transform") && System.getProperty("java.specification.version", "not_valid").equals("1.5")) {
                    KnownIssues.isKnownIssueXmlTransformRace = true;
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                KnownIssues.isKnownIssueOutOfMemoryError = true;
            }
            String msg = t.getClass().getName() + ": " + t.getMessage();
            lResult.addError(msg);
            Context.getOut().println(msg);
            t.printStackTrace(Context.getOut());
        }
        lResult.setEndTime(System.currentTimeMillis());
        return lResult;
    }

    public abstract void harnessMain();
}

