/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.xml.validation;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import spec.benchmarks.xml.XMLBenchmark;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;
import spec.io.FileCache;

public class Main
extends XMLBenchmark {
    private static final int XSD_NUMBER = 6;
    private static FileCache.CachedFile[] allInstanceBytes;
    private static FileCache.CachedFile[] allSchemaBytes;
    private static Validator[][] allValidators;
    private static String[] schemaNames;
    private static String[] instanceNames;
    private static int[] loops;
    private Validator[] schemaBoundValidator;

    public static String testType() {
        return "multi";
    }

    public static void setupBenchmark() {
        String dirName = Util.getProperty("specjvm.benchmark.xml.validation.input.dir", null);
        try {
            String name;
            int i;
            allInstanceBytes = new FileCache.CachedFile[6];
            FileCache cache = Context.getFileCache();
            for (i = 0; i < 6; ++i) {
                name = Main.getFullName(Main.class, dirName, instanceNames[i]);
                FileCache fileCache = cache;
                fileCache.getClass();
                Main.allInstanceBytes[i] = new FileCache.CachedFile(fileCache, name);
                allInstanceBytes[i].cache();
            }
            allSchemaBytes = new FileCache.CachedFile[6];
            for (i = 0; i < 6; ++i) {
                name = Main.getFullName(Main.class, dirName, schemaNames[i]);
                FileCache fileCache = cache;
                fileCache.getClass();
                Main.allSchemaBytes[i] = new FileCache.CachedFile(fileCache, name);
                allSchemaBytes[i].cache();
            }
            Main.setupValidators(dirName);
        }
        catch (IOException e) {
            e.printStackTrace(Context.getOut());
        }
    }

    private static void setupValidators(String dirName) {
        int threads = Launch.currentNumberBmThreads;
        allValidators = new Validator[threads][6];
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setErrorHandler(null);
            for (int i = 0; i < 6; ++i) {
                String xsdFilename = Main.getFullName(Main.class, dirName, schemaNames[i]);
                File tempURI = new File(xsdFilename);
                Schema precompSchema = tempURI.isAbsolute() ? sf.newSchema(new StreamSource(allSchemaBytes[i].getStream(), tempURI.toURI().toString())) : sf.newSchema(new StreamSource(allSchemaBytes[i].getStream(), xsdFilename));
                for (int j = 0; j < threads; ++j) {
                    Main.allValidators[j][i] = precompSchema.newValidator();
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        this.schemaBoundValidator = allValidators[threadId - 1];
    }

    public void harnessMain() {
        try {
            this.executeWorkload();
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
        }
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }

    private void executeWorkload() throws ParserConfigurationException, IOException, SAXException {
        for (int i = 0; i < 6; ++i) {
            Context.getOut().println("Validating " + instanceNames[i]);
            this.doValidationTests(loops[i], allInstanceBytes[i], this.schemaBoundValidator[i]);
        }
    }

    private void doValidationTests(int loops, FileCache.CachedFile file, Validator schemaValidator) throws ParserConfigurationException, IOException, SAXException {
        for (int i = loops - 1; i >= 0; --i) {
            this.validateSource(i, this.createDomSource(file), schemaValidator);
            this.validateSource(i, this.createSaxSource(file), schemaValidator);
        }
    }

    private void validateSource(int loop, Source source, Validator schemaValidator) {
        schemaValidator.reset();
        schemaValidator.setErrorHandler(null);
        try {
            schemaValidator.validate(source);
            if (loop == 0) {
                Context.getOut().print("\tas " + source.getClass().getName());
                Context.getOut().println(" succeeded. (correct result)");
            }
        }
        catch (SAXException e) {
            Context.getOut().print("\tas " + source.getClass().getName());
            Context.getOut().println(" failed. (Incorrect result)" + Arrays.toString(loops));
        }
        catch (IOException e) {
            Context.getOut().println("Unable to validate due to IOException.");
        }
    }

    static {
        schemaNames = new String[]{"validation_input.xsd", "periodic_table.xsd", "play.xsd", "structure.xsd", "po.xsd", "personal.xsd"};
        instanceNames = new String[]{"validation_input.xml", "periodicxsd.xml", "much_adoxsd.xml", "structure.xml", "po.xml", "personal.xml"};
        loops = new int[]{1, 5, 3, 52, 647, 419};
    }
}

