/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.xml.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import spec.benchmarks.xml.XMLBenchmark;
import spec.benchmarks.xml.transform.BaseOutputStream;
import spec.benchmarks.xml.transform.ExtOutputStream;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;
import spec.io.FileCache;

public class Main
extends XMLBenchmark {
    private static final int LONG_VALIDATION_MODE = 0;
    private static final int SHORT_VALIDATION_MODE = 1;
    private static final int SINGLE_LOOP_MODE = 0;
    private static final int MULTIPLE_LOOP_MODE = 1;
    private static final int INPUT_PAIR = 10;
    private static final String CONTROL_FILE_NAME = "transformations.properties";
    static String OUT_DIR = "xml_out";
    private static final String[] XML_NAMES = new String[]{"chess-fo/Kasparov-Karpov.xml", "jenitennison/index.xml", "jenitennison/text.xml", "nitf/nitf-fishing.xml", "shared/REC-xml-19980210.xml", "recipes/recipes.xml", "dsd/article.xml", "renderx/chess/Kasparov-Karpov.xml", "renderx/examples/balance/balance_sheet.xml", "renderx/examples/meeting/meeting_minutes.xml"};
    private static final String[] XSL_NAMES = new String[]{"chess-fo/chess.xsl", "jenitennison/page.xsl", "jenitennison/markup.xsl", "nitf/nitf-stylized.xsl", "spec-html/xmlspec.xsl", "recipes/recipes.xsl", "dsd/article2html.xsl", "renderx/chess/chess.xsl", "renderx/examples/balance/balance_sheet.xsl", "renderx/examples/meeting/meeting_minutes.xsl"};
    private static final int[] loops = new int[]{2, 18, 31, 34, 1, 10, 12, 3, 11, 23};
    private static FileCache.CachedFile[] xmlInput;
    private static FileCache.CachedFile[] xslInput;
    private static int validationMode;
    private static int loopMode;
    private static Properties longValidationProperties;
    private static Properties[] shortValidationProperties;
    private static String validationFileName;
    private static Transformer[][] allTransformers;
    private Transformer[] precompiledTransformers;
    private BaseOutputStream outputStream;
    private StreamResult streamResult;

    private static void setValidationMode(int mode) {
        validationMode = mode;
    }

    private static int getValidationMode() {
        return validationMode;
    }

    private static void setLoopMode(int mode) {
        loopMode = mode;
    }

    private static int getLoopMode() {
        return loopMode;
    }

    public static String testType() {
        return "multi";
    }

    public static void setupBenchmark() {
        String tmpName = Util.getProperty("specjvm.benchmark.xml.transform.out.dir", null);
        OUT_DIR = tmpName != null ? tmpName : OUT_DIR;
        File file = new File(OUT_DIR);
        validationFileName = Main.getFullName(Main.class, null, CONTROL_FILE_NAME);
        xmlInput = new FileCache.CachedFile[10];
        xslInput = new FileCache.CachedFile[10];
        for (int i = 0; i < 10; ++i) {
            Main.xmlInput[i] = Main.getCachedFile(Main.class, null, XML_NAMES[i]);
            Main.xslInput[i] = Main.getCachedFile(Main.class, null, XSL_NAMES[i]);
        }
        longValidationProperties = new Properties();
        try {
            if (!file.exists()) {
                file.mkdir();
            }
            longValidationProperties.load(new FileInputStream(validationFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Main.setupTransformers();
        Main.setValidationMode(0);
        Main.setLoopMode(0);
        Main main = new Main(new BenchmarkResult(), 1);
        main.harnessMain();
        int threads = Launch.currentNumberBmThreads;
        shortValidationProperties = new Properties[Launch.currentNumberBmThreads];
        Properties outProperties = main.getOutProperties();
        for (int i = 0; i < threads; ++i) {
            Main.shortValidationProperties[i] = (Properties)outProperties.clone();
        }
        Main.setValidationMode(1);
        Main.setLoopMode(1);
    }

    public static void tearDownBenchmark() {
        if (!ExtOutputStream.wasFullVerificationError && !Util.getBoolProperty("specjvm.benchmark.xml.transform.leave.out.dir", null)) {
            Main.remove(new File(OUT_DIR));
        }
    }

    private static void setupTransformers() {
        allTransformers = new Transformer[Launch.currentNumberBmThreads][10];
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            for (int i = 0; i < 10; ++i) {
                Templates precompiledTemplates = transformerFactory.newTemplates(xslInput[i].asNewStreamSource());
                for (int j = 0; j < Launch.currentNumberBmThreads; ++j) {
                    Main.allTransformers[j][i] = precompiledTemplates.newTransformer();
                }
            }
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        if (Main.getValidationMode() == 0) {
            this.setOutputStream(new ExtOutputStream());
            this.setValidationProperties(longValidationProperties);
        } else {
            this.setOutputStream(new BaseOutputStream());
            this.setValidationProperties(shortValidationProperties[threadId - 1]);
        }
        this.precompiledTransformers = allTransformers[threadId - 1];
    }

    public void harnessMain() {
        try {
            for (int i = 0; i < 3; ++i) {
                this.executeWorkload();
            }
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
        }
    }

    public void setOutputStream(BaseOutputStream stream) {
        this.outputStream = stream;
        this.streamResult = new StreamResult(this.outputStream);
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }

    private void setValidationProperties(Properties props) {
        this.outputStream.setValidationProperties(props);
    }

    private Properties getOutProperties() {
        if (this.outputStream instanceof ExtOutputStream) {
            return ((ExtOutputStream)this.outputStream).getOutProperties();
        }
        return null;
    }

    private void executeWorkload() throws TransformerException, ParserConfigurationException, SAXException, IOException {
        for (int i = 0; i < 10; ++i) {
            String propertyNamePrefix = XML_NAMES[i] + ".";
            int loops = Main.getLoopMode() == 0 ? 1 : Main.loops[i];
            Transformer transformer = this.precompiledTransformers[i];
            for (int j = loops - 1; j >= 0; --j) {
                this.transform(transformer, this.createSaxSource(xmlInput[i]), propertyNamePrefix + "SAX", j);
                this.transform(transformer, this.createDomSource(xmlInput[i]), propertyNamePrefix + "DOM", j);
                this.transform(transformer, xmlInput[i].asNewStreamSource(), propertyNamePrefix + "Stream", j);
            }
        }
    }

    private void transform(Transformer transformer, Source source, String descr, int loop) throws TransformerException, ParserConfigurationException, SAXException, IOException {
        transformer.reset();
        this.outputStream.setCurrentProp(descr);
        transformer.transform(source, this.streamResult);
        this.outputStream.checkResult(loop);
    }

    static {
        validationMode = 0;
        loopMode = 0;
    }
}

