/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.xml.transform;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.canonical.Canonicalizer;
import org.w3c.tidy.Tidy;
import spec.benchmarks.xml.XMLBenchmark;
import spec.benchmarks.xml.transform.BaseOutputStream;
import spec.benchmarks.xml.transform.Main;
import spec.harness.Context;
import spec.io.FileCache;

class ExtOutputStream
extends BaseOutputStream {
    private Properties outProperties = new Properties();
    private FileOutputStream writer;
    private FileOutputStream diffOutputStream;
    private String currentFileName;
    private String canonicalizedFileName;
    private String tidyFileName;
    private String diffFileName;
    public static boolean wasFullVerificationError = false;

    private static byte[] getFileArray(String name) {
        FileCache cache;
        FileCache fileCache = cache = Context.getFileCache();
        fileCache.getClass();
        FileCache.CachedFile file = new FileCache.CachedFile(fileCache, name);
        try {
            file.cache();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] result = cache.getByteArray(name);
        file.discard();
        return result;
    }

    public static boolean isDosNewLine(byte[] b, int index) {
        return b[index] == 10;
    }

    public static boolean isUnixNewLine(byte[] b, int index) {
        int incIndex = index + 1;
        return b[index] == 13 && incIndex != b.length && b[incIndex] == 10;
    }

    public boolean checkValidity() {
        byte[] b0 = ExtOutputStream.getFileArray(this.canonicalizedFileName);
        byte[] b1 = ExtOutputStream.getFileArray(XMLBenchmark.getFullName(Main.class, null, this.propertyName + ".canon"));
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        hashMap.put(0, b0);
        hashMap.put(1, b1);
        int lineCounter = 0;
        int[] lineStart = new int[]{0, 0};
        boolean[] fileEnd = new boolean[]{false, false};
        boolean wasErrors = false;
        do {
            byte[] b;
            int i;
            ++lineCounter;
            int[] index = new int[]{lineStart[0], lineStart[1]};
            boolean[] lineEnd = new boolean[]{false, false};
            boolean wasError = false;
            int[] errorStart = new int[]{lineStart[0], lineStart[1]};
            int[] errorEnd = new int[]{lineStart[0], lineStart[1]};
            String[] diffs = new String[]{"", ""};
            int[] errorEndCorrection = new int[]{0, 0};
            do {
                for (i = 0; i < 2; ++i) {
                    b = (byte[])hashMap.get(i);
                    fileEnd[i] = index[i] == b.length;
                    lineEnd[i] = fileEnd[i];
                    if (fileEnd[i]) continue;
                    if (ExtOutputStream.isDosNewLine(b, index[i])) {
                        lineEnd[i] = true;
                        errorEndCorrection[i] = -1;
                        continue;
                    }
                    if (!ExtOutputStream.isUnixNewLine(b, index[i])) continue;
                    lineEnd[i] = true;
                    int n = i;
                    index[n] = index[n] + 1;
                    errorEndCorrection[i] = -2;
                }
                if (!(wasError || lineEnd[0] == lineEnd[1] && (fileEnd[0] || fileEnd[1] || b0[index[0]] == b1[index[1]]))) {
                    wasError = true;
                    errorStart[0] = Math.max(index[0] - 5, lineStart[0]);
                    errorStart[1] = Math.max(index[1] - 5, lineStart[1]);
                }
                for (i = 0; i < 2; ++i) {
                    if (lineEnd[i]) continue;
                    int n = i;
                    index[n] = index[n] + 1;
                }
            } while (!lineEnd[0] || !lineEnd[1]);
            if (wasError) {
                for (i = 0; i < 2; ++i) {
                    b = (byte[])hashMap.get(i);
                    errorEnd[i] = Math.max(Math.min(index[i], b.length) + errorEndCorrection[i], errorStart[i]);
                    diffs[i] = this.filter(new String(b, errorStart[i], errorEnd[i] - errorStart[i]));
                }
                wasError = !diffs[0].equals(diffs[1]);
            }
            for (i = 0; i < 2; ++i) {
                int ind = (i + 1) % 2;
                byte[] b2 = (byte[])hashMap.get(ind);
                if (fileEnd[i] && !fileEnd[ind]) {
                    wasError = true;
                    ++lineCounter;
                    errorEnd[ind] = b2.length;
                    errorStart[ind] = wasError ? errorStart[ind] : index[ind];
                    diffs[ind] = this.filter((wasError ? diffs[ind] : "") + new String(b2, index[ind], b2.length - index[ind]));
                }
                lineStart[i] = index[i] + 1;
            }
            if (wasError) {
                this.writeDiffToFile(lineCounter, errorStart[1], diffs);
            }
            boolean bl = wasErrors = wasErrors || wasError;
        } while (!fileEnd[0] && !fileEnd[1]);
        return !wasErrors;
    }

    private void writeDiffToFile(int line, int column, String[] diffs) {
        try {
            if (this.diffOutputStream == null) {
                this.diffOutputStream = new FileOutputStream(this.diffFileName);
            }
            String message = "line=" + line + ",column=" + column + "\n" + "\texpected:" + diffs[1] + "\n" + "\treceived:" + diffs[0];
            this.diffOutputStream.write(message.getBytes());
        }
        catch (IOException e) {
            System.out.println("IOException at diff generation...\n");
            System.out.println(this.getSendResultsMessage());
            e.printStackTrace();
        }
    }

    public void canonicalize(String inName, String outName) {
        try {
            FileOutputStream outStream = new FileOutputStream(outName);
            FileInputStream inputStream = new FileInputStream(inName);
            Document doc = new Builder().build((InputStream)inputStream);
            new Canonicalizer((OutputStream)outStream).write((Node)doc);
            inputStream.close();
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            wasFullVerificationError = true;
            System.out.println("xom canonicalization of " + this.getCurrentProp() + " crashed.\n");
            System.out.println(this.getSendResultsMessage());
        }
    }

    private void runTidy() {
        try {
            FileInputStream inputStream = new FileInputStream(this.currentFileName);
            FileOutputStream outStream = new FileOutputStream(this.tidyFileName);
            Tidy tidy = new Tidy();
            tidy.setQuiet(true);
            tidy.setShowWarnings(false);
            tidy.setDocType("omit");
            tidy.setXmlOut(true);
            tidy.setCharEncoding(3);
            tidy.setQuoteNbsp(false);
            tidy.parse((InputStream)inputStream, (OutputStream)outStream);
            inputStream.close();
            outStream.close();
        }
        catch (IOException e) {
            wasFullVerificationError = true;
            System.out.println("tidy handling of " + this.getCurrentProp() + " crashed.\n");
            System.out.println(this.getSendResultsMessage());
        }
    }

    public void check(String propsValue) {
        if ("xml".equals(propsValue)) {
            this.canonicalize(this.currentFileName, this.canonicalizedFileName);
        } else if ("html".equals(propsValue)) {
            this.runTidy();
            this.canonicalize(this.tidyFileName, this.canonicalizedFileName);
        }
        try {
            if (!this.checkValidity()) {
                this.handleErrorValidation(0);
                wasFullVerificationError = true;
            }
        }
        catch (Exception e) {
            wasFullVerificationError = true;
            System.out.println("verification of " + this.getCurrentProp() + " crashed.\n");
            System.out.println(this.getSendResultsMessage());
        }
    }

    public String filter(String s) {
        return s.replaceAll("html", "HTML").replaceAll("utf", "UTF");
    }

    public void setCurrentProp(String propertyName) {
        super.setCurrentProp(propertyName);
        try {
            this.currentFileName = Main.OUT_DIR + "/" + propertyName.replaceAll("/", ".") + ".out";
            this.canonicalizedFileName = this.currentFileName + ".canonicalized";
            this.tidyFileName = this.currentFileName + ".tidy.xml";
            this.diffFileName = this.currentFileName + ".diff";
            this.writer = new FileOutputStream(this.currentFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(int b) throws IOException {
        super.write(b);
        this.writer.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        for (int i = offset; i < offset + len; ++i) {
            this.write(b[i]);
        }
    }

    public void reset() {
        super.reset();
        try {
            if (this.diffOutputStream != null) {
                this.diffOutputStream.flush();
                this.diffOutputStream.close();
                this.diffOutputStream = null;
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkResult(int loopNumber) {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.check(this.validiationProperties.getProperty(this.propertyName));
        this.outProperties.put(this.propertyName, "" + this.getCRC());
        this.reset();
    }

    public void handleSuccessfullValidation() {
        this.outProperties.put(this.propertyName, "" + this.getCRC());
    }

    public void handleErrorValidation(int loopNumber) {
        System.out.println("Result of " + this.propertyName + " transformation differs from canonical one.\n" + this.getSendResultsMessage());
    }

    public Properties getOutProperties() {
        return this.outProperties;
    }

    private String getSendResultsMessage() {
        return "(Please send " + this.currentFileName + " or " + this.diffFileName + " along with the reporter's result.)";
    }
}

