/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.xml.transform;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import spec.harness.Context;

class BaseOutputStream
extends OutputStream {
    private long crc = 1L;
    Properties validiationProperties;
    String propertyName;

    BaseOutputStream() {
    }

    public void setCurrentProp(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getCurrentProp() {
        return this.propertyName;
    }

    public void write(int b) throws IOException {
        this.crc = this.crc * 33L + (long)b;
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.crc = this.crc * 33L + (long)b[i];
        }
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        for (int i = offset; i < offset + len; ++i) {
            this.crc = this.crc * 33L + (long)b[i];
        }
    }

    public void reset() {
        this.crc = 1L;
    }

    public long getCRC() {
        return this.crc;
    }

    public String getResult() {
        return "" + this.getCRC();
    }

    public void setValidationProperties(Properties props) {
        this.validiationProperties = props;
    }

    public void checkResult(int loopNumber) {
        if (this.getResult().equals(this.validiationProperties.getProperty(this.propertyName))) {
            if (loopNumber == 0) {
                this.handleSuccessfullValidation();
            }
        } else {
            this.handleErrorValidation(loopNumber);
        }
        this.reset();
    }

    public void handleSuccessfullValidation() {
        Context.getOut().println(this.propertyName + ":PASSED");
    }

    public void handleErrorValidation(int loopNumber) {
        Context.getOut().println(this.propertyName + ":FAILED");
    }
}

