/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import spec.benchmarks.xml.ReportingHandler;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.results.BenchmarkResult;
import spec.io.FileCache;

public abstract class XMLBenchmark
extends SpecJVMBenchmarkBase {
    protected DocumentBuilderFactory documentBuilderFactory;
    protected SAXParserFactory SAXfactory;
    protected ReportingHandler callbackReporter = new ReportingHandler();
    protected DocumentBuilder builder;
    protected SAXParser saxParser;
    protected XMLReader xmlParser;

    public XMLBenchmark(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        this.SAXfactory = SAXParserFactory.newInstance();
        this.SAXfactory.setNamespaceAware(true);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        try {
            this.builder = this.documentBuilderFactory.newDocumentBuilder();
            this.builder.setErrorHandler(this.callbackReporter);
            this.builder.setEntityResolver(this.callbackReporter);
            this.saxParser = this.SAXfactory.newSAXParser();
            this.xmlParser = this.saxParser.getXMLReader();
            this.xmlParser.setErrorHandler(this.callbackReporter);
            this.xmlParser.setEntityResolver(this.callbackReporter);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(Context.getOut());
        }
        catch (SAXException e) {
            e.printStackTrace(Context.getOut());
        }
    }

    public Source createDomSource(FileCache.CachedFile cachedInput) throws SAXException, IOException {
        return new DOMSource(this.builder.parse(cachedInput.asNewInputSource()));
    }

    public Source createSaxSource(FileCache.CachedFile cachedInput) throws IOException {
        return new SAXSource(this.xmlParser, cachedInput.asNewInputSource());
    }

    public static String getFullName(Class cls, String dirName, String name) {
        String suffix = File.separator + name;
        return dirName == null ? Context.getResourceDirFor(cls) + suffix : dirName + suffix;
    }

    public static FileCache.CachedFile getCachedFile(Class cls, String dirName, String name) {
        FileCache fileCache = Context.getFileCache();
        fileCache.getClass();
        FileCache.CachedFile result = new FileCache.CachedFile(fileCache, XMLBenchmark.getFullName(cls, dirName, name));
        try {
            result.cache();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void remove(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                XMLBenchmark.remove(files[i]);
            }
            file.delete();
        }
    }
}

