/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.sunflow;

import org.sunflow.Benchmark;
import org.sunflow.system.UI;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    public static final int resolution = 128;
    private static Benchmark[] benchmarks;
    Benchmark benchmark;

    public static String testType() {
        return "multi";
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        this.benchmark = benchmarks[threadId - 1];
    }

    public static void setupBenchmark() {
        int threads = Util.getIntProperty("specjvm.benchmark.sunflow.threads.per.instance", null);
        int bmThreads = Launch.currentNumberBmThreads;
        benchmarks = new Benchmark[bmThreads];
        for (int i = 0; i < bmThreads; ++i) {
            Main.benchmarks[i] = new BenchmarkImpl(128, false, true, false, threads);
            benchmarks[i].kernelBegin();
        }
    }

    public void harnessMain() {
        this.benchmark.kernelMain();
        this.benchmark.kernelEnd();
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }

    static class BenchmarkImpl
    extends Benchmark {
        public BenchmarkImpl(int resolution, boolean showOutput, boolean showBenchmarkOutput, boolean saveOutput, int threads) {
            super(resolution, showOutput, showBenchmarkOutput, saveOutput, threads);
        }

        public void print(UI.Module m, UI.PrintLevel level, String s) {
            if (!s.startsWith("Loading reference image from") && m == UI.Module.BENCH) {
                Context.getOut().println(UI.formatOutput((UI.Module)m, (UI.PrintLevel)level, (String)s));
            }
            if (level == UI.PrintLevel.ERROR) {
                Context.getOut().println("ERROR...");
            }
        }
    }
}

