/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.startup;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import spec.benchmarks.startup.StartupBenchmarkOutput;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.Util;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    private static boolean RUN_ALL_SCIMARK;
    private static boolean RUN_ALL_CRYPTO;
    private static boolean DEBUG;
    private static int loops;
    private static boolean startupTestValid;
    private String benchmarks = "";

    public static void main(String[] args) {
        Main.runSimple(Main.class, args);
    }

    public static String testType() {
        return "single";
    }

    public static void setupBenchmark() {
        RUN_ALL_SCIMARK = Util.getBoolProperty("specjvm.benchmark.startup.scimark.all", null);
        RUN_ALL_CRYPTO = Util.getBoolProperty("specjvm.benchmark.startup.crypto.all", null);
        DEBUG = Util.getBoolProperty("specjvm.benchmarks.startup.debug", null);
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        for (int i = 0; i < bmResult.getArgs().length; ++i) {
            this.benchmarks = this.benchmarks + bmResult.getArgs()[i] + " ";
        }
    }

    public static synchronized boolean startupTestValid() {
        return startupTestValid;
    }

    public static synchronized void setStartupTestValidity(boolean result) {
        startupTestValid = result;
    }

    public void harnessMain() {
        String jvmOptions;
        Properties systemProperties = System.getProperties();
        String classpath = systemProperties.getProperty("java.class.path");
        String javaHome = systemProperties.getProperty("java.home");
        String javaExe = Util.getProperty("specjvm.benchmark.startup.launcher", null);
        if (javaExe == null) {
            javaExe = javaHome + File.separator + "bin" + File.separator + "java";
        }
        if ((jvmOptions = Util.getProperty("specjvm.startup.jvm_options", null)) == null) {
            jvmOptions = " ";
        }
        int threadsNumber = 1;
        String execString = javaExe + " " + jvmOptions + " -classpath " + classpath + " -D" + "specjvm.home.dir" + "=" + System.getProperty("specjvm.home.dir", ".") + " spec.harness.Launch -bt " + threadsNumber + " -ops " + loops + " -crf false -ict -icsv" + " -ss SMALL ";
        String prop = Util.getProperty("specjvm.benchmark.xml.validation.input.dir", null);
        if (prop != null) {
            execString = execString + " -xd " + prop;
        }
        execString = this.benchmarks.startsWith("scimark") && RUN_ALL_SCIMARK ? execString + " scimark.fft.small scimark.lu.small scimark.monte_carlo.small scimark.sor.small scimark.sparse.small" : (this.benchmarks.startsWith("scimark") ? execString + " " + this.benchmarks.trim() + ".small" : (this.benchmarks.startsWith("crypto") && RUN_ALL_CRYPTO ? execString + " crypto.aes  crypto.hash  crypto.rsa crypto.signverify" : execString + " " + this.benchmarks));
        if (DEBUG) {
            System.out.println("Startup Benchmark Execution String: '" + execString + "'");
        }
        Runtime run = Runtime.getRuntime();
        try {
            Process p = run.exec(execString);
            StartupBenchmarkOutput out = new StartupBenchmarkOutput(p.getInputStream());
            out.start();
            out.join();
            p.waitFor();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        if (!Main.startupTestValid()) {
            throw new RuntimeException("INVALID: Error Running Startup Test");
        }
    }

    static {
        loops = 1;
    }
}

