/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.serial.data;

import java.io.Serializable;
import java.util.Random;

public class TestPayload
implements Serializable {
    private String name = null;
    private int id = -1;
    private TestPayload child = null;

    public static TestPayload createTestInstance() {
        TestPayload testObject = new TestPayload("foobar", new Random().nextInt());
        TestPayload child = new TestPayload("child", new Random().nextInt());
        testObject.setChild(child);
        return testObject;
    }

    public String toString() {
        return "TestPayLoad(" + this.name + "," + this.id + "," + this.child + ")";
    }

    public TestPayload() {
    }

    public TestPayload(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public void setChild(TestPayload child) {
        this.child = child;
    }

    public TestPayload getChild() {
        return this.child;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentity() {
        return this.name + this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TestPayload) {
            TestPayload tp = (TestPayload)obj;
            if (this.child == null) {
                if (tp.getChild() != null) {
                    return false;
                }
                return this.getIdentity().equals(tp.getIdentity());
            }
            if (tp.getChild() == null) {
                return false;
            }
            if (this.getChild().equals(tp.getChild())) {
                return this.getIdentity().equals(tp.getIdentity());
            }
            return false;
        }
        return false;
    }
}

