/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import spec.benchmarks.serial.Utils;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.StopBenchmarkException;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    static boolean doEquals = true;
    public static Object[][] instances;
    public static ByteArrayOutputStream[] streams;
    public Object[] threadInstances;
    ByteArrayOutputStream bos;

    public static String testType() {
        return "multi";
    }

    public static void main(String[] args) {
        Main.runSimple(Main.class, args);
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
        this.threadInstances = instances[threadId - 1];
        this.bos = streams[threadId - 1];
    }

    public void harnessMain() {
        try {
            this.serialize();
            this.serialize();
            this.serialize();
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
        }
    }

    public static void setupBenchmark() {
        int threads = Launch.currentNumberBmThreads;
        instances = new Object[threads][Utils.classesNumber];
        streams = new ByteArrayOutputStream[threads];
        try {
            for (int i = 0; i < threads; ++i) {
                Main.instances[i] = Utils.createInstances();
                Main.streams[i] = new ByteArrayOutputStream(){

                    public synchronized byte[] toByteArray() {
                        return this.buf;
                    }
                };
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StopBenchmarkException("error in setupBenchmark of serial workload");
        }
    }

    public void serialize() throws Exception {
        BitSet result = Utils.createBitSet();
        this.bos.reset();
        ObjectOutputStream oos = new ObjectOutputStream(this.bos);
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < this.threadInstances.length; ++j) {
                oos.writeObject(this.threadInstances[j]);
            }
            oos.flush();
            oos.reset();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray(), 0, this.bos.size());
        ObjectInputStream ois = new ObjectInputStream(bis);
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < this.threadInstances.length; ++j) {
                Object obj = ois.readObject();
                if (!doEquals) continue;
                result.set(j, result.get(j) && obj.equals(this.threadInstances[j]));
            }
        }
        oos.close();
        ois.close();
        Utils.printResult(Context.getOut(), result);
    }
}

