/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.scimark.utils;

import spec.benchmarks.scimark.utils.Random;
import spec.harness.Context;
import spec.harness.Util;

public class kernel {
    public static int CURRENT_FFT_SIZE = 0x100000;
    public static int CURRENT_SOR_SIZE = 1000;
    public static int CURRENT_SPARSE_SIZE_M = 100000;
    public static int CURRENT_SPARSE_SIZE_nz = 1000000;
    public static int CURRENT_LU_SIZE = 1000;
    public static String CURRENT_FFT_RESULT = "7.68822223098636E-15";
    public static String CURRENT_LU_RESULT = "6.859625172571382E-11";
    public static String CURRENT_SOR_RESULT = "519.2137313757584";
    public static String CURRENT_SPARSE_RESULT = "242020.31251847022";
    public static int LU_LOOPS = 1;
    public static int FFT_LOOPS = 1;
    public static int SOR_LOOPS = 1;
    public static int SPARSE_LOOPS = 1;
    public static int MC_LOOPS = 10;

    public static double[] NewVectorCopy(double[] x) {
        int N = x.length;
        double[] y = new double[N];
        for (int i = 0; i < N; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    public static void CopyVector(double[] B, double[] A) {
        for (double B[i] : A) {
        }
    }

    public static double normabs(double[] x, double[] y) {
        int N = x.length;
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            sum += Math.abs(x[i] - y[i]);
        }
        return sum;
    }

    public static void CopyMatrix(double[][] B, double[][] A) {
        int M = A.length;
        int N = A[0].length;
        int remainder = N & 3;
        for (int i = 0; i < M; ++i) {
            int j;
            double[] Bi = B[i];
            double[] Ai = A[i];
            for (j = 0; j < remainder; ++j) {
                Bi[j] = Ai[j];
            }
            for (j = remainder; j < N; j += 4) {
                Bi[j] = Ai[j];
                Bi[j + 1] = Ai[j + 1];
                Bi[j + 2] = Ai[j + 2];
                Bi[j + 3] = Ai[j + 3];
            }
        }
    }

    public static double[][] RandomizeMatrix(double[][] A, Random R) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = R.nextDouble();
            }
        }
        return A;
    }

    public static double[][] RandomMatrix(int M, int N, Random R) {
        double[][] A = new double[M][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                A[i][j] = R.nextDouble();
            }
        }
        return A;
    }

    public static double[] RandomVector(int N, Random R) {
        double[] A = new double[N];
        for (int i = 0; i < N; ++i) {
            A[i] = R.nextDouble();
        }
        return A;
    }

    public static double[] RandomizeVector(double[] A, Random R) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = R.nextDouble();
        }
        return A;
    }

    public static double[] matvec(double[][] A, double[] x) {
        int N = x.length;
        double[] y = new double[N];
        kernel.matvec(A, x, y);
        return y;
    }

    public static void matvec(double[][] A, double[] x, double[] y) {
        int M = A.length;
        int N = A[0].length;
        for (int i = 0; i < M; ++i) {
            double sum = 0.0;
            double[] Ai = A[i];
            for (int j = 0; j < N; ++j) {
                sum += Ai[j] * x[j];
            }
            y[i] = sum;
        }
    }

    public static void init() {
        String currentDataset = Util.getProperty("specjvm.scimark.size", "DEFAULT");
        if ("SMALL".equals(currentDataset)) {
            CURRENT_FFT_SIZE = 65536;
            CURRENT_SOR_SIZE = 250;
            CURRENT_SPARSE_SIZE_M = 25000;
            CURRENT_SPARSE_SIZE_nz = 62500;
            CURRENT_LU_SIZE = 250;
            CURRENT_FFT_RESULT = "1.9479755659589253E-15";
            CURRENT_LU_RESULT = "1.3607136251092555E-11";
            CURRENT_SOR_RESULT = "125.97382183302308";
            CURRENT_SPARSE_RESULT = "10498.968164601722";
            LU_LOOPS = 64;
            FFT_LOOPS = 64;
            SOR_LOOPS = 16;
            SPARSE_LOOPS = 16;
        } else if ("LARGE".equals(currentDataset)) {
            CURRENT_FFT_SIZE = 0x400000;
            CURRENT_SOR_SIZE = 2048;
            CURRENT_SPARSE_SIZE_M = 200000;
            CURRENT_SPARSE_SIZE_nz = 4000000;
            CURRENT_LU_SIZE = 2048;
            CURRENT_FFT_RESULT = "1.5820104483934885E-14";
            CURRENT_LU_RESULT = "3.3668594294922888E-9";
            CURRENT_SOR_RESULT = "1009.9963165360384";
            CURRENT_SPARSE_RESULT = "985196.4951987901";
            LU_LOOPS = 1;
            FFT_LOOPS = 1;
            SOR_LOOPS = 1;
            SPARSE_LOOPS = 1;
        } else {
            CURRENT_FFT_SIZE = 0x100000;
            CURRENT_SOR_SIZE = 1000;
            CURRENT_SPARSE_SIZE_M = 100000;
            CURRENT_SPARSE_SIZE_nz = 1000000;
            CURRENT_LU_SIZE = 1000;
            CURRENT_FFT_RESULT = "7.68822223098636E-15";
            CURRENT_LU_RESULT = "6.859625172571382E-11";
            CURRENT_SOR_RESULT = "519.2137313757584";
            CURRENT_SPARSE_RESULT = "242020.31251847022";
            LU_LOOPS = 1;
            FFT_LOOPS = 1;
            SOR_LOOPS = 1;
            SPARSE_LOOPS = 1;
        }
    }

    public static final void checkResults(String expectedValue, String gottenValue, int loop) {
        if (expectedValue.equals(gottenValue)) {
            if (loop == 1) {
                Context.getOut().println("The result is correct.");
            }
        } else {
            Context.getOut().println("The result is wrong. The result is " + gottenValue + "  instead of " + expectedValue);
        }
    }
}

