/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.scimark.utils;

public class Random {
    int seed = 0;
    private int[] m;
    private int i = 4;
    private int j = 16;
    private static final int mdig = 32;
    private static final int one = 1;
    private static final int m1 = Integer.MAX_VALUE;
    private static final int m2 = 65536;
    private double dm1 = 4.656612875245797E-10;
    private boolean haveRange = false;
    private double left = 0.0;
    private double right = 1.0;
    private double width = 1.0;

    public Random() {
        this.initialize((int)System.currentTimeMillis());
    }

    public Random(double left, double right) {
        this.initialize((int)System.currentTimeMillis());
        this.left = left;
        this.right = right;
        this.width = right - left;
        this.haveRange = true;
    }

    public Random(int seed) {
        this.initialize(seed);
    }

    public Random(int seed, double left, double right) {
        this.initialize(seed);
        this.left = left;
        this.right = right;
        this.width = right - left;
        this.haveRange = true;
    }

    public final synchronized double nextDouble() {
        int k = this.m[this.i] - this.m[this.j];
        if (k < 0) {
            k += Integer.MAX_VALUE;
        }
        this.m[this.j] = k;
        this.i = this.i == 0 ? 16 : --this.i;
        this.j = this.j == 0 ? 16 : --this.j;
        if (this.haveRange) {
            return this.left + this.dm1 * (double)k * this.width;
        }
        return this.dm1 * (double)k;
    }

    public final synchronized void nextDoubles(double[] x) {
        int N = x.length;
        int remainder = N & 3;
        if (this.haveRange) {
            for (int count = 0; count < N; ++count) {
                int k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count] = this.left + this.dm1 * (double)k * this.width;
            }
        } else {
            int k;
            int count;
            for (count = 0; count < remainder; ++count) {
                k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count] = this.dm1 * (double)k;
            }
            for (count = remainder; count < N; count += 4) {
                k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count] = this.dm1 * (double)k;
                k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count + 1] = this.dm1 * (double)k;
                k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count + 2] = this.dm1 * (double)k;
                k = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (k < 0) {
                    k += Integer.MAX_VALUE;
                }
                this.m[this.j] = k;
                this.j = this.j == 0 ? 16 : --this.j;
                x[count + 3] = this.dm1 * (double)k;
            }
        }
    }

    private void initialize(int seed) {
        this.seed = seed;
        this.m = new int[17];
        int jseed = Math.min(Math.abs(seed), Integer.MAX_VALUE);
        if (jseed % 2 == 0) {
            --jseed;
        }
        int k0 = 9069;
        int k1 = 0;
        int j0 = jseed % 65536;
        int j1 = jseed / 65536;
        for (int iloop = 0; iloop < 17; ++iloop) {
            jseed = j0 * k0;
            j1 = (jseed / 65536 + j0 * k1 + j1 * k0) % 32768;
            j0 = jseed % 65536;
            this.m[iloop] = j0 + 65536 * j1;
        }
        this.i = 4;
        this.j = 16;
    }
}

