/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.scimark.monte_carlo;

import java.io.PrintStream;
import spec.benchmarks.scimark.utils.Random;
import spec.benchmarks.scimark.utils.Stopwatch;
import spec.harness.Context;

public class MonteCarlo {
    static final int SEED = 113;

    public static void main() {
        MonteCarlo mc = new MonteCarlo();
        mc.run();
    }

    public final double num_flops(int Num_samples) {
        return (double)Num_samples * 4.0;
    }

    public final double integrate(int numSamples) {
        Random R = new Random(113);
        int underCurve = 0;
        for (int count = 0; count < numSamples; ++count) {
            double y;
            double x = R.nextDouble();
            if (!(x * x + (y = R.nextDouble()) * y <= 1.0)) continue;
            ++underCurve;
        }
        return (double)underCurve / (double)numSamples * 4.0;
    }

    public double measureMonteCarlo(double min_time, Random R) {
        PrintStream p = Context.getOut();
        Stopwatch Q = new Stopwatch();
        int cycles = 0x1000000;
        double x = 0.0;
        Q.start();
        x = this.integrate(cycles);
        Q.stop();
        p.println(x);
        return this.num_flops(cycles) / Q.read() * 1.0E-6;
    }

    public void run() {
        double min_time = 2.0;
        double res = 0.0;
        Random R = new Random(101010);
        res = this.measureMonteCarlo(min_time, R);
    }
}

