/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.scimark.lu;

import spec.benchmarks.scimark.utils.Random;
import spec.benchmarks.scimark.utils.Stopwatch;
import spec.benchmarks.scimark.utils.kernel;

public class LU {
    int id;
    private double[][] LU_;
    private int[] pivot_;

    public LU(int id) {
        this.id = id;
    }

    public static void main(int id) {
        LU lu = new LU(id);
        lu.run();
    }

    public static final double num_flops(int N) {
        double Nd = N;
        return 2.0 * Nd * Nd * Nd / 3.0;
    }

    protected static double[] new_copy(double[] x) {
        int N = x.length;
        double[] T = new double[N];
        for (int i = 0; i < N; ++i) {
            T[i] = x[i];
        }
        return T;
    }

    protected static double[][] new_copy(double[][] A) {
        int M = A.length;
        int N = A[0].length;
        double[][] T = new double[M][N];
        for (int i = 0; i < M; ++i) {
            double[] Ti = T[i];
            double[] Ai = A[i];
            for (int j = 0; j < N; ++j) {
                Ti[j] = Ai[j];
            }
        }
        return T;
    }

    public static int[] new_copy(int[] x) {
        int N = x.length;
        int[] T = new int[N];
        for (int i = 0; i < N; ++i) {
            T[i] = x[i];
        }
        return T;
    }

    protected static final void insert_copy(double[][] B, double[][] A) {
        int M = A.length;
        int N = A[0].length;
        int remainder = N & 3;
        for (int i = 0; i < M; ++i) {
            int j;
            double[] Bi = B[i];
            double[] Ai = A[i];
            for (j = 0; j < remainder; ++j) {
                Bi[j] = Ai[j];
            }
            for (j = remainder; j < N; j += 4) {
                Bi[j] = Ai[j];
                Bi[j + 1] = Ai[j + 1];
                Bi[j + 2] = Ai[j + 2];
                Bi[j + 3] = Ai[j + 3];
            }
        }
    }

    public double[][] getLU() {
        return LU.new_copy(this.LU_);
    }

    public int[] getPivot() {
        return LU.new_copy(this.pivot_);
    }

    public double[] solve(double[] b) {
        double[] x = LU.new_copy(b);
        this.solve(this.LU_, this.pivot_, x);
        return x;
    }

    public int factor(double[][] A, int[] pivot) {
        int N = A.length;
        int M = A[0].length;
        int minMN = Math.min(M, N);
        for (int j = 0; j < minMN; ++j) {
            int jp = j;
            double t = Math.abs(A[j][j]);
            for (int i = j + 1; i < M; ++i) {
                double ab = Math.abs(A[i][j]);
                if (!(ab > t)) continue;
                jp = i;
                t = ab;
            }
            pivot[j] = jp;
            if (A[jp][j] == 0.0) {
                return 1;
            }
            if (jp != j) {
                double[] tA = A[j];
                A[j] = A[jp];
                A[jp] = tA;
            }
            if (j < M - 1) {
                double recp = 1.0 / A[j][j];
                for (int k = j + 1; k < M; ++k) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] * recp;
                }
            }
            if (j >= minMN - 1) continue;
            for (int ii = j + 1; ii < M; ++ii) {
                double[] Aii = A[ii];
                double[] Aj = A[j];
                double AiiJ = Aii[j];
                for (int jj = j + 1; jj < N; ++jj) {
                    int n = jj;
                    Aii[n] = Aii[n] - AiiJ * Aj[jj];
                }
            }
        }
        return 0;
    }

    public void solve(double[][] LU2, int[] pvt, double[] b) {
        int i;
        int M = LU2.length;
        int N = LU2[0].length;
        int ii = 0;
        for (i = 0; i < M; ++i) {
            int ip = pvt[i];
            double sum = b[ip];
            b[ip] = b[i];
            if (ii == 0) {
                for (int j = ii; j < i; ++j) {
                    sum -= LU2[i][j] * b[j];
                }
            } else if (sum == 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = N - 1; i >= 0; --i) {
            double sum = b[i];
            for (int j = i + 1; j < N; ++j) {
                sum -= LU2[i][j] * b[j];
            }
            b[i] = sum / LU2[i][i];
        }
    }

    public double measureLU(int N, double min_time, Random R) {
        double[][] A = kernel.RandomMatrix(N, N, R);
        double[][] lu = new double[N][N];
        int[] pivot = new int[N];
        Stopwatch Q = new Stopwatch();
        int cycles = 2;
        Q.start();
        for (int i = 0; i < cycles; ++i) {
            kernel.CopyMatrix(lu, A);
            this.factor(lu, pivot);
        }
        Q.stop();
        double[] b = kernel.RandomVector(N, R);
        double[] x = kernel.NewVectorCopy(b);
        this.solve(lu, pivot, x);
        double EPS = 1.0E-12;
        kernel.checkResults(kernel.CURRENT_LU_RESULT, "" + kernel.normabs(b, kernel.matvec(A, x)), this.id);
        if (kernel.normabs(b, kernel.matvec(A, x)) / (double)N > 1.0E-12) {
            return 0.0;
        }
        return LU.num_flops(N) * (double)cycles / Q.read() * 1.0E-6;
    }

    public void run() {
        double min_time = 2.0;
        int LU_size = kernel.CURRENT_LU_SIZE;
        double res = 0.0;
        Random R = new Random(101010);
        res = this.measureLU(LU_size, min_time, R);
    }
}

