/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.scimark.fft;

import spec.benchmarks.scimark.utils.Random;
import spec.benchmarks.scimark.utils.Stopwatch;
import spec.benchmarks.scimark.utils.kernel;

public class FFT {
    int id;
    private static final ThreadLocal<double[]> threadLocalVector = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[kernel.CURRENT_FFT_SIZE];
        }
    };

    public FFT(int id) {
        this.id = id;
    }

    public final double num_flops(int N) {
        double Nd = N;
        double logN = this.log2(N);
        return (5.0 * Nd - 2.0) * logN + 2.0 * (Nd + 1.0);
    }

    public long inst_main(String[] argv) {
        this.run();
        return 0L;
    }

    public void transform(double[] data) {
        this.transform_internal(data, -1);
    }

    public void inverse(double[] data) {
        this.transform_internal(data, 1);
        int nd = data.length;
        int n = nd / 2;
        double norm = 1.0 / (double)n;
        int i = 0;
        while (i < nd) {
            int n2 = i++;
            data[n2] = data[n2] * norm;
        }
    }

    public double test(double[] data) {
        int nd = data.length;
        double[] copy = new double[nd];
        System.arraycopy(data, 0, copy, 0, nd);
        this.transform(data);
        this.inverse(data);
        double diff = 0.0;
        for (int i = 0; i < nd; ++i) {
            double d = data[i] - copy[i];
            diff += d * d;
        }
        return Math.sqrt(diff / (double)nd);
    }

    public double[] makeRandom(int n) {
        int nd = 2 * n;
        double[] data = new double[nd];
        for (int i = 0; i < nd; ++i) {
            data[i] = Math.random();
        }
        return data;
    }

    public static void main(int id) {
        FFT fft = new FFT(id);
        fft.run();
    }

    protected int log2(int n) {
        int log = 0;
        int k = 1;
        while (k < n) {
            k *= 2;
            ++log;
        }
        if (n != 1 << log) {
            throw new Error("FFT: Data length is not a power of 2!: " + n);
        }
        return log;
    }

    protected void transform_internal(double[] data, int direction) {
        if (data.length == 0) {
            return;
        }
        int n = data.length / 2;
        if (n == 1) {
            return;
        }
        int logn = this.log2(n);
        this.bitreverse(data);
        int bit = 0;
        int dual = 1;
        while (bit < logn) {
            double w_real = 1.0;
            double w_imag = 0.0;
            double theta = 2.0 * (double)direction * Math.PI / (2.0 * (double)dual);
            double s = Math.sin(theta);
            double t = Math.sin(theta / 2.0);
            double s2 = 2.0 * t * t;
            for (int b = 0; b < n; b += 2 * dual) {
                int i = 2 * b;
                int j = 2 * (b + dual);
                double wd_real = data[j];
                double wd_imag = data[j + 1];
                data[j] = data[i] - wd_real;
                data[j + 1] = data[i + 1] - wd_imag;
                int n2 = i;
                data[n2] = data[n2] + wd_real;
                int n3 = i + 1;
                data[n3] = data[n3] + wd_imag;
            }
            for (int a = 1; a < dual; ++a) {
                double tmp_real = w_real - s * w_imag - s2 * w_real;
                double tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                for (int b = 0; b < n; b += 2 * dual) {
                    int i = 2 * (b + a);
                    int j = 2 * (b + a + dual);
                    double z1_real = data[j];
                    double z1_imag = data[j + 1];
                    double wd_real = w_real * z1_real - w_imag * z1_imag;
                    double wd_imag = w_real * z1_imag + w_imag * z1_real;
                    data[j] = data[i] - wd_real;
                    data[j + 1] = data[i + 1] - wd_imag;
                    int n4 = i;
                    data[n4] = data[n4] + wd_real;
                    int n5 = i + 1;
                    data[n5] = data[n5] + wd_imag;
                }
            }
            ++bit;
            dual *= 2;
        }
    }

    protected void bitreverse(double[] data) {
        int n = data.length / 2;
        int nm1 = n - 1;
        int j = 0;
        for (int i = 0; i < nm1; ++i) {
            int ii = i << 1;
            int jj = j << 1;
            int k = n >> 1;
            if (i < j) {
                double tmp_real = data[ii];
                double tmp_imag = data[ii + 1];
                data[ii] = data[jj];
                data[ii + 1] = data[jj + 1];
                data[jj] = tmp_real;
                data[jj + 1] = tmp_imag;
            }
            while (k <= j) {
                j -= k;
                k >>= 1;
            }
            j += k;
        }
    }

    public double measureFFT(int N, double mintime, Random R) {
        double[] x = threadLocalVector.get();
        if (x.length != N) {
            x = new double[N];
            threadLocalVector.set(x);
        }
        x = kernel.RandomizeVector(x, R);
        long cycles = 1L;
        Stopwatch Q = new Stopwatch();
        Q.start();
        this.transform(x);
        this.inverse(x);
        Q.stop();
        double EPS = 1.0E-10;
        double fftTest = this.test(x);
        kernel.checkResults(kernel.CURRENT_FFT_RESULT, "" + fftTest, this.id);
        if (fftTest / (double)N > 1.0E-10) {
            return 0.0;
        }
        x = null;
        return this.num_flops(N) * (double)cycles / Q.read() * 1.0E-6;
    }

    public void run() {
        try {
            double min_time = 2.0;
            int FFT_size = kernel.CURRENT_FFT_SIZE;
            double res = 0.0;
            Random R = new Random(101010);
            res = this.measureFFT(FFT_size, min_time, R);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

