/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.mpegaudio;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.zip.CRC32;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import spec.benchmarks.mpegaudio.Main;
import spec.harness.Context;

public class Harness {
    static final int TRACKS_NUMBER = 6;
    static final int FRAMES_LIMIT = 8000;
    long[] result = new long[6];

    private String getName(int index) {
        return Main.prefix + "track" + index + ".mp3";
    }

    public void run(int id) {
        try {
            for (int i = id; i < id + 6; ++i) {
                int ind = i % 6;
                this.result[ind] = this.decode(this.getName(ind));
            }
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
        }
    }

    private void updateCRC32(CRC32 crc32, short[] buffer) {
        int length = buffer.length;
        byte[] b = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            short value = buffer[i];
            b[i] = (byte)buffer[i];
            b[i + length] = (byte)((value & 0xFF00) >> 8);
        }
        crc32.update(b, 0, b.length);
    }

    public long decode(String name) throws BitstreamException, DecoderException, FileNotFoundException {
        Header h;
        Bitstream stream = new Bitstream(new FileInputStream(name));
        Decoder decoder = new Decoder();
        CRC32 crc = new CRC32();
        for (int decodedFrames = 0; decodedFrames < 8000 && (h = stream.readFrame()) != null; ++decodedFrames) {
            this.updateCRC32(crc, ((SampleBuffer)decoder.decodeFrame(h, stream)).getBuffer());
            stream.closeFrame();
        }
        stream.close();
        return crc.getValue();
    }

    public void inst_main(int id) {
        this.run(id);
        for (int i = 0; i < 6; ++i) {
            Context.getOut().println("track" + i + ": " + this.result[i]);
        }
    }
}

