/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.derby;

import java.io.File;
import spec.benchmarks.derby.DerbyHarness;
import spec.benchmarks.derby.Utils;
import spec.harness.Context;
import spec.harness.Launch;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    public static int[] clientsNumber;
    public static int MAX_CLIENTS_NUMBER_PER_DB;
    public static int[] dataBaseNum;
    public static int[] indInDatabase;
    public static int THREADSPERDB;
    public static int HWTFACTOR;
    public static int DATABASES_NUM;

    public static String testType() {
        return "multi";
    }

    static long runBenchmark(int btid) {
        try {
            long res = System.currentTimeMillis();
            int databaseNum = dataBaseNum[btid - 1];
            DerbyHarness.main(btid, dataBaseNum[btid - 1] + 1, clientsNumber[databaseNum], indInDatabase[btid - 1]);
            return System.currentTimeMillis() - res;
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
            return 100L;
        }
    }

    public static int getThrNumber(int benchmarkThreadIndex) {
        if (DATABASES_NUM == 1) {
            return HWTFACTOR;
        }
        if (HWTFACTOR % THREADSPERDB == 0) {
            return THREADSPERDB;
        }
        int threadsLast = HWTFACTOR % THREADSPERDB + THREADSPERDB;
        int half = threadsLast / 2;
        if (DATABASES_NUM - 1 == benchmarkThreadIndex) {
            return half;
        }
        if (DATABASES_NUM == benchmarkThreadIndex) {
            return threadsLast - half;
        }
        return THREADSPERDB;
    }

    private static void configure() {
        HWTFACTOR = Launch.currentNumberBmThreads;
        THREADSPERDB = 4;
        DATABASES_NUM = (HWTFACTOR - 1) / THREADSPERDB + 1;
    }

    public static void setupBenchmark() {
        int i;
        Main.configure();
        clientsNumber = new int[DATABASES_NUM];
        dataBaseNum = new int[HWTFACTOR];
        indInDatabase = new int[HWTFACTOR];
        MAX_CLIENTS_NUMBER_PER_DB = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < clientsNumber.length; ++i2) {
            int clients = Main.getThrNumber(i2 + 1);
            MAX_CLIENTS_NUMBER_PER_DB = Math.max(MAX_CLIENTS_NUMBER_PER_DB, clients);
            Main.clientsNumber[i2] = clients;
        }
        int res = 0;
        for (i = 0; i < clientsNumber.length; ++i) {
            int j = 0;
            while (j < clientsNumber[i]) {
                Main.dataBaseNum[res] = i;
                Main.indInDatabase[res] = j++;
                ++res;
            }
        }
        Utils.print("#hwt\tdatabase\tshift");
        for (i = 0; i < dataBaseNum.length; ++i) {
            Utils.print(i + "\t\t" + dataBaseNum[i] + "\t" + indInDatabase[i]);
        }
        Utils.initRates();
        DerbyHarness.initDatabases();
    }

    public static void tearDownBenchmark() {
        File derbyDir;
        DerbyHarness.shutdownDerbySystem();
        Utils.releaseResources();
        File derbyLogFile = new File("derby.log");
        if (derbyLogFile.exists()) {
            derbyLogFile.delete();
        }
        if ((derbyDir = new File("derby_dir")).exists() && derbyDir.isDirectory()) {
            Main.deleteDirectory(derbyDir);
        }
    }

    public static void deleteDirectory(File root) {
        if (root.exists()) {
            File[] files = root.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Main.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        root.delete();
    }

    public static void main(String[] args) {
        Main.runSimple(Main.class, args);
    }

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public void harnessMain() {
        Main.runBenchmark(super.getThreadId());
    }
}

