/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.derby;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import spec.benchmarks.derby.DataReader;
import spec.benchmarks.derby.DerbyHarness;
import spec.benchmarks.derby.Main;
import spec.benchmarks.derby.Utils;
import spec.harness.StopBenchmarkException;

class InitThread
extends Thread {
    Connection connection;
    private DataReader dataReader;
    private int accounts;

    public InitThread(int databaseIndex, DataReader dataReader, int accounts) throws SQLException {
        this.connection = DerbyHarness.getNestedConnection(databaseIndex);
        this.dataReader = dataReader;
        this.accounts = accounts;
    }

    public void run() {
        try {
            int i;
            PreparedStatement[] pstmt = new PreparedStatement[DerbyHarness.tableNumber];
            for (int i2 = 0; i2 < DerbyHarness.tableNumber; ++i2) {
                pstmt[i2] = this.connection.prepareStatement(Utils.getInsertIntoDurationQuery(DerbyHarness.scale, i2));
            }
            DataReader.Data[] data = new DataReader.Data[Utils.INIT_ARRAYS_SIZE];
            for (i = 0; i < data.length; ++i) {
                data[i] = this.dataReader.new DataReader.Data();
            }
            for (i = 0; i < DerbyHarness.tableNumber; ++i) {
                int[] info;
                while ((info = this.dataReader.getData(data, i))[3] != -1) {
                    if (info[0] == 0) {
                        if (DerbyHarness.trans) {
                            this.connection.commit();
                        }
                        throw new IOException("cannot read input files");
                    }
                    for (int index = 0; index < info[0]; ++index) {
                        int base = info[1] + index * Main.THREADSPERDB;
                        for (int offset = 0; offset < Main.THREADSPERDB; ++offset) {
                            int id = base + offset;
                            DataReader.Data currentData = data[index];
                            pstmt[i].setInt(1, id);
                            pstmt[i].setInt(2, id % this.accounts);
                            for (int j = 0; j < DerbyHarness.scale; ++j) {
                                pstmt[i].setString(3 + j, currentData.durations[j]);
                            }
                            pstmt[i].setBytes(3 + DerbyHarness.scale, currentData.info);
                            pstmt[i].executeUpdate();
                            pstmt[i].clearWarnings();
                        }
                    }
                    if (!DerbyHarness.trans) continue;
                    this.connection.commit();
                }
                if (!DerbyHarness.trans) continue;
                this.connection.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            throw new StopBenchmarkException("Cannot initialize database");
        }
        finally {
            DerbyHarness.connectClose(this.connection);
        }
    }
}

