/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.derby;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import spec.benchmarks.derby.DataReader;
import spec.benchmarks.derby.InitThread;
import spec.benchmarks.derby.Main;
import spec.benchmarks.derby.Utils;
import spec.harness.Context;
import spec.harness.StopBenchmarkException;

public class DerbyHarness {
    static int accountsPerThread;
    static int limitPerThread;
    static boolean prep;
    static boolean trans;
    static boolean readOnly;
    static int scale;
    public static int tableNumber;
    public static int DATABASES_NUM;
    public int clientsNumber;
    public int databaseIndex;
    public int accountsNumber;

    public static void setDerbyProperties() {
        System.setProperty("derby.storage.initialPages", "1000");
        System.setProperty("derby.storage.pageSize", "32768");
        System.setProperty("derby.storage.pageCacheSize", "" + 4000 * Main.DATABASES_NUM);
    }

    public static void initDatabases() {
        DerbyHarness.setDerbyProperties();
        DATABASES_NUM = Main.DATABASES_NUM;
        DerbyHarness.rmDir();
        String DriverName = "org.apache.derby.jdbc.EmbeddedDriver";
        prep = true;
        trans = true;
        readOnly = true;
        accountsPerThread = 250;
        limitPerThread = 50000;
        tableNumber = 2;
        scale = 5;
        Utils.print("Databases: " + DATABASES_NUM);
        Utils.print("MAX CLIENTS per DB: " + Main.MAX_CLIENTS_NUMBER_PER_DB);
        Utils.print("HWT_FACTOR: " + Main.HWTFACTOR);
        Utils.print("accountsPerThread: " + accountsPerThread);
        Utils.print("limitPerThread: " + limitPerThread);
        Utils.print("tablesNumber: " + tableNumber);
        Utils.print("scale: " + scale);
        Utils.print("\ndatabaseIndex\tclients");
        for (int i = 0; i < DATABASES_NUM; ++i) {
            Utils.print(i + 1 + "\t\t" + Main.clientsNumber[i]);
        }
        try {
            Class.forName(DriverName);
            DerbyHarness.createDatabases();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void shutdownDerbySystem() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(int btid, int databaseIndex, int clientsNumber, int shift) throws Exception {
        DerbyHarness Me = new DerbyHarness(btid, databaseIndex, Main.THREADSPERDB, shift);
    }

    static void rmDir() {
        File file = new File("derby_dir");
        if (!file.exists()) {
            return;
        }
        DerbyHarness.removeFile(file);
        file = new File("derby.log");
        file.delete();
    }

    static void removeFile(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                DerbyHarness.removeFile(files[i]);
            }
            file.delete();
        }
    }

    public DerbyHarness(int btid, int databaseIndex, int clientsNumber, int shift) throws Exception {
        this.accountsNumber = clientsNumber * accountsPerThread;
        Utils.print("DerbyHarness(version 108.2)databaseIndex =  " + databaseIndex + ", clientsNumber = " + clientsNumber + ", accounts = " + this.accountsNumber + ", currentClientNumber = " + btid + ", shift = " + shift);
        this.clientsNumber = clientsNumber;
        this.databaseIndex = databaseIndex;
        try {
            Client client = new Client(shift);
            client.run();
            Context.getOut().println(client.resultsToString());
        }
        catch (Exception ex) {
            ex.printStackTrace(Context.getOut());
        }
    }

    static void dropTable(Connection Conn, String name) throws SQLException {
        try {
            Statement stmt = Conn.createStatement();
            stmt.execute("DROP TABLE " + name);
            stmt.clearWarnings();
            if (trans) {
                Conn.commit();
            }
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void dropTables(Connection connection) throws SQLException {
        DerbyHarness.dropTable(connection, "accounts");
        for (int i = 0; i < tableNumber; ++i) {
            DerbyHarness.dropTable(connection, "durations" + i);
        }
    }

    static void createAccountsTable(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        stmt.execute("CREATE TABLE ACCOUNTS (Aid        INTEGER NOT NULL PRIMARY KEY, SUMB        NUMERIC, SUMD        NUMERIC, SUMT        NUMERIC)");
        stmt.clearWarnings();
        if (trans) {
            connection.commit();
        }
        stmt.close();
    }

    static void createDurationsTable(String name, String ind, Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        stmt.execute(Utils.getCreateDurationsTableQuery(name, scale));
        stmt.clearWarnings();
        stmt.execute("CREATE INDEX " + ind + " ON " + name + " (Aid)");
        stmt.clearWarnings();
        if (trans) {
            connection.commit();
        }
        stmt.close();
    }

    static void createTables(Connection connection) throws SQLException {
        DerbyHarness.createAccountsTable(connection);
        for (int i = 0; i < tableNumber; ++i) {
            DerbyHarness.createDurationsTable("DURATIONS" + i, "IND" + i, connection);
        }
    }

    static void fillAccountsTable(Connection connection, int accounts) throws SQLException {
        Statement stmt = connection.createStatement();
        PreparedStatement pstmt = null;
        try {
            String query = "INSERT INTO ACCOUNTS(Aid,sumB,sumD,sumT) VALUES (?,0,0,0)";
            pstmt = connection.prepareStatement(query);
        }
        catch (SQLException e) {
            prep = false;
        }
        for (int i = 0; i < accounts; ++i) {
            pstmt.setInt(1, i);
            pstmt.executeUpdate();
            pstmt.clearWarnings();
        }
        pstmt.close();
        if (trans) {
            connection.commit();
        }
        stmt.close();
    }

    void resetAccountsTable(Connection connection) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            String query = "UPDATE accounts SET sumB = 0, sumD = 0, sumT = 0";
            pstmt = connection.prepareStatement(query);
        }
        catch (SQLException e) {
            prep = false;
        }
        pstmt.executeUpdate();
        pstmt.clearWarnings();
        pstmt.close();
        if (trans) {
            connection.commit();
        }
    }

    static byte[] getSpec(byte[] all, byte[] info) {
        for (int i = 0; i < scale; ++i) {
            System.arraycopy(all, i * 24, info, i * 24, 24);
        }
        return info;
    }

    static void fillDurationsTable(int limit, int accounts, int databaseIndex) throws SQLException, IOException {
        int i;
        tableNumber = 2;
        DataReader dataReader = new DataReader(limit, tableNumber);
        Thread[] threads = new Thread[Utils.INIT_THREADS_NUMBED];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new InitThread(databaseIndex, dataReader, accounts);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new StopBenchmarkException("Cannot initialize database");
            }
        }
        Connection connection = DerbyHarness.getNestedConnection(databaseIndex);
        PreparedStatement[] pstmt = new PreparedStatement[tableNumber];
        for (int i2 = 0; i2 < tableNumber; ++i2) {
            pstmt[i2] = connection.prepareStatement(Utils.getInsertIntoDurationQuery(scale, i2));
        }
        dataReader.close();
    }

    static void fillTables(Connection connection, int limit, int accounts, int databaseIndex) throws SQLException, IOException {
        DerbyHarness.fillAccountsTable(connection, accounts);
        DerbyHarness.fillDurationsTable(limit, accounts, databaseIndex);
    }

    public static void createDatabases() throws Exception {
        Utils.print("Creating database N 1 ...");
        int limit = Main.THREADSPERDB * limitPerThread;
        int accounts = Main.THREADSPERDB * accountsPerThread;
        Utils.print("\trecords in duration table: " + limit + " (" + scale + " call's info per record)");
        Utils.print("\taccounts: " + accounts);
        Utils.print("\t\t(preparing for " + Main.THREADSPERDB + " clients)");
        DerbyHarness.createBaseDatabase(limit, accounts, Main.THREADSPERDB);
        if (Utils.MULTI_THREAD_RESTORING) {
            int i;
            Thread[] threads = new Thread[DATABASES_NUM - 1];
            for (i = 2; i < DATABASES_NUM + 1; ++i) {
                threads[i - 2] = new Thread("jdbc:derby:derby_dir/name" + i){

                    public void run() {
                        DerbyHarness.doRestoring(this.getName());
                    }
                };
                threads[i - 2].start();
            }
            for (i = 2; i < DATABASES_NUM + 1; ++i) {
                threads[i - 2].join();
            }
        } else {
            for (int i = 2; i < DATABASES_NUM + 1; ++i) {
                DerbyHarness.doRestoring("jdbc:derby:derby_dir/name" + i);
            }
        }
    }

    private static void doRestoring(String databaseName) {
        try {
            Utils.print("Creating database N " + databaseName + " ...");
            Connection conn = DriverManager.getConnection(databaseName + ";createFrom=" + "derby_dir/backup/name1");
            DerbyHarness.connectClose(conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new StopBenchmarkException("Cannot create " + databaseName);
        }
    }

    public static void createBaseDatabase(int limit, int accounts, int clients) throws Exception {
        Connection connection = DerbyHarness.getStartConnection(1);
        DerbyHarness.dropTables(connection);
        DerbyHarness.createTables(connection);
        DerbyHarness.fillTables(connection, limit, accounts, 1);
        CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, "derby_dir/backup");
        cs.execute();
        cs.close();
        DerbyHarness.connectClose(connection);
    }

    public static Connection getNestedConnection(int databaseIndex) {
        try {
            Connection conn = DriverManager.getConnection("jdbc:derby:derby_dir/name" + databaseIndex);
            try {
                if (trans) {
                    conn.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                e.printStackTrace(Context.getOut());
            }
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
            return null;
        }
    }

    public static Connection getStartConnection(int databaseIndex) {
        try {
            Connection conn = DriverManager.getConnection("jdbc:derby:derby_dir/name" + databaseIndex + ";create=true");
            try {
                if (trans) {
                    conn.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                e.printStackTrace(Context.getOut());
            }
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
            return null;
        }
    }

    public static void connectClose(Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace(Context.getOut());
        }
    }

    static {
        scale = 5;
    }

    class Client {
        byte[] buffer = new byte[32];
        BigDecimal[] accResults = Utils.initResultsArray(null);
        int[] spec = new int[4];
        private Connection connection;
        private int shift;
        BigDecimal[] results = Utils.initResultsArray(null);
        BigDecimal allCalls = BigDecimal.ZERO;
        int counter = 0;
        StringBuilder sb = new StringBuilder();
        BigDecimal min = new BigDecimal(Long.MAX_VALUE);
        BigDecimal max = BigDecimal.ZERO;
        byte[] callsSpec;

        public Client(int shift) {
            this.connection = DerbyHarness.getNestedConnection(DerbyHarness.this.databaseIndex);
            this.shift = shift;
        }

        public void run() {
            this.handleAccounts();
            DerbyHarness.connectClose(this.connection);
            this.connection = null;
        }

        public String resultsToString() {
            this.sb.setLength(0);
            this.sb.append("sumB: " + this.results[0]);
            this.sb.append("\nsumD: " + this.results[1]);
            this.sb.append("\nsumT: " + this.results[2]);
            this.sb.append("\nmin call time: " + this.min);
            this.sb.append("\nmax call time: " + this.max);
            this.sb.append("\nmean call time: " + this.allCalls.divide(BigDecimal.valueOf(this.counter), MathContext.DECIMAL64));
            return this.sb.toString();
        }

        private void handleAccounts() {
            block13: {
                if (this.connection == null) {
                    Context.getOut().println("ERROR: connection == null");
                    return;
                }
                try {
                    PreparedStatement[] pstmt1 = new PreparedStatement[tableNumber];
                    PreparedStatement pstmt2 = null;
                    if (prep) {
                        int i;
                        for (i = 0; i < tableNumber; ++i) {
                            pstmt1[i] = this.connection.prepareStatement(Utils.getPreparedSelectQuery(i));
                        }
                        pstmt2 = this.connection.prepareStatement("UPDATE accounts SET sumB = ?, sumD = ?,sumT = ? WHERE Aid = ?");
                        for (i = this.shift; i < DerbyHarness.this.accountsNumber; i += Main.THREADSPERDB) {
                            this.accResults = Utils.initResultsArray(this.accResults);
                            for (int j = 0; j < tableNumber; ++j) {
                                int ind = (this.shift + j) % tableNumber;
                                pstmt1[ind].setInt(1, i);
                                this.handleResultSet(pstmt1[ind].executeQuery());
                                pstmt1[ind].clearWarnings();
                            }
                            pstmt2.setBigDecimal(1, this.accResults[0]);
                            pstmt2.setBigDecimal(2, this.accResults[1]);
                            pstmt2.setBigDecimal(3, this.accResults[2]);
                            pstmt2.setInt(4, i);
                            pstmt2.executeUpdate();
                            pstmt2.clearWarnings();
                            this.results = Utils.add(this.results, this.accResults);
                        }
                    } else {
                        Statement stmt = null;
                        for (int i = this.shift; i < DerbyHarness.this.accountsNumber; i += DerbyHarness.this.clientsNumber) {
                            this.accResults = Utils.initResultsArray(this.accResults);
                            for (int j = 0; j < tableNumber; ++j) {
                                int ind = (this.shift + j) % tableNumber;
                                stmt = this.connection.createStatement();
                                this.handleResultSet(stmt.executeQuery(Utils.getSelectQuery(ind, i)));
                                stmt.clearWarnings();
                            }
                            this.results = Utils.add(this.results, this.accResults);
                            this.results = Utils.add(this.results, this.results);
                            stmt.execute(Utils.getUpdateAccountsQuery(this.results, i));
                            stmt.clearWarnings();
                            stmt.close();
                        }
                    }
                    if (trans) {
                        this.connection.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(Context.getOut());
                    if (!trans) break block13;
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace(Context.getOut());
                    }
                }
            }
        }

        private void handleResultSet(ResultSet RS) throws SQLException, IOException {
            while (RS.next()) {
                this.callsSpec = RS.getBytes(scale + 3);
                for (int i = 0; i < scale; ++i) {
                    this.doComputing(new BigDecimal(RS.getString(3 + i), MathContext.DECIMAL64), i, this.callsSpec);
                }
            }
            RS.close();
        }

        private int getTimeIndex(long time) {
            int res1 = 0;
            long tmp = time;
            for (int i = 0; i < 20; ++i) {
                res1 = (int)((long)res1 + tmp % 10L);
                tmp /= 10L;
            }
            return res1 % 15;
        }

        private BigDecimal getRates(boolean needBaseRate, Object key) {
            return (BigDecimal)(needBaseRate ? Utils.BASERATES : Utils.DISRATES).get(key);
        }

        private void updateStatistic(BigDecimal n) {
            if (n.compareTo(this.min) < 0 && n.longValue() != 0L) {
                this.min = n;
            } else if (n.compareTo(this.max) > 0) {
                this.max = n;
            }
            ++this.counter;
            this.allCalls = this.allCalls.add(n);
        }

        private void doComputing(BigDecimal n, int shift, byte[] callSpec) throws IOException {
            this.updateStatistic(n);
            int[] info = Utils.bytesToInts(callSpec, shift * 24, this.spec);
            int time = this.getTimeIndex(Utils.bytesToLong(callSpec, 16 + shift * 24));
            boolean calltype = (info[2] & 1) == 0;
            BigDecimal RATE = this.getRates(calltype, Utils.keys[info[0]][info[1]][time]);
            BigDecimal BASETAX = Utils.BASETAXES[info[3]];
            BigDecimal DISTAX = Utils.DISTAXES[info[3]];
            BigDecimal p = RATE.multiply(n, MathContext.DECIMAL64);
            BigDecimal b = p.divide(BASETAX, 2, 1);
            this.accResults[0] = this.accResults[0].add(b);
            BigDecimal t = p.add(b);
            BigDecimal d = BigDecimal.ZERO;
            if (!calltype) {
                d = p.divide(DISTAX, MathContext.DECIMAL64);
                d = d.setScale(2, 1);
                t = t.add(d);
                this.accResults[1] = this.accResults[1].add(d);
            }
            t = t.setScale(2, 1);
            this.accResults[2] = this.accResults[2].add(t);
        }
    }
}

