/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.derby;

import java.io.IOException;
import spec.benchmarks.derby.CyclicReader;
import spec.benchmarks.derby.DerbyHarness;
import spec.benchmarks.derby.Main;
import spec.benchmarks.derby.Utils;

public class DataReader {
    private int limit;
    private int start;
    private int end;
    private CyclicReader specsReader = new CyclicReader(Utils.specsFileName, true);
    private CyclicReader callsReader = new CyclicReader(Utils.callsFileName, false);
    private boolean[] endOfTablesReached;
    private int currentTable;

    public DataReader(int limit, int tableNumber) {
        this.limit = limit;
        this.endOfTablesReached = new boolean[tableNumber];
    }

    synchronized int[] getData(Data[] data, int index) throws IOException {
        if (this.isEndOfTableReached(index)) {
            return new int[]{0, this.start, this.end, -1};
        }
        for (int i = 0; i < data.length; ++i) {
            if (this.end != this.limit) {
                if (this.specsReader.read(data[i].inbytes, 24 * DerbyHarness.scale) > 0 && this.callsReader.read(data[i].durations) > 0) {
                    data[i].info = DerbyHarness.getSpec(data[i].inbytes, data[i].info);
                    if (i == 0) {
                        this.start = this.end;
                    }
                    this.end += Main.THREADSPERDB;
                    continue;
                }
                return new int[]{i, this.start, this.end, 0};
            }
            int[] result = new int[]{i, this.start, this.end, i == 0 ? -1 : 0};
            if (this.currentTable < this.endOfTablesReached.length) {
                this.endOfTablesReached[this.currentTable] = true;
            }
            ++this.currentTable;
            this.end = 0;
            this.start = 0;
            return result;
        }
        return new int[]{data.length, this.start, this.end, 0};
    }

    void close() {
        this.specsReader.close();
        this.callsReader.close();
    }

    private synchronized boolean isEndOfTableReached(int index) {
        return index < this.currentTable || index == this.currentTable && this.endOfTablesReached[index];
    }

    public class Data {
        byte[] inbytes = new byte[24 * DerbyHarness.scale];
        String[] durations = new String[DerbyHarness.scale];
        byte[] info = new byte[24 * DerbyHarness.scale];
    }
}

