/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.derby;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CyclicReader {
    private FileInputStream fis;
    private BufferedInputStream bis;
    private String fileName;
    private BufferedReader bReader;
    private File file;
    private FileReader reader;
    boolean binary;

    CyclicReader(String fileName, boolean binary) {
        this.fileName = fileName;
        this.binary = binary;
        this.init();
    }

    private void init() {
        try {
            if (this.binary) {
                this.fis = new FileInputStream(this.fileName);
                this.bis = new BufferedInputStream(this.fis);
            } else {
                this.file = new File(this.fileName);
                this.reader = new FileReader(this.file);
                this.bReader = new BufferedReader(this.reader);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    void close() {
        try {
            if (this.binary) {
                this.fis.close();
                this.bis.close();
            } else {
                this.reader.close();
                this.bReader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int read(byte[] bytes, int length) throws IOException {
        if (this.binary) {
            int result = 0;
            result = this.bis.read(bytes, 0, length);
            if (result < 0) {
                this.close();
                this.init();
                result = this.bis.read(bytes, 0, length);
            }
            return result;
        }
        return -1;
    }

    int read(String[] values) throws IOException {
        if (!this.binary) {
            for (int i = 0; i < values.length; ++i) {
                String value;
                if (this.bReader.ready()) {
                    value = this.bReader.readLine();
                } else {
                    this.close();
                    this.init();
                    if (this.bReader.ready()) {
                        value = this.bReader.readLine();
                    } else {
                        return -1;
                    }
                }
                values[i] = value;
            }
            return 1;
        }
        return -1;
    }
}

