/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.crypto.signverify;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import spec.benchmarks.crypto.Util;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.StopBenchmarkException;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    private static PublicKey rsaPub;
    private static PrivateKey rsaPriv;
    private static PublicKey dsaPub;
    private static PrivateKey dsaPriv;
    private static final int iterations = 10;

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public static String testType() {
        return "multi";
    }

    public byte[] sign(byte[] indata, String algorithm, PrivateKey privKey) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privKey);
            signature.update(indata);
            return signature.sign();
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in verify for " + algorithm + ".", e);
        }
    }

    public boolean verify(byte[] indata, String algorithm, byte[] signed, PublicKey pubKey) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(pubKey);
            signature.update(indata);
            return signature.verify(signed);
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in verify for " + algorithm + ".", e);
        }
    }

    public void runSignVerify(byte[] indata, String algorithm, PrivateKey privKey, PublicKey pubKey) {
        byte[] signed = this.sign(indata, algorithm, privKey);
        boolean verification = this.verify(indata, algorithm, signed, pubKey);
        if (verification) {
            Context.getOut().println(algorithm + " Verification PASS");
        } else {
            Context.getOut().println(algorithm + " Verification FAILED.");
        }
    }

    public void harnessMain() {
        for (int i = 0; i < 10; ++i) {
            Context.getOut().println("Iteration " + i + ".");
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_4), "MD5withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_4), "SHA1withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_4), "SHA1withDSA", dsaPriv, dsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_4), "SHA256withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_5), "MD5withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_5), "SHA1withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_5), "SHA1withDSA", dsaPriv, dsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_5), "SHA256withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_6), "MD5withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_6), "SHA1withRSA", rsaPriv, rsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_6), "SHA1withDSA", dsaPriv, dsaPub);
            this.runSignVerify(Util.getTestData(Util.TEST_DATA_6), "SHA256withRSA", rsaPriv, rsaPub);
        }
    }

    public static void setupBenchmark() {
        try {
            Context.getFileCache().loadFile(Util.TEST_DATA_4);
            Context.getFileCache().loadFile(Util.TEST_DATA_5);
            Context.getFileCache().loadFile(Util.TEST_DATA_6);
            KeyPairGenerator rsaKeyPairGen = KeyPairGenerator.getInstance("RSA");
            rsaKeyPairGen.initialize(1024);
            KeyPair rsaKeyPair = rsaKeyPairGen.generateKeyPair();
            rsaPub = rsaKeyPair.getPublic();
            rsaPriv = rsaKeyPair.getPrivate();
            KeyPairGenerator dsaKeyPairGen = KeyPairGenerator.getInstance("DSA");
            dsaKeyPairGen.initialize(1024);
            KeyPair dsaKeyPair = dsaKeyPairGen.generateKeyPair();
            dsaPub = dsaKeyPair.getPublic();
            dsaPriv = dsaKeyPair.getPrivate();
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error in setup of crypto.aes." + e);
        }
    }

    public static void createTestData() throws IOException {
        Util.createRandomTestData(Util.TEST_DATA_4, 1024);
        Util.createRandomTestData(Util.TEST_DATA_5, 16384);
        Util.createRandomTestData(Util.TEST_DATA_6, 0x100000);
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }
}

