/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.crypto.rsa;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import spec.benchmarks.crypto.Util;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.StopBenchmarkException;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    static final int level = 1;
    static PublicKey rsaPub;
    static PrivateKey rsaPriv;

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public static String testType() {
        return "multi";
    }

    public byte[] encrypt(byte[] indata, String algorithm) {
        try {
            Cipher c = Cipher.getInstance(algorithm);
            byte[] result = indata;
            c.init(1, rsaPub);
            result = c.doFinal(result);
            return result;
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in encrypt for " + algorithm + ".", e);
        }
    }

    public byte[] decrypt(byte[] indata, String algorithm) {
        try {
            Cipher c = Cipher.getInstance(algorithm);
            byte[] result = indata;
            c.init(2, rsaPriv);
            result = c.doFinal(result);
            return result;
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in decrypt for " + algorithm + ".", e);
        }
    }

    public void runSingleEncryptDecrypt(String algorithm, String inputFile) {
        byte[] indata = Util.getTestData(inputFile);
        Context.getOut().println("Algorithm=" + algorithm + " indata length=" + indata.length);
        byte[] cipher = this.encrypt(indata, algorithm);
        byte[] plain = this.decrypt(cipher, algorithm);
        boolean match = Util.check(indata, plain);
        Context.getOut().println(algorithm + ":" + " plaincheck=" + Util.checkSum(plain) + (match ? " PASS" : " FAIL"));
    }

    public void runMultiEncryptDecrypt(String algorithm, String inputFile) {
        int blockSize = 64;
        byte[] fullIndata = Util.getTestData(inputFile);
        byte[] indata = new byte[blockSize];
        int pass = 0;
        int fail = 0;
        int check = 0;
        Context.getOut().println("Algorithm=" + algorithm + " indata length=" + fullIndata.length);
        int i = 0;
        while (i + blockSize < fullIndata.length) {
            System.arraycopy(fullIndata, i, indata, 0, blockSize);
            byte[] cipher = this.encrypt(indata, algorithm);
            byte[] plain = this.decrypt(cipher, algorithm);
            if (Util.check(indata, plain)) {
                ++pass;
                check += Util.checkSum(plain);
            } else {
                ++fail;
            }
            i += blockSize;
        }
        Context.getOut().println(algorithm + ":" + " checksum=" + check + " pass=" + pass + " fail=" + fail);
    }

    public void harnessMain() {
        this.runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
        this.runMultiEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_5);
        this.runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
        this.runMultiEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_5);
        this.runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
    }

    public static void setupBenchmark() {
        try {
            Context.getFileCache().loadFile(Util.TEST_DATA_3);
            Context.getFileCache().loadFile(Util.TEST_DATA_5);
            KeyPairGenerator rsaKeyPairGen = KeyPairGenerator.getInstance("RSA");
            rsaKeyPairGen.initialize(1024);
            KeyPair rsaKeyPair = rsaKeyPairGen.generateKeyPair();
            rsaPub = rsaKeyPair.getPublic();
            rsaPriv = rsaKeyPair.getPrivate();
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error in setup of crypto.aes." + e);
        }
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }
}

