/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.crypto.aes;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import spec.benchmarks.crypto.Util;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.StopBenchmarkException;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    public static final boolean DEBUG = false;
    static final int aesKeySize = 128;
    static final int desKeySize = 168;
    static final int level = 12;
    static SecretKey aesKey = null;
    static SecretKey desKey = null;
    static KeyGenerator aesKeyGen = null;
    static KeyGenerator desKeyGen = null;
    AlgorithmParameters algorithmParameters = null;

    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public static String testType() {
        return "multi";
    }

    private void printMe(String name, byte[] arr) {
        System.out.print("  " + name + ":");
        for (int i = 0; i < arr.length; ++i) {
            System.out.print(arr[i]);
        }
        System.out.println();
    }

    private byte[] encrypt(byte[] indata, SecretKey key, String algorithm, int level) {
        byte[] result = indata;
        try {
            Cipher c = Cipher.getInstance(algorithm);
            c.init(1, key);
            this.algorithmParameters = c.getParameters();
            for (int i = 0; i < level; ++i) {
                byte[] r1 = c.update(result);
                byte[] r2 = c.doFinal();
                result = new byte[r1.length + r2.length];
                System.arraycopy(r1, 0, result, 0, r1.length);
                System.arraycopy(r2, 0, result, r1.length, r2.length);
            }
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in encrypt for " + algorithm + ".", e);
        }
        return result;
    }

    private byte[] decrypt(byte[] indata, SecretKey key, String algorithm, int level) {
        byte[] result = indata;
        try {
            Cipher c = Cipher.getInstance(algorithm);
            c.init(2, (Key)key, this.algorithmParameters);
            for (int i = 0; i < level; ++i) {
                byte[] r1 = c.update(result);
                byte[] r2 = c.doFinal();
                result = new byte[r1.length + r2.length];
                System.arraycopy(r1, 0, result, 0, r1.length);
                System.arraycopy(r2, 0, result, r1.length, r2.length);
            }
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Exception in encrypt for " + algorithm + ".", e);
        }
        return result;
    }

    public void runEncryptDecrypt(SecretKey key, String algorithm, String inputFile) {
        byte[] indata = Util.getTestData(inputFile);
        byte[] cipher = this.encrypt(indata, key, algorithm, 12);
        byte[] plain = this.decrypt(cipher, key, algorithm, 12);
        boolean match = Util.check(indata, plain);
        Context.getOut().println(algorithm + ":" + " plaincheck=" + Util.checkSum(plain) + (match ? " PASS" : " FAIL"));
    }

    public void harnessMain() {
        this.runEncryptDecrypt(aesKey, "AES/CBC/NoPadding", Util.TEST_DATA_1);
        this.runEncryptDecrypt(aesKey, "AES/CBC/PKCS5Padding", Util.TEST_DATA_1);
        this.runEncryptDecrypt(desKey, "DESede/CBC/NoPadding", Util.TEST_DATA_1);
        this.runEncryptDecrypt(desKey, "DESede/CBC/PKCS5Padding", Util.TEST_DATA_1);
        this.runEncryptDecrypt(aesKey, "AES/CBC/NoPadding", Util.TEST_DATA_2);
        this.runEncryptDecrypt(aesKey, "AES/CBC/PKCS5Padding", Util.TEST_DATA_2);
        this.runEncryptDecrypt(desKey, "DESede/CBC/NoPadding", Util.TEST_DATA_2);
        this.runEncryptDecrypt(desKey, "DESede/CBC/PKCS5Padding", Util.TEST_DATA_2);
    }

    public static void setupBenchmark() {
        try {
            byte[] seed = new byte[]{4, 7, 1, 1};
            SecureRandom random = new SecureRandom(seed);
            Context.getFileCache().loadFile(Util.TEST_DATA_1);
            Context.getFileCache().loadFile(Util.TEST_DATA_2);
            aesKeyGen = KeyGenerator.getInstance("AES");
            aesKeyGen.init(128, random);
            desKeyGen = KeyGenerator.getInstance("DESede");
            desKeyGen.init(168, random);
            aesKey = aesKeyGen.generateKey();
            desKey = desKeyGen.generateKey();
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Error in setup of crypto.aes." + e);
        }
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }
}

