/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import spec.benchmarks.compress.Compress;
import spec.benchmarks.compress.OutputBuffer;
import spec.harness.Context;
import spec.harness.Launch;

public final class Harness {
    public static final String[] FILES_NAMES = new String[]{"resources/compress/input/202.tar", "resources/compress/input/205.tar", "resources/compress/input/208.tar", "resources/compress/input/209.tar", "resources/compress/input/210.tar", "resources/compress/input/211.tar", "resources/compress/input/213x.tar", "resources/compress/input/228.tar", "resources/compress/input/239.tar", "resources/compress/input/misc.tar"};
    public static final int FILES_NUMBER = FILES_NAMES.length;
    public static final int LOOP_COUNT = 2;
    public static Source[] SOURCES;
    public static byte[][] COMPRESS_BUFFERS;
    public static byte[][] DECOMPRESS_BUFFERS;
    public static Compress CB;

    public void runCompress(int btid) {
        Context.getOut().println("Loop count = 2");
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < FILES_NUMBER; ++j) {
                Source source = SOURCES[j];
                OutputBuffer comprBuffer = Compress.performAction(source.getBuffer(), source.getLength(), 0, COMPRESS_BUFFERS[btid - 1]);
                OutputBuffer decomprBufer = Compress.performAction(COMPRESS_BUFFERS[btid - 1], comprBuffer.getLength(), 1, DECOMPRESS_BUFFERS[btid - 1]);
                Context.getOut().print(source.getLength() + " " + source.getCRC() + " ");
                Context.getOut().print((long)comprBuffer.getLength() + comprBuffer.getCRC() + " ");
                Context.getOut().println(decomprBufer.getLength() + " " + decomprBufer.getCRC());
            }
        }
    }

    public long inst_main(int btid) {
        long startTime = System.currentTimeMillis();
        this.runCompress(btid);
        return System.currentTimeMillis() - startTime;
    }

    static void prepareBuffers() {
        CB = new Compress();
        SOURCES = new Source[FILES_NUMBER];
        for (int i = 0; i < FILES_NUMBER; ++i) {
            Harness.SOURCES[i] = new Source(Context.getSpecBasePath() + "/" + FILES_NAMES[i]);
        }
        DECOMPRESS_BUFFERS = new byte[Launch.currentNumberBmThreads][Source.MAX_LENGTH];
        COMPRESS_BUFFERS = new byte[Launch.currentNumberBmThreads][Source.MAX_LENGTH];
    }

    static class Source {
        private byte[] buffer;
        private long crc;
        private int length;
        static int MAX_LENGTH;

        public Source(String fileName) {
            this.buffer = Source.fillBuffer(fileName);
            this.length = this.buffer.length;
            MAX_LENGTH = Math.max(this.length, MAX_LENGTH);
            CRC32 crc32 = new CRC32();
            crc32.update(this.buffer, 0, this.length);
            this.crc = crc32.getValue();
        }

        long getCRC() {
            return this.crc;
        }

        int getLength() {
            return this.length;
        }

        byte[] getBuffer() {
            return this.buffer;
        }

        private static byte[] fillBuffer(String fileName) {
            try {
                int bytes_read;
                FileInputStream sif = new FileInputStream(fileName);
                int length = (int)new File(fileName).length();
                int counter = 0;
                byte[] result = new byte[length];
                while ((bytes_read = sif.read(result, counter, length - counter)) > 0) {
                    counter += bytes_read;
                }
                sif.close();
                if (counter != length) {
                    Context.getOut().println("ERROR reading test input file");
                }
                return result;
            }
            catch (IOException e) {
                e.printStackTrace(Context.getOut());
                return null;
            }
        }
    }
}

