/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compress;

import spec.benchmarks.compress.CodeTable;
import spec.benchmarks.compress.CompBase;
import spec.benchmarks.compress.Compress;
import spec.benchmarks.compress.InputBuffer;
import spec.benchmarks.compress.OutputBuffer;

final class Decompressor
extends CompBase {
    private int size;
    private CodeTable tabPrefix;
    private SuffixTable tabSuffix;
    private DeStack deStack;

    public Decompressor(InputBuffer in, OutputBuffer out) {
        super(in, out);
        if ((this.input.readByte() & 0xFF) != (Compress.magic_header[0] & 0xFF) || (this.input.readByte() & 0xFF) != (Compress.magic_header[1] & 0xFF)) {
            System.err.println("stdin: not in compressed format");
        }
        this.maxBits = this.input.readByte();
        this.blockCompress = this.maxBits & 0x80;
        this.maxBits &= 0x1F;
        this.maxMaxCode = 1 << this.maxBits;
        if (this.maxBits > 16) {
            System.err.println("stdin: compressed with " + this.maxBits + " bits, can only handle " + 16 + " bits");
        }
        this.bitsNumber = 9;
        this.maxCode = this.getMaxCode();
        this.offset = 0;
        this.size = 0;
        this.clearFlag = 0;
        this.freeEntry = this.blockCompress != 0 ? 257 : 256;
        this.tabPrefix = new CodeTable();
        this.tabSuffix = new SuffixTable();
        this.deStack = new DeStack();
        this.tabPrefix.clear(256);
        this.tabSuffix.init(256);
    }

    public void decompress() {
        int code;
        int oldcode;
        int finchar = oldcode = this.getCode();
        if (oldcode == -1) {
            return;
        }
        this.output.writeByte((byte)finchar);
        while ((code = this.getCode()) > -1) {
            if (code == 256 && this.blockCompress != 0) {
                this.tabPrefix.clear(256);
                this.clearFlag = 1;
                this.freeEntry = 256;
                code = this.getCode();
                if (code == -1) break;
            }
            int incode = code;
            if (code >= this.freeEntry) {
                this.deStack.push((byte)finchar);
                code = oldcode;
            }
            while (code >= 256) {
                this.deStack.push(this.tabSuffix.of(code));
                code = this.tabPrefix.of(code);
            }
            byte by = this.tabSuffix.of(code);
            finchar = by;
            this.deStack.push(by);
            do {
                this.output.writeByte(this.deStack.pop());
            } while (!this.deStack.isEmpty());
            code = this.freeEntry;
            if (code < this.maxMaxCode) {
                this.tabPrefix.set(code, oldcode);
                this.tabSuffix.set(code, (byte)finchar);
                this.freeEntry = code + 1;
            }
            oldcode = incode;
        }
    }

    private int getCode() {
        int bp = 0;
        if (this.clearFlag > 0 || this.offset >= this.size || this.freeEntry > this.maxCode) {
            if (this.freeEntry > this.maxCode) {
                ++this.bitsNumber;
                this.maxCode = this.bitsNumber == this.maxBits ? this.maxMaxCode : this.getMaxCode();
            }
            if (this.clearFlag > 0) {
                this.bitsNumber = 9;
                this.maxCode = this.getMaxCode();
                this.clearFlag = 0;
            }
            this.size = this.input.readBytes(this.buf, this.bitsNumber);
            if (this.size <= 0) {
                return -1;
            }
            this.offset = 0;
            this.size = (this.size << 3) - (this.bitsNumber - 1);
        }
        int rOff = this.offset;
        int bits = this.bitsNumber;
        bp += rOff >> 3;
        int code = this.buf[bp++] >> (rOff &= 7) & Compress.rmask[8 - rOff] & 0xFF;
        bits -= 8 - rOff;
        rOff = 8 - rOff;
        if (bits >= 8) {
            code |= (this.buf[bp++] & 0xFF) << rOff;
            rOff += 8;
            bits -= 8;
        }
        if (bits > 0) {
            code |= (this.buf[bp] & Compress.rmask[bits]) << rOff;
        }
        this.offset += this.bitsNumber;
        return code;
    }

    static final class SuffixTable {
        protected byte[] tab = new byte[65536];

        public byte of(int i) {
            return this.tab[i];
        }

        public void set(int i, byte v) {
            this.tab[i] = v;
        }

        public void init(int size) {
            for (int code = 0; code < size; ++code) {
                this.tab[code] = (byte)code;
            }
        }
    }

    static final class DeStack {
        protected byte[] tab = new byte[8000];
        protected int index;

        public void push(byte c) {
            this.tab[this.index++] = c;
        }

        public byte pop() {
            return this.tab[--this.index];
        }

        public boolean isEmpty() {
            return this.index == 0;
        }
    }
}

