/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compress;

import spec.benchmarks.compress.CodeTable;
import spec.benchmarks.compress.CompBase;
import spec.benchmarks.compress.Compress;
import spec.benchmarks.compress.InputBuffer;
import spec.benchmarks.compress.OutputBuffer;

final class Compressor
extends CompBase {
    private static final int CHECK_GAP = 10000;
    private int ratio;
    private int checkpoint;
    private int inCount;
    private int outCount;
    private int bytesOut;
    private HashTable htab;
    private CodeTable codetab;

    public Compressor(InputBuffer in, OutputBuffer out) {
        super(in, out);
        if (this.maxBits < 9) {
            this.maxBits = 9;
        }
        if (this.maxBits > 16) {
            this.maxBits = 16;
        }
        this.maxMaxCode = 1 << this.maxBits;
        this.bitsNumber = 9;
        this.maxCode = this.getMaxCode();
        this.offset = 0;
        this.bytesOut = 3;
        this.outCount = 0;
        this.clearFlag = 0;
        this.ratio = 0;
        this.inCount = 1;
        this.checkpoint = 10000;
        this.freeEntry = this.blockCompress != 0 ? 257 : 256;
        this.htab = new HashTable();
        this.codetab = new CodeTable();
        this.output.writeByte(Compress.magic_header[0]);
        this.output.writeByte(Compress.magic_header[1]);
        this.output.writeByte((byte)(this.maxBits | this.blockCompress));
    }

    public void compress() {
        int c;
        int fcode;
        int i = 0;
        int hshift = 0;
        int ent = this.input.readByte();
        for (fcode = this.htab.hsize(); fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsizeReg = this.htab.hsize();
        this.htab.clear();
        block1: while ((c = this.input.readByte()) != -1) {
            ++this.inCount;
            fcode = (c << this.maxBits) + ent;
            i = c << hshift ^ ent;
            int temphtab = this.htab.of(i);
            if (temphtab == fcode) {
                ent = this.codetab.of(i);
                continue;
            }
            if (temphtab >= 0) {
                int disp = hsizeReg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsizeReg;
                    }
                    if ((temphtab = this.htab.of(i)) != fcode) continue;
                    ent = this.codetab.of(i);
                    continue block1;
                } while (temphtab > 0);
            }
            this.output(ent);
            ++this.outCount;
            ent = c;
            if (this.freeEntry < this.maxMaxCode) {
                this.codetab.set(i, this.freeEntry++);
                this.htab.set(i, fcode);
                continue;
            }
            if (this.inCount < this.checkpoint || this.blockCompress == 0) continue;
            this.clBlock();
        }
        this.output(ent);
        ++this.outCount;
        this.output(-1);
    }

    private void output(int code) {
        int rOff = this.offset;
        int bits = this.bitsNumber;
        int bp = 0;
        if (code >= 0) {
            bp += rOff >> 3;
            this.buf[bp] = (byte)(this.buf[bp] & Compress.rmask[rOff &= 7] | code << rOff & Compress.lmask[rOff]);
            ++bp;
            code >>= 8 - rOff;
            if ((bits -= 8 - rOff) >= 8) {
                this.buf[bp++] = (byte)code;
                code >>= 8;
                bits -= 8;
            }
            if (bits != 0) {
                this.buf[bp] = (byte)code;
            }
            this.offset += this.bitsNumber;
            if (this.offset == this.bitsNumber << 3) {
                bp = 0;
                bits = this.bitsNumber;
                this.bytesOut += bits;
                do {
                    this.output.writeByte(this.buf[bp++]);
                } while (--bits != 0);
                this.offset = 0;
            }
            if (this.freeEntry > this.maxCode || this.clearFlag > 0) {
                if (this.offset > 0) {
                    this.output.writebytes(this.buf, this.bitsNumber);
                    this.bytesOut += this.bitsNumber;
                }
                this.offset = 0;
                if (this.clearFlag != 0) {
                    this.bitsNumber = 9;
                    this.maxCode = this.getMaxCode();
                    this.clearFlag = 0;
                } else {
                    ++this.bitsNumber;
                    this.maxCode = this.bitsNumber == this.maxBits ? this.maxMaxCode : this.getMaxCode();
                }
            }
        } else {
            if (this.offset > 0) {
                this.output.writebytes(this.buf, (this.offset + 7) / 8);
            }
            this.bytesOut += (this.offset + 7) / 8;
            this.offset = 0;
        }
    }

    private void clBlock() {
        int rat;
        this.checkpoint = this.inCount + 10000;
        rat = this.inCount > 0x7FFFFF ? ((rat = this.bytesOut >> 8) == 0 ? Integer.MAX_VALUE : this.inCount / rat) : (this.inCount << 8) / this.bytesOut;
        if (rat > this.ratio) {
            this.ratio = rat;
        } else {
            this.ratio = 0;
            this.htab.clear();
            this.freeEntry = 257;
            this.clearFlag = 1;
            this.output(256);
        }
    }

    static final class HashTable {
        protected int[] tab = new int[this.size];
        protected int size = 69001;

        public int of(int i) {
            return this.tab[i];
        }

        public void set(int i, int v) {
            this.tab[i] = v;
        }

        public int hsize() {
            return this.size;
        }

        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.tab[i] = -1;
            }
        }
    }
}

